/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.sender.DefaultProvider;

import com.sun.istack.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.wsee.persistence.StoreConnection;
import weblogic.wsee.persistence.StoreException;
import weblogic.wsee.sender.api.SendRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RequestStoreConnection
extends StoreConnection<String, SendRequest> {
    private static final Logger LOGGER = Logger.getLogger(RequestStoreConnection.class.getName());
    private Map<String, List<SendRequest>> _requestsByConvName;
    private ReentrantReadWriteLock _requestLock;
    private Map<String, TreeSet<SendRequest>> _recoveredRequestsByConvName;

    RequestStoreConnection(String string, String string2) throws StoreException {
        super(string, string2);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(" == RequestStoreConnection being created for " + string + " and connection " + string2);
        }
        this._requestsByConvName = new HashMap<String, List<SendRequest>>();
        this._requestLock = new ReentrantReadWriteLock(false);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(" == RequestStoreConnection Created for " + string + " and connection " + string2);
        }
    }

    @Override
    protected void recoveryStarting() {
        this._recoveredRequestsByConvName = new HashMap<String, TreeSet<SendRequest>>();
    }

    @Override
    protected void recoverValue(SendRequest sendRequest) {
        super.recoverValue(sendRequest);
        TreeSet<SendRequest> treeSet = this._recoveredRequestsByConvName.get(sendRequest.getConversationName());
        if (treeSet == null) {
            treeSet = new TreeSet();
            this._recoveredRequestsByConvName.put(sendRequest.getConversationName(), treeSet);
        }
        treeSet.add(sendRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void recoveryComplete() {
        try {
            this._requestLock.writeLock().lock();
            for (String string : this._recoveredRequestsByConvName.keySet()) {
                TreeSet<SendRequest> treeSet = this._recoveredRequestsByConvName.get(string);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("RequestStoreConnection recovered " + treeSet.size() + " requests for conversation: " + string);
                }
                this._requestsByConvName.put(string, new LinkedList<SendRequest>(treeSet));
            }
            Object var5_4 = null;
            this._requestLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this._requestLock.writeLock().unlock();
            throw throwable;
        }
        this._recoveredRequestsByConvName = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendRequest put(String string, SendRequest sendRequest) {
        try {
            this._requestLock.writeLock().lock();
            SendRequest sendRequest2 = super.put(string, sendRequest);
            this.internalAddRequest(sendRequest);
            SendRequest sendRequest3 = sendRequest2;
            Object var6_5 = null;
            this._requestLock.writeLock().unlock();
            return sendRequest3;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this._requestLock.writeLock().unlock();
            throw throwable;
        }
    }

    public SendRequest put(SendRequest sendRequest) throws StoreException {
        return this.put(sendRequest.getMessageId(), sendRequest);
    }

    private void internalAddRequest(SendRequest sendRequest) {
        List<SendRequest> list = this._requestsByConvName.get(sendRequest.getConversationName());
        if (list == null) {
            list = new LinkedList<SendRequest>();
            this._requestsByConvName.put(sendRequest.getConversationName(), list);
        }
        list.add(sendRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SendRequest get(String string, long l) {
        Iterator<SendRequest> iterator;
        block5: {
            SendRequest sendRequest;
            block4: {
                try {
                    this._requestLock.readLock().lock();
                    List<SendRequest> list = this._requestsByConvName.get(string);
                    if (list == null) {
                        SendRequest sendRequest2 = null;
                        Object var9_6 = null;
                        this._requestLock.readLock().unlock();
                        return sendRequest2;
                    }
                    for (SendRequest sendRequest3 : list) {
                        if (sendRequest3.getSequenceNumber() != l) continue;
                        sendRequest = sendRequest3;
                        break block4;
                    }
                    iterator = null;
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    this._requestLock.readLock().unlock();
                    throw throwable;
                }
            }
            Object var9_7 = null;
            this._requestLock.readLock().unlock();
            return sendRequest;
        }
        Object var9_8 = null;
        this._requestLock.readLock().unlock();
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<SendRequest> getPendingRequests(String string) {
        List<SendRequest> list;
        block3: {
            try {
                this._requestLock.readLock().lock();
                list = this._requestsByConvName.get(string);
                if (list != null) break block3;
                ArrayList<SendRequest> arrayList = new ArrayList<SendRequest>();
                Object var5_5 = null;
                this._requestLock.readLock().unlock();
                return arrayList;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this._requestLock.readLock().unlock();
                throw throwable;
            }
        }
        ArrayList<SendRequest> arrayList = new ArrayList<SendRequest>(list);
        Object var5_6 = null;
        this._requestLock.readLock().unlock();
        return arrayList;
    }

    @Override
    public SendRequest remove(Object object) {
        SendRequest sendRequest = (SendRequest)super.remove(object);
        if (sendRequest != null) {
            this.internalRemove(sendRequest);
            return sendRequest;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAllPendingRequests(String string) throws StoreException {
        List<SendRequest> list;
        block4: {
            this._requestLock.writeLock().lock();
            list = this._requestsByConvName.get(string);
            if (list != null) break block4;
            boolean bl = false;
            Object var6_6 = null;
            this._requestLock.writeLock().unlock();
            return bl;
        }
        try {
            list = new ArrayList<SendRequest>(list);
            for (SendRequest sendRequest : list) {
                this.remove(sendRequest);
            }
            boolean bl = true;
            Object var6_7 = null;
            this._requestLock.writeLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this._requestLock.writeLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(SendRequest sendRequest) throws StoreException {
        try {
            this._requestLock.writeLock().lock();
            boolean bl = super.remove(sendRequest.getMessageId()) != null && this.internalRemove(sendRequest);
            Object var4_3 = null;
            this._requestLock.writeLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._requestLock.writeLock().unlock();
            throw throwable;
        }
    }

    private boolean internalRemove(SendRequest sendRequest) {
        List<SendRequest> list = this._requestsByConvName.get(sendRequest.getConversationName());
        if (list == null) {
            return false;
        }
        list.remove(sendRequest);
        if (list.isEmpty()) {
            this._requestsByConvName.remove(sendRequest.getConversationName());
        }
        return true;
    }
}

