/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.server;

import java.security.AccessController;
import weblogic.kernel.Kernel;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.internal.SerializedSystemIni;
import weblogic.security.internal.encryption.EncryptionService;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;

public final class EncryptionUtil {
    private static final AuthenticatedSubject kernelID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static EncryptionService es = null;

    public static byte[] encrypt(byte[] byArray) {
        if (Kernel.isServer()) {
            return EncryptionUtil.getEncryptionService().encryptBytes(byArray);
        }
        return byArray;
    }

    public static byte[] decrypt(byte[] byArray) {
        if (Kernel.isServer()) {
            SecurityServiceManager.checkKernelIdentity((AuthenticatedSubject)kernelID);
            return EncryptionUtil.getEncryptionService().decryptBytes(byArray);
        }
        return byArray;
    }

    private static final EncryptionService getEncryptionService() {
        if (es == null) {
            es = SerializedSystemIni.getExistingEncryptionService();
        }
        return es;
    }
}

