/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.server;

import java.rmi.UnknownHostException;
import java.security.AccessController;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import weblogic.jws.BufferQueue;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.WebServerMBean;
import weblogic.management.configuration.WebServiceMBean;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelManager;
import weblogic.protocol.URLManager;
import weblogic.protocol.configuration.ChannelHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.wsee.server.ServerURLNotFoundException;
import weblogic.wsee.util.StringUtil;

public class ServerUtil {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final String JMS_PROXY_HOST = "weblogic.jms.proxyHost";
    private static final String JMS_PROXY_PORT = "weblogic.jms.proxyPort";
    private static final String HTTP_PROXY_HOST = "http.proxyHost";
    private static final String HTTP_PROXY_PORT = "http.proxyPort";
    private static final String HTTPS_PROXY_HOST = "https.proxyHost";
    private static final String HTTPS_PROXY_PORT = "https.proxyPort";
    private static final int PROTOCOL_JMS = 0;
    private static final int PROTOCOL_HTTP = 1;
    private static final int PROTOCOL_HTTPS = 2;
    private static ServerURLEntry[] SERVER_URLS = new ServerURLEntry[3];
    public static final boolean useReqHostAlways;

    public static String getCallbackServerURL(String string, String string2, String string3, String string4) throws ServerURLNotFoundException {
        return ServerUtil.getServerURL(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getServerURL(String string) throws ServerURLNotFoundException {
        if (string == null) {
            throw new ServerURLNotFoundException("No protocol was provided");
        }
        int n = -1;
        if (string.equals("jms")) {
            n = 0;
        } else if (string.equals("http")) {
            n = 1;
        } else if (string.equals("https")) {
            n = 2;
        }
        if (n == -1) {
            throw new ServerURLNotFoundException("Protocol " + string + " is not supported");
        }
        ServerURLEntry serverURLEntry = SERVER_URLS[n];
        if (serverURLEntry.isExpired()) {
            ServerURLEntry serverURLEntry2 = serverURLEntry;
            synchronized (serverURLEntry2) {
                if (serverURLEntry.isExpired()) {
                    serverURLEntry.setValue(ServerUtil.getServerURL(n));
                }
            }
        }
        return serverURLEntry.getValue();
    }

    public static String getServerURL(int n) throws ServerURLNotFoundException {
        if (n == 0) {
            return ServerUtil.getJMSServerURL();
        }
        if (n == 1) {
            return ServerUtil.getHTTPServerURL(false);
        }
        if (n == 2) {
            return ServerUtil.getHTTPServerURL(true);
        }
        return null;
    }

    public static String getHTTPServerURL(boolean bl, HttpServletRequest httpServletRequest) throws ServerURLNotFoundException {
        String string = null;
        if (useReqHostAlways) {
            string = ServerUtil.formURL(httpServletRequest.getScheme(), httpServletRequest.getServerName(), httpServletRequest.getServerPort());
        }
        if (string == null) {
            string = ServerUtil.getWseeProxyChannelURL(bl ? "https" : "http");
        }
        if (string == null) {
            string = ServerUtil.getFrontEndServerAddress(bl);
        }
        if (string == null) {
            string = ServerUtil.getClusterAddress(bl ? "https" : "http");
        }
        if (string == null) {
            string = ServerUtil.formURL(httpServletRequest.getScheme(), httpServletRequest.getServerName(), httpServletRequest.getServerPort());
        }
        if (string == null) {
            throw new ServerURLNotFoundException("Cannot resolve URL for protocol http/https");
        }
        return string;
    }

    public static String getHTTPServerURL(boolean bl) throws ServerURLNotFoundException {
        String string = ServerUtil.getWseeProxyChannelURL(bl ? "https" : "http");
        if (string == null) {
            string = ServerUtil.getFrontEndServerAddress(bl);
        }
        if (string == null) {
            string = ServerUtil.getClusterAddress(bl ? "https" : "http");
        }
        if (string == null) {
            string = ServerUtil.getLocalServerPublicURL(bl ? "https" : "http");
        }
        if (string == null) {
            throw new ServerURLNotFoundException("Cannot resolve URL for protocol http/https");
        }
        return string;
    }

    public static String getJMSServerURL() {
        String string;
        String string2 = ServerUtil.getClusterAddress("t3");
        if (string2 == null) {
            string2 = ServerUtil.getLocalServerPublicURL("t3");
        }
        if ((string = ServerUtil.swapProtocol(string2, "jms")) == null) {
            throw new ServerURLNotFoundException("Cannot resolve URL for protocol jms");
        }
        return string;
    }

    private static String getFirstURL(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(44);
        if (n <= 0) {
            return string;
        }
        String string2 = string.substring(0, n);
        int n2 = string.lastIndexOf(58);
        if (string2.indexOf(58, 6) < 0 && n2 > 0) {
            return string2 + string.substring(n2);
        }
        return string2;
    }

    private static String getProtocol(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(58);
        if (n <= 0) {
            return null;
        }
        return string.substring(0, n);
    }

    private static String getSystemPropURL(String string) {
        String string2 = string.toLowerCase(Locale.ENGLISH);
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (string2.equals("jms")) {
            string4 = System.getProperty(JMS_PROXY_HOST);
            string5 = System.getProperty(JMS_PROXY_PORT);
            if (string4 != null && string5 != null) {
                string3 = "jms://" + string4 + ":" + string5;
            }
        }
        if (string2.equals("http")) {
            string4 = System.getProperty(HTTP_PROXY_HOST);
            string5 = System.getProperty(HTTP_PROXY_PORT);
            if (string4 != null && string5 != null) {
                string3 = "http://" + string4 + ":" + string5;
            }
        }
        if (string2.equals("https")) {
            string4 = System.getProperty(HTTPS_PROXY_HOST);
            string5 = System.getProperty(HTTPS_PROXY_PORT);
            if (string4 != null && string5 != null) {
                string3 = "https://" + string4 + ":" + string5;
            }
        }
        return string3;
    }

    private static String getWseeProxyChannelURL(String string) {
        String string2 = System.getProperty("weblogic.wsee.proxy.address");
        if (string2 != null) {
            return string2;
        }
        String string3 = string.toLowerCase(Locale.ENGLISH);
        ServerChannel serverChannel = ServerChannelManager.findLocalServerChannel((String)("weblogic-wsee-proxy-channel-" + string3));
        if (serverChannel != null) {
            String string4 = serverChannel.getPublicAddress();
            if (string4 == null) {
                throw new RuntimeException("Public address for the proxy channel is not set");
            }
            if (!string.equalsIgnoreCase(serverChannel.getProtocolPrefix())) {
                throw new RuntimeException("weblogic-wsee-proxy-channel-" + string3 + " should have the protocol be " + string3);
            }
            return ServerUtil.formURL(string3, string4, serverChannel.getPublicPort());
        }
        return null;
    }

    public static String swapProtocol(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        int n = string.indexOf("://");
        if (n <= 0) {
            return null;
        }
        return string2 + string.substring(n, string.length());
    }

    public static String getServerName() {
        return ManagementService.getRuntimeAccess(kernelId).getServerName();
    }

    public static String getDomainName() {
        return ManagementService.getRuntimeAccess(kernelId).getDomainName();
    }

    public static String getLocalServerPublicURL(String string) throws ServerURLNotFoundException {
        String string2 = ServerUtil.getServerName();
        Protocol protocol = ProtocolManager.getProtocolByName((String)string);
        try {
            return URLManager.findURL(string2, protocol);
        }
        catch (UnknownHostException unknownHostException) {
            throw new ServerURLNotFoundException(unknownHostException);
        }
    }

    private static final String getFrontEndServerAddress(boolean bl) {
        WebServerMBean webServerMBean;
        String string = null;
        int n = 0;
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        ClusterMBean clusterMBean = serverMBean.getCluster();
        if (clusterMBean != null && (string = clusterMBean.getFrontendHost()) != null) {
            if (bl) {
                n = clusterMBean.getFrontendHTTPSPort();
                if (n == 0) {
                    n = clusterMBean.getFrontendHTTPPort();
                    bl = false;
                }
            } else {
                n = clusterMBean.getFrontendHTTPPort();
                if (n == 0) {
                    n = clusterMBean.getFrontendHTTPSPort();
                    bl = true;
                }
            }
        }
        if (string == null && (webServerMBean = serverMBean.getWebServer()) != null && (string = webServerMBean.getFrontendHost()) != null) {
            if (bl) {
                n = webServerMBean.getFrontendHTTPSPort();
                if (n == 0) {
                    n = webServerMBean.getFrontendHTTPPort();
                    bl = false;
                }
            } else {
                n = webServerMBean.getFrontendHTTPPort();
                if (n == 0) {
                    n = webServerMBean.getFrontendHTTPSPort();
                    bl = true;
                }
            }
        }
        if (string != null) {
            if (n == 0) {
                throw new IllegalArgumentException("FrontendHTTPPort or FrontendHTTPSPort must be set for " + string);
            }
            if (bl) {
                return ServerUtil.formURL("https", string, n);
            }
            return ServerUtil.formURL("http", string, n);
        }
        return null;
    }

    private static String formURL(String string, String string2, int n) {
        return string + "://" + string2 + ":" + n;
    }

    private static String getClusterAddress(String string) {
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        ClusterMBean clusterMBean = serverMBean.getCluster();
        if (clusterMBean == null) {
            return null;
        }
        String string2 = clusterMBean.getClusterAddress();
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Cluster address must be set when clustering is enabled.");
        }
        ServerChannel serverChannel = ServerChannelManager.findLocalServerChannel((Protocol)ProtocolManager.getProtocolByName((String)string));
        if (serverChannel == null) {
            return null;
        }
        String string3 = ChannelHelper.createClusterURL(serverChannel);
        if (string3 != null) {
            return ServerUtil.getFirstURL(string3);
        }
        return null;
    }

    public static WebServiceMBean getWebServiceMBean() {
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        return serverMBean.getWebService();
    }

    public static String getCallbackQueue() {
        WebServiceMBean webServiceMBean = ServerUtil.getWebServiceMBean();
        if (webServiceMBean != null) {
            return webServiceMBean.getCallbackQueue();
        }
        return "weblogic.wsee.DefaultCallbackQueue";
    }

    public static QueueInfo getCallbackQueueInfo() {
        String string = ServerUtil.getCallbackQueue();
        WebServiceMBean webServiceMBean = ServerUtil.getWebServiceMBean();
        String string2 = webServiceMBean != null ? webServiceMBean.getCallbackQueueMDBRunAsPrincipalName() : null;
        return new QueueInfo(string, string2);
    }

    public static String getMessagingQueue() {
        WebServiceMBean webServiceMBean = ServerUtil.getWebServiceMBean();
        if (webServiceMBean != null) {
            return webServiceMBean.getMessagingQueue();
        }
        return "weblogic.wsee.DefaultQueue";
    }

    public static QueueInfo getMessagingQueueInfo() {
        String string = ServerUtil.getMessagingQueue();
        WebServiceMBean webServiceMBean = ServerUtil.getWebServiceMBean();
        String string2 = webServiceMBean != null ? webServiceMBean.getMessagingQueueMDBRunAsPrincipalName() : null;
        return new QueueInfo(string, string2);
    }

    public static QueueInfo getBufferQueueInfo(String string) {
        QueueInfo queueInfo = ServerUtil.getMessagingQueueInfo();
        if (string == null || StringUtil.isEmpty(string)) {
            return queueInfo;
        }
        if (string.equals("@weblogic.wsee.CallbackQueue@")) {
            return ServerUtil.getCallbackQueueInfo();
        }
        return new QueueInfo(string, queueInfo.getMdbRunAsPrincipalName());
    }

    public static QueueInfo getBufferQueueInfo(Class clazz) {
        QueueInfo queueInfo = ServerUtil.getMessagingQueueInfo();
        if (clazz != null) {
            BufferQueue bufferQueue = clazz.getAnnotation(BufferQueue.class);
            if (bufferQueue == null || StringUtil.isEmpty(bufferQueue.name())) {
                return queueInfo;
            }
            if (bufferQueue.name().equals("@weblogic.wsee.CallbackQueue@")) {
                return ServerUtil.getCallbackQueueInfo();
            }
            return new QueueInfo(bufferQueue.name(), queueInfo.getMdbRunAsPrincipalName());
        }
        return queueInfo;
    }

    public static String getJmsConnectionFactory() {
        WebServiceMBean webServiceMBean = ServerUtil.getWebServiceMBean();
        if (webServiceMBean != null) {
            return webServiceMBean.getJmsConnectionFactory();
        }
        return "weblogic.jms.XAConnectionFactory";
    }

    static {
        for (int i = 0; i < SERVER_URLS.length; ++i) {
            ServerUtil.SERVER_URLS[i] = new ServerURLEntry();
        }
        useReqHostAlways = Boolean.getBoolean("weblogic.wsee.useRequestHost");
    }

    private static class ServerURLEntry {
        private long _cacheTime;
        private String value;
        private static final int MAX_TIME = 3000;

        public String getValue() {
            return this.value;
        }

        public void setValue(String string) {
            this.value = string;
            this._cacheTime = System.currentTimeMillis();
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this._cacheTime > 3000L;
        }
    }

    public static class QueueInfo {
        private String queueName;
        private String mdbRunAsPrincipalName;

        public QueueInfo(String string, String string2) {
            this.queueName = string;
            this.mdbRunAsPrincipalName = string2;
        }

        public String getQueueName() {
            return this.queueName;
        }

        public String getMdbRunAsPrincipalName() {
            return this.mdbRunAsPrincipalName;
        }
    }
}

