/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.server;

import java.util.HashSet;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.work.WorkManagerFactory;
import weblogic.wsee.server.StateExpiration;
import weblogic.wsee.server.WsStorage;
import weblogic.wsee.util.Verbose;

public class StoreCleaner {
    private int WSEE_STATE_CLEAN_INTERVAL = 120000;
    private static final String STATE_CLEAN_INTERVAL_PROP = "weblogic.wsee.StateCleanInterval";
    private static final String STATE_CLEAN_DISABLE_PROP = "weblogic.wsee.DisableStateCleaner";
    private static final String STATE_TIMER_MANAGER_NAME = "WseeStoreCleanerTimerManager";
    private boolean suspended = false;
    private boolean started = false;
    private boolean disabled = false;
    private static final boolean verbose = Verbose.isVerbose(StoreCleaner.class);
    private TimerManager tm;
    private Timer timer;
    private WsStorage stg;
    private boolean cleaning = false;

    StoreCleaner(WsStorage wsStorage) {
        this.stg = wsStorage;
        String string = System.getProperty(STATE_CLEAN_INTERVAL_PROP);
        if (string != null && (string = string.trim()).length() != 0) {
            try {
                int n = Integer.parseInt(string);
                if (n < 30000) {
                    n = 30000;
                }
                this.WSEE_STATE_CLEAN_INTERVAL = n;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.disabled = Boolean.getBoolean(STATE_CLEAN_DISABLE_PROP);
        if (verbose) {
            Verbose.say("StoreCLeaner created for " + wsStorage + " with interval " + this.WSEE_STATE_CLEAN_INTERVAL + " msecs  with disabled = " + this.disabled);
        }
        this.tm = TimerManagerFactory.getTimerManagerFactory().getTimerManager(STATE_TIMER_MANAGER_NAME, WorkManagerFactory.getInstance().getSystem());
    }

    void startCleanup() {
        if (this.disabled) {
            return;
        }
        if (!this.started) {
            this.timer = this.tm.schedule((TimerListener)new TimerListenerImpl(), 0L, (long)this.WSEE_STATE_CLEAN_INTERVAL);
            if (verbose) {
                Verbose.say("StoreCLeaner for " + this.stg + " started up");
            }
            this.started = true;
        }
    }

    int getInterval() {
        return this.WSEE_STATE_CLEAN_INTERVAL;
    }

    void setInterval(int n) {
        if (n > 0 && n != this.WSEE_STATE_CLEAN_INTERVAL) {
            this.WSEE_STATE_CLEAN_INTERVAL = n;
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.timer = this.tm.schedule((TimerListener)new TimerListenerImpl(), 0L, (long)this.WSEE_STATE_CLEAN_INTERVAL);
        }
    }

    void stopCleanup() {
        if (this.disabled) {
            return;
        }
        if (this.started) {
            this.tm.stop();
            if (verbose) {
                Verbose.say("StoreCLeaner for " + this.stg + " stopped");
            }
            this.started = false;
        }
    }

    void suspendCleanup() {
        if (this.disabled) {
            return;
        }
        if (this.started && !this.suspended) {
            this.tm.suspend();
            if (verbose) {
                Verbose.say("StoreCLeaner for " + this.stg + " suspended");
            }
            this.suspended = true;
        }
    }

    void resumeCleanup() {
        if (this.disabled) {
            return;
        }
        if (this.started && this.suspended) {
            this.tm.resume();
            if (verbose) {
                Verbose.say("StoreCLeaner for " + this.stg + " resumed");
            }
            this.suspended = false;
        }
    }

    boolean isDisabled() {
        return this.disabled;
    }

    void setDisabled(boolean bl) {
        if (!this.disabled && bl) {
            this.stopCleanup();
        }
        this.disabled = bl;
    }

    private class TimerListenerImpl
    implements TimerListener {
        private TimerListenerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timerExpired(Timer timer) {
            if (verbose) {
                Verbose.say("StoreCleaner for " + StoreCleaner.this.stg + " timer popped");
            }
            TimerListenerImpl timerListenerImpl = this;
            synchronized (timerListenerImpl) {
                if (StoreCleaner.this.cleaning) {
                    if (verbose) {
                        Verbose.say("StoreCleaner for " + StoreCleaner.this.stg + " is already cleaning, bypassing this round of cleaning");
                    }
                    return;
                }
                StoreCleaner.this.cleaning = true;
            }
            try {
                this.doClean();
            }
            finally {
                timerListenerImpl = this;
                synchronized (timerListenerImpl) {
                    StoreCleaner.this.cleaning = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doClean() {
            HashSet hashSet;
            if (verbose) {
                Verbose.log("Now checking persistent state objects");
            }
            Object object = StoreCleaner.this.stg;
            synchronized (object) {
                hashSet = new HashSet(StoreCleaner.this.stg.memKeys());
            }
            if (hashSet != null && !hashSet.isEmpty()) {
                if (verbose) {
                    Verbose.say("StoreCleaner(" + StoreCleaner.this.stg + ") - persistent store has " + hashSet.size() + " invocation objects to check..");
                }
                object = hashSet.iterator();
                while (object.hasNext()) {
                    Object e = object.next();
                    Object object2 = StoreCleaner.this.stg.get(e);
                    if (!(object2 instanceof StateExpiration)) {
                        if (!verbose) continue;
                        Verbose.say("Value " + object2 + "stored in persistent store not an invocation state, but " + (object2 == null ? "null" : object2.getClass().toString()));
                        continue;
                    }
                    StateExpiration stateExpiration = (StateExpiration)object2;
                    if (stateExpiration == null || !stateExpiration.isExpired()) continue;
                    if (verbose) {
                        Verbose.log("Removing expired state " + stateExpiration);
                    }
                    try {
                        StoreCleaner.this.stg.persistentRemove(e);
                        object.remove();
                    }
                    catch (Exception exception) {
                        if (verbose) {
                            Verbose.logException(exception);
                        }
                        exception.printStackTrace();
                    }
                    if (!verbose) continue;
                    Verbose.log("After StoreCleaner removal, current state object count: " + hashSet.size());
                }
            } else if (verbose) {
                Verbose.say("StoreCleaner(" + StoreCleaner.this.stg + ") - persistent store empty.");
            }
        }
    }
}

