/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.server;

import weblogic.utils.io.FilenameEncoder;
import weblogic.wsee.server.ServerURLNotFoundException;
import weblogic.wsee.server.ServerUtil;

public class URLUtil {
    public static final String constructAbsoluteURL(String string, String string2) {
        String string3 = URLUtil.getProtocol(string2);
        String string4 = URLUtil.getAddress(string2);
        if (string4 != null) {
            return URLUtil.appendJMSQuery(string3, string2);
        }
        string4 = ServerUtil.getServerURL(string3);
        String string5 = FilenameEncoder.resolveRelativeURIPath((String)(string4 + "/" + URLUtil.getPath(string, string2)));
        return URLUtil.appendJMSQuery(string3, string5);
    }

    public static final String appendJMSQuery(String string, String string2) {
        String string3 = new String(string2);
        if (string.equalsIgnoreCase("jms")) {
            if (string2.indexOf("?URI") < 0) {
                string3 = string3 + "?URI=" + ServerUtil.getMessagingQueue();
            }
            if (string2.indexOf("&FACTORY=") < 0) {
                string3 = string3 + "&FACTORY=" + ServerUtil.getJmsConnectionFactory();
            }
        }
        return string3;
    }

    public static final String getProtocol(String string) {
        int n = string.indexOf(58);
        if (n > 0) {
            return string.substring(0, n);
        }
        throw new ServerURLNotFoundException("Protocol is not defined for " + string);
    }

    public static final String getAddress(String string) {
        int n = string.indexOf("://");
        if (n > 0) {
            String string2 = string.substring(n + 3);
            int n2 = string2.indexOf(47);
            if (n2 == 0) {
                return null;
            }
            return string2.substring(0, n2);
        }
        return null;
    }

    public static final String getPath(String string, String string2) throws ServerURLNotFoundException {
        int n = string2.indexOf(":///");
        if (n > -1) {
            return string2.substring(n + 4);
        }
        n = string2.indexOf(":/");
        if (n > -1) {
            return string2.substring(n + 1);
        }
        n = string2.indexOf(58);
        if (n > -1) {
            return string.endsWith("/") ? string + string2.substring(n + 1) : string + "/" + string2.substring(n + 1);
        }
        throw new ServerURLNotFoundException("Unable to resolve uri path for " + string2);
    }
}

