/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.server;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import weblogic.kernel.KernelStatus;
import weblogic.store.ObjectHandler;
import weblogic.store.PersistentMap;
import weblogic.store.PersistentStore;
import weblogic.store.PersistentStoreException;
import weblogic.store.PersistentStoreManager;
import weblogic.store.PersistentStoreTransaction;
import weblogic.store.StoreWritePolicy;
import weblogic.store.internal.PersistentStoreImpl;
import weblogic.store.io.PersistentStoreIO;
import weblogic.store.io.file.FileStoreIO;
import weblogic.wsee.server.StoreCleaner;
import weblogic.wsee.util.Verbose;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsStorage {
    private static final boolean verbose = Verbose.isVerbose(WsStorage.class);
    private Map inMemoryStore;
    private PersistentStore store;
    private boolean needToCloseStore;
    private PersistentMap storeMap;
    private String name;
    private ObjectHandler handler;
    private StoreCleaner cleaner;
    private boolean inMemoryOnly = false;
    private static final String WEBLOGIC_WSEE_SERVER_STORE = "weblogic.wsee.server.store.";

    WsStorage(String string, ObjectHandler objectHandler, boolean bl, boolean bl2) {
        this.name = string;
        this.inMemoryStore = Collections.synchronizedMap(new HashMap());
        if (bl) {
            this.inMemoryOnly = true;
        } else {
            this.handler = objectHandler;
            if (!bl2) {
                this.initCleaner();
            }
        }
    }

    private void initCleaner() {
        this.cleaner = new StoreCleaner(this);
        this.cleaner.startCleanup();
    }

    public void close() throws PersistentStoreException {
        if (this.needToCloseStore) {
            this.store.close();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setCleanInterval(int n) {
        if (this.cleaner != null) {
            this.cleaner.setInterval(n);
        }
    }

    public int getCleanInterval() {
        if (this.cleaner != null) {
            return this.cleaner.getInterval();
        }
        return -1;
    }

    private synchronized void initStore() throws PersistentStoreException {
        if (this.store == null) {
            this.needToCloseStore = false;
            if (KernelStatus.isServer()) {
                String string = System.getProperty("weblogic.wsee.internal.store");
                this.store = string != null ? PersistentStoreManager.getManager().getStore(string) : PersistentStoreManager.getManager().getDefaultStore();
            } else {
                this.store = PersistentStoreManager.getManager().getDefaultStore();
                if (this.store == null) {
                    String string = "WseeFileStore";
                    String string2 = System.getProperty("user.home");
                    FileStoreIO fileStoreIO = new FileStoreIO("weblogic.wsee.persistence." + string, string2);
                    PersistentStoreImpl persistentStoreImpl = new PersistentStoreImpl(this.getClass().getName(), (PersistentStoreIO)fileStoreIO);
                    this.needToCloseStore = true;
                    HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
                    hashMap.put("DaemonThreadInClientJVM", this.needToCloseStore);
                    hashMap.put("SynchronousWritePolicy", (Boolean)StoreWritePolicy.CACHE_FLUSH);
                    persistentStoreImpl.open(hashMap);
                    PersistentStoreManager.getManager().setDefaultStore((PersistentStore)persistentStoreImpl);
                    this.store = PersistentStoreManager.getManager().getDefaultStore();
                }
            }
            if (this.store == null) {
                throw new PersistentStoreException("Persistent store not found");
            }
            this.storeMap = this.handler != null ? this.store.createPersistentMap(WEBLOGIC_WSEE_SERVER_STORE + this.name, this.handler) : this.store.createPersistentMap(WEBLOGIC_WSEE_SERVER_STORE + this.name);
        }
        if (this.storeMap == null) {
            this.storeMap = this.handler != null ? this.store.createPersistentMap(WEBLOGIC_WSEE_SERVER_STORE + this.name, this.handler) : this.store.createPersistentMap(WEBLOGIC_WSEE_SERVER_STORE + this.name);
        }
    }

    public synchronized boolean put(Object object, Object object2) {
        assert (object2 != null);
        Object object3 = this.inMemoryStore.put(object, object2);
        return object3 != null;
    }

    public synchronized boolean persistentPut(Object object, Object object2) throws PersistentStoreException {
        assert (object2 != null);
        if (verbose) {
            Verbose.say("^^^ Putting object in persistent store " + this.name + " with key: " + object);
        }
        Object object3 = this.inMemoryStore.put(object, object2);
        if (this.inMemoryOnly) {
            return object3 != null;
        }
        this.initStore();
        boolean bl = this.storeMap.put(object, object2);
        return object3 != null || bl;
    }

    public synchronized Object get(Object object) {
        return this.inMemoryStore.get(object);
    }

    public synchronized void stopCleaner() {
        if (this.cleaner != null) {
            this.cleaner.stopCleanup();
        }
    }

    public synchronized Object persistentGet(Object object) throws PersistentStoreException {
        Object object2 = this.inMemoryStore.get(object);
        if (this.inMemoryOnly || object2 != null) {
            return object2;
        }
        this.initStore();
        object2 = this.storeMap.get(object);
        if (object2 != null) {
            this.inMemoryStore.put(object, object2);
        }
        return object2;
    }

    public synchronized boolean remove(Object object) {
        return this.inMemoryStore.remove(object) != null;
    }

    public synchronized boolean persistentRemove(Object object) throws PersistentStoreException {
        boolean bl;
        boolean bl2;
        boolean bl3 = bl2 = this.inMemoryStore.remove(object) != null;
        if (verbose && bl2) {
            Verbose.say("^^^ Removing object in persistent store " + this.name + " with key: " + object);
        }
        if (this.inMemoryOnly) {
            return bl2;
        }
        this.initStore();
        try {
            bl = this.storeMap.remove(object);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl || bl2;
    }

    Set storeKeys() {
        try {
            if (this.storeMap != null) {
                return this.storeMap.keySet();
            }
            return null;
        }
        catch (PersistentStoreException persistentStoreException) {
            return null;
        }
    }

    Set memKeys() {
        return this.inMemoryStore.keySet();
    }

    Map memMap() {
        return this.inMemoryStore;
    }

    public PersistentStoreTransaction begin() {
        return this.store.begin();
    }

    public <String, V extends Serializable> TxMap<String, V> getMap() {
        return new MapImpl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapImpl<K, V extends Serializable>
    implements TxMap<K, V> {
        @Override
        public PersistentStoreTransaction beginTransaction() {
            return WsStorage.this.begin();
        }

        @Override
        public int size() {
            try {
                WsStorage.this.initStore();
                return WsStorage.this.inMemoryStore.size();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString(), exception);
            }
        }

        @Override
        public boolean isEmpty() {
            try {
                WsStorage.this.initStore();
                return WsStorage.this.inMemoryStore.isEmpty();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString(), exception);
            }
        }

        @Override
        public boolean containsKey(Object object) {
            try {
                WsStorage.this.initStore();
                return WsStorage.this.inMemoryStore.containsKey(object);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString(), exception);
            }
        }

        @Override
        public boolean containsValue(Object object) {
            try {
                Set set = WsStorage.this.inMemoryStore.keySet();
                for (Object k : set) {
                    Serializable serializable = (Serializable)WsStorage.this.inMemoryStore.get(k);
                    if (serializable == null || !serializable.equals(object)) continue;
                    return true;
                }
                return false;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString(), exception);
            }
        }

        @Override
        public V get(Object object) {
            try {
                return (V)((Serializable)WsStorage.this.persistentGet(object));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString(), exception);
            }
        }

        @Override
        public V put(K k, V v) {
            Object object = this.get(k);
            try {
                return (V)(WsStorage.this.persistentPut(k, v) ? object : null);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString(), exception);
            }
        }

        @Override
        public V remove(Object object) {
            Object object2 = this.get(object);
            try {
                return (V)(WsStorage.this.persistentRemove(object) ? object2 : null);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString(), exception);
            }
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            for (K k : map.keySet()) {
                Serializable serializable = (Serializable)map.get(k);
                this.put(k, (V)serializable);
            }
        }

        @Override
        public void clear() {
            try {
                HashSet hashSet = new HashSet(WsStorage.this.inMemoryStore.keySet());
                for (Object e : hashSet) {
                    WsStorage.this.persistentRemove(e);
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString(), exception);
            }
        }

        @Override
        public Set<K> keySet() {
            return WsStorage.this.inMemoryStore.keySet();
        }

        @Override
        public Collection<V> values() {
            return WsStorage.this.inMemoryStore.values();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return WsStorage.this.inMemoryStore.entrySet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface TxMap<K, V extends Serializable>
    extends Map<K, V> {
        public PersistentStoreTransaction beginTransaction();
    }
}

