/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.server.ejb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import weblogic.ejb.spi.BaseWSObjectIntf;
import weblogic.ejb.spi.MethodUtils;
import weblogic.ejb.spi.WSObjectFactory;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.ContextHandler;
import weblogic.wsee.server.WsSecurityContextHandler;
import weblogic.wsee.util.Verbose;

public class WsEjb {
    private static final boolean verbose = Verbose.isVerbose(WsEjb.class);
    private BaseWSObjectIntf target;
    private Method postInvokeMethod = null;
    private static final boolean dumpException = Boolean.getBoolean("weblogic.wsee.component.exception");
    private static final Map argValueMap = new HashMap();

    public WsEjb(WSObjectFactory wSObjectFactory) throws NoSuchMethodException {
        this.target = wSObjectFactory.create();
        String string = MethodUtils.getWSOPostInvokeMethodName();
        this.postInvokeMethod = this.target.getClass().getMethod(string, null);
    }

    public void preInvoke(Method method, Object object, WsSecurityContextHandler wsSecurityContextHandler) throws InvocationTargetException, IllegalAccessException {
        Object[] objectArray = this.getPreinvokeArgs(method, object, wsSecurityContextHandler);
        method.invoke((Object)this.target, objectArray);
    }

    public Object invoke(Method method, Object[] objectArray) throws Throwable {
        Object object = method.invoke((Object)this.target, objectArray);
        if (this.target.__WL_encounteredException()) {
            Throwable throwable = this.target.__WL_getException();
            throw throwable;
        }
        return object;
    }

    public void postInvoke() {
        block5: {
            try {
                this.postInvokeMethod.invoke((Object)this.target, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
                assert (false);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (verbose || dumpException) {
                    invocationTargetException.getTargetException().printStackTrace();
                }
                if ($assertionsDisabled) break block5;
                throw new AssertionError();
            }
        }
        this.target.__WL_methodComplete();
    }

    private Object[] getPreinvokeArgs(Method method, Object object, WsSecurityContextHandler wsSecurityContextHandler) {
        Class<?>[] classArray = method.getParameterTypes();
        Object[] objectArray = new Object[classArray.length];
        assert (classArray.length >= 2);
        objectArray[0] = object;
        objectArray[1] = wsSecurityContextHandler;
        for (int i = 2; i < classArray.length; ++i) {
            objectArray[i] = argValueMap.get(classArray[i]);
        }
        return objectArray;
    }

    public static Class[] getPreinvokeParams(Class[] classArray) {
        int n = 2;
        if (classArray != null) {
            n = classArray.length + 2;
        }
        Class[] classArray2 = new Class[n];
        classArray2[0] = AuthenticatedSubject.class;
        classArray2[1] = ContextHandler.class;
        for (int i = 2; i < n; ++i) {
            classArray2[i] = classArray[i - 2];
        }
        return classArray2;
    }

    static {
        argValueMap.put(Integer.TYPE, new Integer(100));
        argValueMap.put(Float.TYPE, new Float(10.1f));
        argValueMap.put(Long.TYPE, new Long(1000L));
        argValueMap.put(Double.TYPE, new Double(20.2));
        argValueMap.put(Short.TYPE, new Short(10));
        argValueMap.put(Boolean.TYPE, new Boolean(true));
        argValueMap.put(Byte.TYPE, new Byte(1));
        argValueMap.put(Character.TYPE, new Character('c'));
    }
}

