/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.server.jms;

import java.util.Iterator;
import java.util.Map;
import weblogic.jws.WLJmsTransport;
import weblogic.wsee.server.ServerUtil;
import weblogic.wsee.server.jms.JmsQueueListener;
import weblogic.wsee.util.JmsUtil;
import weblogic.wsee.util.PathUtil;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsService;
import weblogic.wsee.ws.init.WsDeploymentContext;
import weblogic.wsee.ws.init.WsDeploymentException;
import weblogic.wsee.ws.init.WsDeploymentListener;
import weblogic.wsee.wsdl.WsdlUtils;
import weblogic.wsee.wsdl.soap11.SoapAddress;

public class JmsDeploymentListener
implements WsDeploymentListener {
    private static final boolean verbose = Verbose.isVerbose(JmsDeploymentListener.class);
    public static final String CALLBACK_QUEUE_TOKEN = "@weblogic.wsee.CallbackQueue@";

    public void process(WsDeploymentContext wsDeploymentContext) throws WsDeploymentException {
        WsService wsService = wsDeploymentContext.getWsService();
        if (verbose) {
            Verbose.log("Looking for JMS transport in service: " + wsService.getWsdlService().getName());
        }
        Iterator<WsPort> iterator = wsService.getPorts();
        while (iterator.hasNext()) {
            String string;
            Object object;
            int n;
            WsPort wsPort = iterator.next();
            Class clazz = wsPort.getEndpoint().getJwsClass();
            if (verbose) {
                Verbose.log("Looking for JMS transport in port: " + wsPort.getWsdlPort().getName() + ", class=" + clazz);
            }
            if (clazz == null) continue;
            boolean bl = false;
            SoapAddress soapAddress = WsdlUtils.getSoapAddress(wsPort.getWsdlPort());
            if (verbose) {
                Verbose.log("Calculated SoapAddress: " + soapAddress);
            }
            if (soapAddress != null && (n = ((String)(object = soapAddress.getLocation())).indexOf("://")) > -1 && (string = ((String)object).substring(0, n)).equalsIgnoreCase("jms")) {
                JmsDeploymentListener.jmsListenerDeploymentHelper((String)object, true);
                bl = true;
            }
            if (!bl && (object = clazz.getAnnotation(WLJmsTransport.class)) != null) {
                JmsDeploymentListener.jmsListenerDeploymentHelper((WLJmsTransport)object, true, wsDeploymentContext.getContextPath());
                bl = true;
            }
            if (bl) continue;
            JmsQueueListener.setHasServices();
        }
    }

    public static void removeJmsListener(WsPort wsPort) throws WsDeploymentException {
        Class clazz = wsPort.getEndpoint().getJwsClass();
        if (clazz != null) {
            String string;
            Object object;
            int n;
            boolean bl = false;
            SoapAddress soapAddress = WsdlUtils.getSoapAddress(wsPort.getWsdlPort());
            if (soapAddress != null && (n = ((String)(object = soapAddress.getLocation())).indexOf("://")) > -1 && (string = ((String)object).substring(0, n)).equalsIgnoreCase("jms")) {
                JmsDeploymentListener.jmsListenerDeploymentHelper((String)object, false);
                bl = true;
            }
            if (!bl && (object = clazz.getAnnotation(WLJmsTransport.class)) != null) {
                JmsDeploymentListener.jmsListenerDeploymentHelper((WLJmsTransport)object, false, wsPort.getPortComponent().getServiceEndpointAddress().getWebserviceContextpath());
            }
        }
    }

    private static void jmsListenerDeploymentHelper(WLJmsTransport wLJmsTransport, boolean bl, String string) {
        if (verbose) {
            Verbose.log("Adding JMS transport");
        }
        String string2 = JmsDeploymentListener.getUrl(wLJmsTransport, string);
        ServerUtil.QueueInfo queueInfo = JmsDeploymentListener.getQueueInfo(wLJmsTransport.queue());
        String string3 = JmsDeploymentListener.getFactory(wLJmsTransport.connectionFactory());
        if (bl) {
            JmsQueueListener.findOrCreateJmsListener(string2, queueInfo, string3);
        } else {
            JmsQueueListener.removeJmsListener(string2, queueInfo.getQueueName());
        }
    }

    private static void jmsListenerDeploymentHelper(String string, boolean bl) {
        String string2;
        String string3;
        if (verbose) {
            Verbose.log("Adding JMS transport for url:" + string);
        }
        String string4 = string;
        int n = string4.indexOf("://");
        string4 = string4.substring(n + 3, string4.length());
        string4 = string4.substring(string4.indexOf(47) + 1, string4.length());
        int n2 = string4.lastIndexOf("/");
        int n3 = string4.lastIndexOf(63);
        String string5 = null;
        if (n2 > -1) {
            string3 = string4.substring(0, n2);
            string2 = n3 > -1 ? string4.substring(n2 + 1, n3) : string4.substring(n2 + 1, string4.length());
        } else {
            string3 = "/";
            string2 = string4;
        }
        Map map = JmsUtil.asMap(string4.substring(n3 + 1, string4.length()));
        if (verbose) {
            Verbose.log(" Queue = " + map.get("URI") + " factory = " + map.get("FACTORY"));
        }
        ServerUtil.QueueInfo queueInfo = JmsDeploymentListener.getQueueInfo((String)map.get("URI"));
        String string6 = JmsDeploymentListener.getFactory((String)map.get("FACTORY"));
        string4 = "/" + string3 + "/" + string2;
        if (bl) {
            if (verbose) {
                Verbose.log("Creating listener for JMS queue:" + string5 + " url = " + string4);
            }
            JmsQueueListener.findOrCreateJmsListener(string4, queueInfo, string6);
        }
    }

    private static ServerUtil.QueueInfo getQueueInfo(String string) {
        ServerUtil.QueueInfo queueInfo = ServerUtil.getBufferQueueInfo(string);
        return queueInfo;
    }

    private static String getFactory(String string) {
        String string2 = string;
        if (StringUtil.isEmpty(string2)) {
            string2 = ServerUtil.getJmsConnectionFactory();
        }
        return string2;
    }

    private static String getUrl(WLJmsTransport wLJmsTransport, String string) {
        String string2 = "";
        String string3 = wLJmsTransport.contextPath();
        if (!StringUtil.isEmpty(string3)) {
            string2 = PathUtil.normalizePath(string3);
        } else if (!StringUtil.isEmpty(string)) {
            string2 = PathUtil.normalizePath(string);
        }
        String string4 = wLJmsTransport.serviceUri();
        if (!StringUtil.isEmpty(string4)) {
            string2 = string2 + PathUtil.normalizePath(string4);
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        return string2;
    }
}

