/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.server.jms;

import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.login.LoginException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.rpc.JAXRPCException;
import org.w3c.dom.Document;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.wsee.connection.transport.TransportUtil;
import weblogic.wsee.server.ServerUtil;
import weblogic.wsee.server.jms.JmsWebservicesMessageDispatcher;
import weblogic.wsee.util.JmsUtil;
import weblogic.wsee.util.ServerSecurityHelper;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.Verbose;

public class JmsQueueListener
extends TimerTask
implements MessageListener {
    private static final boolean verbose = Verbose.isVerbose(JmsQueueListener.class);
    private QueueConnectionFactory factory;
    private QueueConnection connection;
    private QueueSession session;
    private QueueReceiver receiver;
    private QueueReceiver receiver81;
    private String wsUrl;
    private ServerUtil.QueueInfo queueInfo;
    private String factoryName;
    private Timer timer;
    private JmsWebservicesMessageDispatcher dispatcher = null;
    private static int TIME_TO_SLEEP = 60000;
    private static final String DELIMITER = "##";
    private static Set<String> queueMap = new HashSet<String>();
    private static Map<String, Integer> countMap = new HashMap<String, Integer>();
    private static boolean hasServices = false;
    private static Set asyncResponseListeners = new HashSet();
    private PrincipalAuthenticator _pa;
    private static final AuthenticatedSubject _kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    private static void addJmsListener(String string, ServerUtil.QueueInfo queueInfo, JmsQueueListener jmsQueueListener) {
        String string2 = string + DELIMITER + queueInfo.getQueueName();
        queueMap.add(string2);
        if (verbose) {
            Verbose.log("Added new jms queue listener to queue map for url " + string + " queue " + queueInfo.getQueueName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeJmsListener(String string, String string2) {
        String string3 = string + DELIMITER + string2;
        Set<String> set = queueMap;
        synchronized (set) {
            Integer n = countMap.remove(string3);
            if (n != null) {
                if (n <= 1) {
                    if (queueMap.remove(string3)) {
                        if (verbose) {
                            Verbose.log("Removed jms queue listener from map for url " + string + " queue " + string2);
                        }
                    } else if (verbose) {
                        Verbose.log("No jms Queue listener present for url " + string + " queue " + string2);
                    }
                } else {
                    countMap.put(string3, new Integer(n - 1));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JmsQueueListener findOrCreateJmsListener(String string, ServerUtil.QueueInfo queueInfo, String string2) {
        boolean bl;
        JmsQueueListener jmsQueueListener;
        String string3 = string + DELIMITER + queueInfo.getQueueName();
        boolean bl2 = false;
        Set<String> set = queueMap;
        synchronized (set) {
            if (queueMap.contains(string3) && verbose) {
                Verbose.log("Jms Queue Listener for url " + string + " queue " + queueInfo.getQueueName() + " already created");
            }
            jmsQueueListener = new JmsQueueListener(string, queueInfo, string2);
            JmsQueueListener.addJmsListener(string, queueInfo, jmsQueueListener);
            Integer n = countMap.get(string3);
            if (n != null) {
                countMap.put(string3, new Integer(n + 1));
            } else {
                countMap.put(string3, new Integer(1));
            }
            if (string.indexOf("/_async/AsyncResponseService") == -1) {
                bl2 = true;
                hasServices = true;
            } else if (hasServices) {
                bl2 = true;
            } else {
                asyncResponseListeners.add(jmsQueueListener);
            }
            bl = hasServices && asyncResponseListeners.size() != 0;
        }
        if (verbose) {
            Verbose.log("Created jms Queue listener  for url " + string + " queue " + queueInfo.getQueueName());
        }
        if (bl2) {
            jmsQueueListener.connect();
        }
        if (bl) {
            JmsQueueListener.connectAsyncResponseListeners();
        }
        return jmsQueueListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void connectAsyncResponseListeners() {
        Object[] objectArray;
        Set<String> set = queueMap;
        synchronized (set) {
            objectArray = asyncResponseListeners.toArray();
            asyncResponseListeners.clear();
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (verbose) {
                Verbose.log("In connectAsyncResponseListeners. Connecting listener " + (i + 1) + "/" + objectArray.length + " = " + objectArray[i]);
            }
            ((JmsQueueListener)objectArray[i]).connect();
            if (!verbose) continue;
            Verbose.log("In connectAsyncResponseListeners. Done connecting listener " + (i + 1) + "/" + objectArray.length + " = " + objectArray[i]);
        }
    }

    private JmsQueueListener(String string, ServerUtil.QueueInfo queueInfo, String string2) throws JAXRPCException {
        this.wsUrl = string;
        this.queueInfo = queueInfo;
        this.factoryName = string2;
    }

    private synchronized void connect() {
        if (verbose) {
            Verbose.log("Connecting to JMS queue " + this.queueInfo.getQueueName());
        }
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        try {
            InitialContext initialContext = new InitialContext();
            this.factory = (QueueConnectionFactory)initialContext.lookup(this.factoryName);
            bl = TransportUtil.getForeignCredentials(this.factoryName, initialContext, stringBuffer, stringBuffer2);
            this.connection = bl ? this.factory.createQueueConnection(stringBuffer.toString(), stringBuffer2.toString()) : this.factory.createQueueConnection();
            this.session = this.connection.createQueueSession(false, 1);
            final Queue queue = (Queue)initialContext.lookup(this.queueInfo.getQueueName());
            final String string = JmsUtil.getJmsTransportSelector(this.wsUrl);
            final String string2 = JmsUtil.getWLW81Selector(this.wsUrl);
            if (verbose) {
                Verbose.log("Select for " + string);
            }
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws JMSException {
                    JmsQueueListener.this.receiver = JmsQueueListener.this.session.createReceiver(queue, string);
                    JmsQueueListener.this.receiver81 = JmsQueueListener.this.session.createReceiver(queue, string2);
                    return null;
                }
            };
            try {
                if (StringUtil.isEmpty(this.queueInfo.getMdbRunAsPrincipalName())) {
                    privilegedExceptionAction.run();
                } else {
                    AuthenticatedSubject authenticatedSubject = this.authenticateAs(this.queueInfo.getMdbRunAsPrincipalName());
                    SecurityServiceManager.runAs((AuthenticatedSubject)_kernelId, (AuthenticatedSubject)authenticatedSubject, (PrivilegedExceptionAction)privilegedExceptionAction);
                }
            }
            catch (Exception exception) {
                if (exception instanceof JMSException) {
                    throw (JMSException)((Object)exception);
                }
                JMSException jMSException = new JMSException(exception.toString());
                jMSException.setLinkedException(exception);
                throw jMSException;
            }
            this.receiver.setMessageListener((MessageListener)this);
            this.receiver81.setMessageListener((MessageListener)new WLW81Listener());
            this.connection.start();
            this.dispatcher = bl ? new JmsWebservicesMessageDispatcher(this.wsUrl, this.factory, stringBuffer.toString(), stringBuffer2.toString()) : new JmsWebservicesMessageDispatcher(this.wsUrl, this.factory);
            if (verbose) {
                Verbose.log("connected to JMS queue " + this.queueInfo.getQueueName());
            }
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }
        catch (NamingException namingException) {
            if (this.wsUrl.indexOf("_async/AsyncResponseService") != -1) {
                if (verbose) {
                    Verbose.log("Warning: JMS queue '" + this.queueInfo.getQueueName() + "' is not found, as a result, Web Service async responses via " + "jms transport is not supported. If the target service uses " + "JMS transport, the responses will not be able to come back.");
                }
            } else {
                this.handleConnectionException(namingException);
            }
        }
        catch (JMSException jMSException) {
            this.handleConnectionException((Exception)((Object)jMSException));
        }
    }

    private AuthenticatedSubject authenticateAs(String string) {
        try {
            if (this._pa == null) {
                this._pa = (PrincipalAuthenticator)this.getService(SecurityService.ServiceType.AUTHENTICATION);
            }
            return this._pa.impersonateIdentity(string);
        }
        catch (LoginException loginException) {
            throw new SecurityException("User " + string + " is an invalid user");
        }
    }

    private SecurityService getService(SecurityService.ServiceType serviceType) {
        SecurityService securityService;
        try {
            securityService = SecurityServiceManager.getSecurityService((AuthenticatedSubject)_kernelId, (String)SecurityServiceManager.getDefaultRealmName(), (SecurityService.ServiceType)serviceType);
        }
        catch (Exception exception) {
            throw new SecurityException("Unexpected exception: " + exception.toString(), exception);
        }
        return securityService;
    }

    private void handleConnectionException(Exception exception) {
        Verbose.logException(exception);
        if (this.timer == null) {
            this.timer = new Timer(true);
            this.timer.scheduleAtFixedRate((TimerTask)this, TIME_TO_SLEEP, (long)TIME_TO_SLEEP);
        }
    }

    public synchronized void close() throws JMSException {
        if (this.dispatcher != null) {
            this.dispatcher.shutdown();
        }
        if (this.receiver != null) {
            this.receiver.close();
        }
        if (this.receiver81 != null) {
            this.receiver81.close();
        }
        if (this.session != null) {
            this.session.close();
        }
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public void run() {
        this.connect();
    }

    public void onMessage(Message message) {
        if (verbose) {
            Verbose.log("Got a JMS message for service " + this.wsUrl + " on queue " + this.queueInfo.getQueueName() + ": " + message);
        }
        ServerSecurityHelper.assertAnonymousIdentity();
        if (!(message instanceof TextMessage) && !(message instanceof BytesMessage)) {
            throw new JAXRPCException("not text message or a bytes message" + message);
        }
        try {
            if (message.getJMSReplyTo() == null) {
                String string = message.getStringProperty("URI");
                message.clearProperties();
                message.setStringProperty("URI", string);
                message.setStringProperty("_wls_mimehdrContent_Type", new String("text/xml"));
                message.setBooleanProperty("IsWLW81Message", true);
            }
        }
        catch (JMSException jMSException) {
            throw new JAXRPCException("Failed to get properties from JMS text message:" + (Object)((Object)jMSException), (Throwable)jMSException);
        }
        this.processMessage(message);
    }

    private void processMessage(Message message) {
        this.dispatcher.dispatchMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setHasServices() {
        Set<String> set = queueMap;
        synchronized (set) {
            if (verbose) {
                Verbose.log("In setHasServices with hasServices=" + hasServices);
            }
            if (hasServices) {
                return;
            }
            if (verbose) {
                Verbose.log("In setHasServices with asyncResponseListeners.size()=" + asyncResponseListeners.size());
            }
            hasServices = true;
            if (asyncResponseListeners.size() != 0) {
                JmsQueueListener.connectAsyncResponseListeners();
            }
        }
    }

    private class WLW81Listener
    implements MessageListener {
        private WLW81Listener() {
        }

        public void onMessage(Message message) {
            if (verbose) {
                Verbose.log("Got a 8.1 JMS message:" + message);
            }
            ServerSecurityHelper.assertAnonymousIdentity();
            if (!(message instanceof TextMessage)) {
                throw new JAXRPCException("not text message" + message);
            }
            this.convertMessage((TextMessage)message);
            JmsQueueListener.this.processMessage(message);
        }

        private String getEncodingFromMessage(String string) {
            block4: {
                try {
                    int n = string.indexOf("<?");
                    int n2 = string.indexOf("?>");
                    if (n != -1 && n2 != -1 && n2 > n) {
                        String string2 = string.substring(n, n2 + 2) + "<test/>";
                        System.out.println(string2);
                        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                        Document document = documentBuilder.parse(new ByteArrayInputStream(string2.getBytes()));
                        if (Charset.isSupported(document.getXmlEncoding())) {
                            return document.getXmlEncoding();
                        }
                    }
                }
                catch (Exception exception) {
                    if (!verbose) break block4;
                    Verbose.logException(exception);
                }
            }
            return null;
        }

        private void convertMessage(TextMessage textMessage) {
            try {
                String string = textMessage.getStringProperty("URI");
                textMessage.clearProperties();
                textMessage.setStringProperty("URI", string);
                String string2 = this.getEncodingFromMessage(textMessage.getText());
                if (string2 == null) {
                    textMessage.setStringProperty("_wls_mimehdrContent_Type", new String("text/xml"));
                } else {
                    textMessage.setStringProperty("_wls_mimehdrContent_Type", new String("text/xml; charset=\"" + string2 + "\""));
                }
                textMessage.setBooleanProperty("IsWLW81Message", true);
            }
            catch (JMSException jMSException) {
                throw new JAXRPCException("Failed to get properties from JMS text message:" + (Object)((Object)jMSException), (Throwable)jMSException);
            }
        }
    }
}

