/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.server.jms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.QueueConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.login.LoginException;
import javax.xml.rpc.JAXRPCException;
import weblogic.jws.security.RunAs;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.encoders.BASE64Decoder;
import weblogic.wsee.component.pojo.JavaClassComponent;
import weblogic.wsee.connection.Connection;
import weblogic.wsee.connection.ConnectionException;
import weblogic.wsee.connection.ConnectionFactory;
import weblogic.wsee.connection.transport.TransportUtil;
import weblogic.wsee.connection.transport.jms.JmsServerQueueTransport;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsException;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsRegistry;
import weblogic.wsee.ws.WsSkel;

public class JmsWebservicesMessageDispatcher {
    private static final boolean verbose = Verbose.isVerbose(JmsWebservicesMessageDispatcher.class);
    private String wsUrl;
    private QueueConnectionFactory factory = null;
    private String userName = null;
    private String passwd = null;
    private PrincipalAuthenticator _pa;
    private static final AuthenticatedSubject _kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public JmsWebservicesMessageDispatcher(String string, String string2) throws JMSException, NamingException {
        this.factory = this.getConnectionFactory(string2);
        this.wsUrl = string;
    }

    protected JmsWebservicesMessageDispatcher(String string, QueueConnectionFactory queueConnectionFactory) throws JMSException {
        this.factory = queueConnectionFactory;
        this.wsUrl = string;
    }

    protected JmsWebservicesMessageDispatcher(String string, QueueConnectionFactory queueConnectionFactory, String string2, String string3) throws JMSException {
        this.factory = queueConnectionFactory;
        this.wsUrl = string;
        this.userName = string2;
        this.passwd = string3;
    }

    public void dispatchMessage(Message message) {
        Object object;
        Object object2;
        Connection connection;
        WsRegistry wsRegistry;
        WsPort wsPort;
        String string;
        String string2 = null;
        try {
            string2 = message.getStringProperty("URI");
            string = message.getStringProperty("WSEE_JMS_SUBJECT");
        }
        catch (JMSException jMSException) {
            throw new JAXRPCException("Failed to get URI property from JMS text message:" + (Object)((Object)jMSException), (Throwable)jMSException);
        }
        if (verbose) {
            Verbose.log("URI = " + string2);
        }
        if ((wsPort = (wsRegistry = WsRegistry.instance()).lookup(this.wsUrl)) == null) {
            throw new JAXRPCException("Failed to lookup Web Service Endpoint at " + this.wsUrl + "." + "\nThe Web Service does not exist anymore or its server is shut(or shutting)," + "\nand the request will failover to another server if the Web Service is running on cluster.");
        }
        final WsSkel wsSkel = (WsSkel)wsPort.getEndpoint();
        JmsServerQueueTransport jmsServerQueueTransport = new JmsServerQueueTransport(this.wsUrl, message, this.factory, this.userName, this.passwd);
        String string3 = wsPort.getWsdlPort().getBinding().getBindingType();
        try {
            connection = ConnectionFactory.instance().createServerConnection(jmsServerQueueTransport, string3);
        }
        catch (ConnectionException connectionException) {
            throw new JAXRPCException("Failed to create connection", (Throwable)connectionException);
        }
        AuthenticatedSubject authenticatedSubject = null;
        if (wsSkel.getComponent() instanceof JavaClassComponent) {
            object2 = wsSkel.getJwsClass().getAnnotation(RunAs.class);
            if (object2 != null) {
                object = object2.mapToPrincipal();
                authenticatedSubject = this.authenticateAs((String)object);
                if (verbose) {
                    Verbose.log("Get @RunAs subject on skel: " + authenticatedSubject);
                }
            } else if (verbose) {
                Verbose.log("No @RunAs defined on skel: " + wsSkel);
            }
        }
        try {
            if (authenticatedSubject == null && string == null) {
                wsSkel.invoke(connection, wsPort);
            } else {
                if (authenticatedSubject == null) {
                    object2 = new BASE64Decoder().decodeBuffer(string);
                    object = new ByteArrayInputStream((byte[])object2);
                    ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)object);
                    AuthenticatedSubject authenticatedSubject2 = (AuthenticatedSubject)objectInputStream.readObject();
                    if (verbose) {
                        Verbose.log("Subject = " + authenticatedSubject2);
                    }
                    authenticatedSubject = authenticatedSubject2;
                }
                SecurityServiceManager.runAs((AuthenticatedSubject)((AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction())), (AuthenticatedSubject)authenticatedSubject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws WsException {
                        wsSkel.invoke(connection, wsPort);
                        return null;
                    }
                });
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new JAXRPCException("Failed to invoke skel", (Throwable)privilegedActionException.getException());
        }
        catch (IOException iOException) {
            throw new JAXRPCException("Failed to invoke skel", (Throwable)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JAXRPCException("Failed to invoke skel", (Throwable)classNotFoundException);
        }
        catch (WsException wsException) {
            throw new JAXRPCException("Failed to invoke skel", (Throwable)wsException);
        }
    }

    private QueueConnectionFactory getConnectionFactory(String string) throws NamingException {
        InitialContext initialContext = new InitialContext();
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        bl = TransportUtil.getForeignCredentials(string, initialContext, stringBuffer, stringBuffer2);
        if (bl) {
            this.userName = stringBuffer.toString();
            this.passwd = stringBuffer2.toString();
        }
        return (QueueConnectionFactory)initialContext.lookup(string);
    }

    public void shutdown() {
    }

    private AuthenticatedSubject authenticateAs(String string) {
        try {
            if (this._pa == null) {
                this._pa = (PrincipalAuthenticator)this.getService(SecurityService.ServiceType.AUTHENTICATION);
            }
            return this._pa.impersonateIdentity(string);
        }
        catch (LoginException loginException) {
            throw new SecurityException("User " + string + " is an invalid user");
        }
    }

    private SecurityService getService(SecurityService.ServiceType serviceType) {
        SecurityService securityService;
        try {
            securityService = SecurityServiceManager.getSecurityService((AuthenticatedSubject)_kernelId, (String)SecurityServiceManager.getDefaultRealmName(), (SecurityService.ServiceType)serviceType);
        }
        catch (Exception exception) {
            throw new SecurityException("Unexpected exception: " + exception.toString(), exception);
        }
        return securityService;
    }
}

