/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.server.jms;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.xml.rpc.JAXRPCException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.wsee.async.SOAPInvokeState;
import weblogic.wsee.buffer.NoRetryException;
import weblogic.wsee.jws.container.Request;
import weblogic.wsee.util.DirectInvokeUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsRegistry;
import weblogic.wsee.ws.WsSkel;

public class WsClientBufferingErrorMessageListener
implements MessageListener {
    private static final boolean verbose = Verbose.isVerbose(WsClientBufferingErrorMessageListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        block13: {
            try {
                if (message instanceof ObjectMessage) {
                    String string = message.getStringProperty("SERV_URI");
                    if (string == null) {
                        throw new JAXRPCException("No service URI found");
                    }
                    WsPort wsPort = this.getPort(string);
                    if (wsPort == null) {
                        throw new JAXRPCException("No port found for " + string);
                    }
                    ClassLoader classLoader = ((WsSkel)wsPort.getEndpoint()).getClassLoader();
                    Thread thread2 = Thread.currentThread();
                    ClassLoader classLoader2 = thread2.getContextClassLoader();
                    try {
                        thread2.setContextClassLoader(classLoader);
                        Serializable serializable = ((ObjectMessage)message).getObject();
                        if (!(serializable instanceof SOAPInvokeState)) {
                            throw new JAXRPCException("Wrong object message received, expected type: weblogic.wsee.async.SOAPInvokeState");
                        }
                        SOAPInvokeState sOAPInvokeState = (SOAPInvokeState)serializable;
                        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                        AuthenticatedSubject authenticatedSubject2 = sOAPInvokeState.getSubject(authenticatedSubject);
                        AuthorizedInvoke authorizedInvoke = new AuthorizedInvoke(sOAPInvokeState);
                        if (authenticatedSubject2 != null) {
                            try {
                                SecurityServiceManager.runAs((AuthenticatedSubject)authenticatedSubject, (AuthenticatedSubject)authenticatedSubject2, (PrivilegedExceptionAction)authorizedInvoke);
                                break block13;
                            }
                            catch (PrivilegedActionException privilegedActionException) {
                                if (privilegedActionException.getException() instanceof IOException) {
                                    throw (IOException)privilegedActionException.getException();
                                }
                                throw new UndeclaredThrowableException(privilegedActionException.getException());
                            }
                        }
                        authorizedInvoke.run();
                        break block13;
                    }
                    finally {
                        thread2.setContextClassLoader(classLoader2);
                    }
                }
                throw new JAXRPCException("Wrong message type, only allow object message");
            }
            catch (Throwable throwable) {
                throw new NoRetryException(throwable);
            }
        }
    }

    private WsPort getPort(String string) {
        String string2 = WsRegistry.getURL(string);
        String string3 = WsRegistry.getVersion(string);
        return WsRegistry.instance().lookup(string2, string3);
    }

    private class AuthorizedInvoke
    implements PrivilegedExceptionAction {
        SOAPInvokeState sis;

        AuthorizedInvoke(SOAPInvokeState sOAPInvokeState) {
            this.sis = sOAPInvokeState;
        }

        public Object run() throws Exception {
            block4: {
                Map map = this.sis.getMessageContextProperties();
                try {
                    String string = (String)map.get("weblogic.wsee.enclosing.classname");
                    if (string == null) {
                        if (verbose) {
                            Verbose.log("No target class found");
                        }
                        return null;
                    }
                    String string2 = "onAsyncFailure";
                    Class[] classArray = new Class[]{String.class, Object[].class};
                    Object[] objectArray = new Object[]{(String)map.get("weblogic.wsee.callback.client.methodname"), (Object[])map.get("weblogic.wsee.callback.client.args")};
                    String string3 = (String)map.get("weblogic.wsee.enclosing.jws.serviceuri");
                    String string4 = (String)map.get("weblogic.wsee.conversation.ConversationId");
                    Request request = new Request(string, string2, classArray, objectArray);
                    DirectInvokeUtil.invoke(string3, request, string4, null);
                }
                catch (Throwable throwable) {
                    if (!verbose) break block4;
                    Verbose.logException(throwable);
                }
            }
            return null;
        }
    }
}

