/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.server.jms;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.xml.rpc.JAXRPCException;
import org.w3c.dom.Element;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.wsee.async.SOAPInvokeState;
import weblogic.wsee.connection.Connection;
import weblogic.wsee.connection.ConnectionFactory;
import weblogic.wsee.handler.InvocationException;
import weblogic.wsee.message.UnknownMsgHeader;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.util.ControlAPIUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsRegistry;
import weblogic.wsee.ws.WsSkel;

public class WsClientBufferingMessageListener
implements MessageListener {
    private static final boolean verbose = Verbose.isVerbose(WsClientBufferingMessageListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        block14: {
            try {
                if (message instanceof ObjectMessage) {
                    String string = message.getStringProperty("SERV_URI");
                    if (string == null) {
                        throw new JAXRPCException("No service URI found");
                    }
                    WsPort wsPort = this.getPort(string);
                    if (wsPort == null) {
                        throw new JAXRPCException("No port found for " + string);
                    }
                    ClassLoader classLoader = ((WsSkel)wsPort.getEndpoint()).getClassLoader();
                    Thread thread2 = Thread.currentThread();
                    ClassLoader classLoader2 = thread2.getContextClassLoader();
                    try {
                        thread2.setContextClassLoader(classLoader);
                        Serializable serializable = ((ObjectMessage)message).getObject();
                        if (!(serializable instanceof SOAPInvokeState)) {
                            throw new JAXRPCException("Wrong object message received, expected type: weblogic.wsee.async.SOAPInvokeState");
                        }
                        SOAPInvokeState sOAPInvokeState = (SOAPInvokeState)serializable;
                        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                        AuthenticatedSubject authenticatedSubject2 = sOAPInvokeState.getSubject(authenticatedSubject);
                        AuthorizedInvoke authorizedInvoke = new AuthorizedInvoke(sOAPInvokeState);
                        if (authenticatedSubject2 != null) {
                            try {
                                SecurityServiceManager.runAs((AuthenticatedSubject)authenticatedSubject, (AuthenticatedSubject)authenticatedSubject2, (PrivilegedExceptionAction)authorizedInvoke);
                                break block14;
                            }
                            catch (PrivilegedActionException privilegedActionException) {
                                if (privilegedActionException.getException() instanceof IOException) {
                                    throw (IOException)privilegedActionException.getException();
                                }
                                throw new UndeclaredThrowableException(privilegedActionException.getException());
                            }
                        }
                        authorizedInvoke.run();
                        break block14;
                    }
                    finally {
                        thread2.setContextClassLoader(classLoader2);
                    }
                }
                throw new JAXRPCException("Wrong message type, only allow object message");
            }
            catch (JAXRPCException jAXRPCException) {
                throw jAXRPCException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new JAXRPCException((Throwable)exception);
            }
        }
    }

    private WsPort getPort(String string) {
        String string2 = WsRegistry.getURL(string);
        String string3 = WsRegistry.getVersion(string);
        return WsRegistry.instance().lookup(string2, string3);
    }

    private class AuthorizedInvoke
    implements PrivilegedExceptionAction {
        SoapMessageContext ctx;

        AuthorizedInvoke(SOAPInvokeState sOAPInvokeState) {
            this.ctx = new SoapMessageContext(sOAPInvokeState.isSoap12());
            for (String string : sOAPInvokeState.getMessageContextProperties().keySet()) {
                this.ctx.setProperty(string, sOAPInvokeState.getMessageContextProperties().get(string));
            }
            this.ctx.setMessage(sOAPInvokeState.getSOAPMessage());
        }

        public Object run() throws Exception {
            String string = (String)this.ctx.getProperty("weblogic.wsee.binding.type");
            String string2 = (String)this.ctx.getProperty("javax.xml.rpc.service.endpoint.address");
            String string3 = string2.substring(0, string2.indexOf(58));
            Connection connection = ConnectionFactory.instance().createClientConnection(string3, string);
            this.writeOutputHeaders(this.ctx);
            try {
                connection.send(this.ctx);
                connection.getTransport().confirmOneway();
            }
            catch (IOException iOException) {
                throw new InvocationException("Failed to send message using connection:" + connection, iOException);
            }
            return null;
        }

        private void writeOutputHeaders(WlMessageContext wlMessageContext) {
            List list = (List)wlMessageContext.getProperty("weblogic.wsee.OutputHeaders");
            if (list != null) {
                for (Element element : list) {
                    wlMessageContext.getHeaders().addHeader(new UnknownMsgHeader(element));
                }
                ControlAPIUtil.unsetOutputHeaders(wlMessageContext);
            }
        }
    }
}

