/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.server.jms;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.xml.rpc.JAXRPCException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.wsee.addressing.ActionHeader;
import weblogic.wsee.async.SOAPInvokeState;
import weblogic.wsee.connection.Connection;
import weblogic.wsee.connection.ConnectionFactory;
import weblogic.wsee.connection.transport.jms.JMSServerTransport;
import weblogic.wsee.jws.container.ServerResponsePathDispatcher;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.server.WsLifeCycleEvent;
import weblogic.wsee.server.WsLifeCycleListenerRegistry;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsException;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsSkel;

public class WsDispatchMessageListener
implements MessageListener {
    private static final boolean verbose = Verbose.isVerbose(WsDispatchMessageListener.class);
    private final WsPort port;
    private boolean isRM = true;

    public WsDispatchMessageListener(WsPort wsPort) {
        this.port = wsPort;
    }

    public void setRM(boolean bl) {
        this.isRM = bl;
    }

    public boolean isRM() {
        return this.isRM;
    }

    public void onMessage(Message message) {
        long l;
        block18: {
            l = System.nanoTime();
            if (verbose) {
                Verbose.say(l + " Entering WsDispatchMessageListener.onMessage()");
            }
            try {
                if (message instanceof ObjectMessage) {
                    Serializable serializable = ((ObjectMessage)message).getObject();
                    if (!(serializable instanceof SOAPInvokeState)) {
                        throw new JAXRPCException("Wrong object message received, expected type: weblogic.wsee.async.SOAPInvokeState");
                    }
                    String string = message.getStringProperty("ASYNC_URI");
                    SOAPInvokeState sOAPInvokeState = (SOAPInvokeState)serializable;
                    try {
                        int n = message.getIntProperty("JMSXDeliveryCount");
                        sOAPInvokeState.getMessageContextProperties().put("weblogic.wsee.buffer.BufferedMessageJmsDeliveryCount", n);
                    }
                    catch (Exception exception) {
                        if (verbose) {
                            Verbose.logException(exception);
                        }
                        exception.printStackTrace();
                    }
                    AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                    AuthenticatedSubject authenticatedSubject2 = sOAPInvokeState.getSubject(authenticatedSubject);
                    AuthorizedInvoke authorizedInvoke = new AuthorizedInvoke(sOAPInvokeState, string);
                    if (authenticatedSubject2 != null) {
                        try {
                            if (verbose) {
                                Verbose.say(l + " Inside WsDispatchMessageListener.onMessage() == 1");
                            }
                            SecurityServiceManager.runAs((AuthenticatedSubject)authenticatedSubject, (AuthenticatedSubject)authenticatedSubject2, (PrivilegedExceptionAction)authorizedInvoke);
                            if (verbose) {
                                Verbose.say(l + " Inside WsDispatchMessageListener.onMessage() == 2");
                            }
                            break block18;
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            if (privilegedActionException.getException() instanceof IOException) {
                                throw (IOException)privilegedActionException.getException();
                            }
                            if (privilegedActionException.getException() instanceof WsException) {
                                throw new JAXRPCException((Throwable)privilegedActionException.getException());
                            }
                            throw new UndeclaredThrowableException(privilegedActionException.getException());
                        }
                    }
                    authorizedInvoke.run();
                    break block18;
                }
                throw new JAXRPCException("Wrong message type, only allow object message");
            }
            catch (JAXRPCException jAXRPCException) {
                throw jAXRPCException;
            }
            catch (Exception exception) {
                if (verbose) {
                    Verbose.logException(exception);
                }
                throw new JAXRPCException(exception.toString(), (Throwable)exception);
            }
        }
        if (verbose) {
            Verbose.say(l + " Exiting WsDispatchMessageListener.onMessage()");
        }
    }

    private class AuthorizedInvoke
    implements PrivilegedExceptionAction {
        SoapMessageContext ctx;
        String targetURI;

        AuthorizedInvoke(SOAPInvokeState sOAPInvokeState, String string) {
            this.ctx = new SoapMessageContext(sOAPInvokeState.isSoap12());
            for (String string2 : sOAPInvokeState.getMessageContextProperties().keySet()) {
                this.ctx.setProperty(string2, sOAPInvokeState.getMessageContextProperties().get(string2));
            }
            this.ctx.setMessage(sOAPInvokeState.getSOAPMessage());
            this.targetURI = string;
        }

        public Object run() throws Exception {
            String string = (String)this.ctx.getProperty("weblogic.wsee.reliability.RequestMessageSeqID");
            String string2 = (String)this.ctx.getProperty("weblogic.wsee.reliability.RequestMessageSeqNumber");
            boolean bl = false;
            String string3 = "Unknown";
            ActionHeader actionHeader = (ActionHeader)this.ctx.getHeaders().getHeader(ActionHeader.TYPE);
            if (actionHeader != null) {
                string3 = actionHeader.getActionURI();
                if ("http://schemas.xmlsoap.org/ws/2005/02/rm/LastMessage".equals(actionHeader.getActionURI())) {
                    if (verbose) {
                        Verbose.say("WsDispatchMessageListener IGNORING WS-RM 'LastMessage' message.");
                    }
                    bl = true;
                }
            }
            if (verbose && (string != null || string2 != null)) {
                Verbose.say("*** WsDispatchMessageListener received buffered message with requestSeqId " + string + " requestSeqNum " + string2 + " action(" + string3 + ")");
            }
            try {
                if (!bl) {
                    if (verbose && (string != null || string2 != null)) {
                        Verbose.say("*** Processing buffered sequence message with requestSeqId " + string + " requestSeqNum " + string2 + " action(" + string3 + ")");
                    }
                    WsLifeCycleListenerRegistry.getInstance().onEvent(WsLifeCycleEvent.WSRM_RECV_AFTER_ENQUEUE);
                    String string4 = WsDispatchMessageListener.this.port.getWsdlPort().getBinding().getBindingType();
                    JMSServerTransport jMSServerTransport = new JMSServerTransport(this.targetURI);
                    WsSkel wsSkel = (WsSkel)WsDispatchMessageListener.this.port.getEndpoint();
                    Connection connection = ConnectionFactory.instance().createServerConnection(jMSServerTransport, string4);
                    wsSkel.invoke(connection, WsDispatchMessageListener.this.port, this.ctx);
                    ServerResponsePathDispatcher.handleRMEndProcessing(this.ctx);
                } else if (verbose && (string != null || string2 != null)) {
                    Verbose.say("*** Skipping/ignoring processing for buffered sequence message with requestSeqId " + string + " requestSeqNum " + string2 + " action(" + string3 + ")");
                }
            }
            catch (Exception exception) {
                if (verbose) {
                    Verbose.logException(exception);
                }
                throw exception;
            }
            return null;
        }
    }
}

