/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.server.rmi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.xml.rpc.JAXRPCException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.wsee.async.SOAPInvokeState;
import weblogic.wsee.connection.Connection;
import weblogic.wsee.connection.ConnectionFactory;
import weblogic.wsee.connection.transport.rmi.RMIServerTransport;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.util.WLMessageFactory;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsSkel;

public class RMISoapDispatcher {
    private static final boolean verbose = Verbose.isVerbose(RMISoapDispatcher.class);
    private final WsPort port;

    public RMISoapDispatcher(WsPort wsPort) {
        this.port = wsPort;
    }

    public SOAPMessage dispatch(SOAPInvokeState sOAPInvokeState, String string) {
        try {
            AuthorizedInvoke authorizedInvoke = new AuthorizedInvoke(sOAPInvokeState, string);
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            AuthenticatedSubject authenticatedSubject2 = sOAPInvokeState.getSubject(authenticatedSubject);
            if (authenticatedSubject2 != null) {
                try {
                    return (SOAPMessage)SecurityServiceManager.runAs((AuthenticatedSubject)authenticatedSubject, (AuthenticatedSubject)authenticatedSubject2, (PrivilegedExceptionAction)authorizedInvoke);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (privilegedActionException.getException() instanceof IOException) {
                        throw (IOException)privilegedActionException.getException();
                    }
                    throw new UndeclaredThrowableException(privilegedActionException.getException());
                }
            }
            return (SOAPMessage)authorizedInvoke.run();
        }
        catch (JAXRPCException jAXRPCException) {
            throw jAXRPCException;
        }
        catch (Exception exception) {
            throw new JAXRPCException((Throwable)exception);
        }
    }

    private class AuthorizedInvoke
    implements PrivilegedExceptionAction {
        SoapMessageContext ctx;
        String targetURI;

        AuthorizedInvoke(SOAPInvokeState sOAPInvokeState, String string) {
            this.ctx = new SoapMessageContext(sOAPInvokeState.isSoap12());
            for (String string2 : sOAPInvokeState.getMessageContextProperties().keySet()) {
                this.ctx.setProperty(string2, sOAPInvokeState.getMessageContextProperties().get(string2));
            }
            this.ctx.setMessage(sOAPInvokeState.getSOAPMessage());
            this.targetURI = string;
        }

        public Object run() throws Exception {
            String string = RMISoapDispatcher.this.port.getWsdlPort().getBinding().getBindingType();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            RMIServerTransport rMIServerTransport = new RMIServerTransport(this.targetURI, byteArrayOutputStream);
            WsSkel wsSkel = (WsSkel)RMISoapDispatcher.this.port.getEndpoint();
            Connection connection = ConnectionFactory.instance().createServerConnection(rMIServerTransport, string);
            wsSkel.invoke(connection, RMISoapDispatcher.this.port, this.ctx);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (byArray.length <= 0) {
                return null;
            }
            if (verbose) {
                Verbose.log("Length is " + byArray.length);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            MessageFactory messageFactory = WLMessageFactory.getInstance().getMessageFactory("SOAP12".equals(string));
            return messageFactory.createMessage(new MimeHeaders(), (InputStream)byteArrayInputStream);
        }
    }
}

