/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.server.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import weblogic.j2ee.descriptor.wl.PortComponentBean;
import weblogic.jws.Policies;
import weblogic.jws.Policy;
import weblogic.jws.security.RolesAllowed;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.wsee.deploy.DeployInfo;
import weblogic.wsee.handler.HandlerList;
import weblogic.wsee.handler.HandlerListImpl;
import weblogic.wsee.jaxws.WLSContainer;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.runtime.PolicyContext;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.security.policy.assertions.SecurityPolicyAssertionFactory;
import weblogic.wsee.server.servlet.NoFlushServletOutputStream;
import weblogic.wsee.server.servlet.Processor;
import weblogic.wsee.server.servlet.ProcessorFactory;
import weblogic.wsee.server.servlet.SecurityHelper;
import weblogic.wsee.util.ServerSecurityHelper;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.util.WLMessageFactory;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsSkel;
import weblogic.wsee.wsdl.WsdlBinding;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseWSServlet
extends HttpServlet {
    private static final boolean verbose = Verbose.isVerbose(BaseWSServlet.class);
    private boolean forceNoFlush = Boolean.getBoolean("weblogic.wsee.NoFlush");
    protected WsPort wsPort = null;
    private SecurityHelper securityHelper = null;
    private List<Processor> processerList = null;
    private boolean forceAuth = false;
    private boolean forceHttps = false;
    private boolean forceClientCert = false;
    protected DeployInfo info = null;
    private int responseBufferSize = -1;
    private WLSContainer container;

    BaseWSServlet() {
    }

    public void init() throws ServletException {
        WebAppServletContext webAppServletContext = (WebAppServletContext)this.getServletContext();
        this.securityHelper = new SecurityHelper(webAppServletContext);
        try {
            PortComponentBean portComponentBean;
            this.info = this.loadDeployInfo();
            assert (this.info != null);
            this.info.setVersion(webAppServletContext.getVersionId());
            this.info.setServletContext(webAppServletContext);
            this.wsPort = this.info.createWsPort();
            this.processerList = this.getProcessorList();
            this.forceAuth = BaseWSServlet.checkIfAuthRequired(this.info);
            this.forceHttps = SecurityHelper.isHttpsRequiredByWssp(this.info.getEndpointPolicy());
            this.forceClientCert = SecurityHelper.isClientCertRequiredByWssp(this.info.getEndpointPolicy());
            if (System.getProperty("weblogic.wsee.http.response.BufferSize") != null) {
                this.responseBufferSize = Integer.parseInt(System.getProperty("weblogic.wsee.http.response.BufferSize"));
            }
            if ((portComponentBean = this.info.getWlPortComp()) != null) {
                int n = portComponentBean.getHttpResponseBuffersize();
                if (n != 0) {
                    this.responseBufferSize = n;
                }
                boolean bl = !portComponentBean.isHttpFlushResponse();
                this.forceNoFlush = bl || this.forceNoFlush;
            }
            this.container = new WLSContainer(webAppServletContext, this.info);
            if (verbose) {
                Verbose.banner("Webservice successfully deployed");
            }
        }
        catch (Throwable throwable) {
            if (verbose) {
                Verbose.logException(throwable);
            }
            if (this.info != null) {
                this.info.clean();
            }
            throw new ServletException("Web Service init() failed: " + throwable, throwable);
        }
    }

    protected List<Processor> getProcessorList() {
        return ProcessorFactory.instance().getProcessorList(this.info);
    }

    abstract DeployInfo loadDeployInfo() throws ServletException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        block21: {
            if (verbose) {
                Verbose.banner(httpServletRequest.getRequestURI());
            }
            this.container.setCurrent();
            try {
                if (httpServletRequest.isSecure()) {
                    if (this.forceClientCert && !SecurityHelper.isClientCertPresent(httpServletRequest)) {
                        this.sendAccessError(httpServletRequest, httpServletResponse, "Client Certificate Required!");
                        return;
                    }
                } else if (this.forceHttps) {
                    this.sendAccessError(httpServletRequest, httpServletResponse, "SSL Required!");
                    return;
                }
                if (this.responseBufferSize != -1) {
                    httpServletResponse.setBufferSize(this.responseBufferSize);
                }
                if (this.forceNoFlush) {
                    httpServletResponse = this.createWrappedNoFlushResponse(httpServletResponse);
                }
                AuthorizedInvoke authorizedInvoke = new AuthorizedInvoke(httpServletRequest, httpServletResponse, this);
                AuthenticatedSubject authenticatedSubject = ServerSecurityHelper.getCurrentSubject();
                if (this.forceAuth) {
                    if (SecurityHelper.isAnonymous(authenticatedSubject)) {
                        authenticatedSubject = this.securityHelper.getRequestSubject(httpServletRequest);
                        if (authenticatedSubject == null) {
                            this.sendAuthError(httpServletRequest, httpServletResponse, "Authentication Required!");
                            break block21;
                        } else {
                            ServerSecurityHelper.authenticatedInvoke(authenticatedSubject, authorizedInvoke);
                        }
                        break block21;
                    }
                }
                authorizedInvoke.run();
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (LoginException loginException) {
                this.sendAuthError(httpServletRequest, httpServletResponse, loginException.getMessage());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new ServletException(exception.getMessage(), (Throwable)exception);
            }
            finally {
                this.container.resetCurrent();
            }
        }
        if (!verbose) return;
        Verbose.log("Web Service invocation completed");
    }

    public void destroy() {
        ((WsSkel)this.wsPort.getEndpoint()).getComponent().destroy();
        HandlerList handlerList = this.wsPort.getInternalHandlerList();
        if (null != handlerList && handlerList instanceof HandlerListImpl) {
            ((HandlerListImpl)handlerList).destroy();
        }
    }

    protected void sendAccessError(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException, ServletException {
        try {
            httpServletResponse.setStatus(403);
            SOAPMessage sOAPMessage = this.getFaultMessage("env:Client.Access", string);
            httpServletResponse.setContentType("text/xml");
            sOAPMessage.writeTo((OutputStream)httpServletResponse.getOutputStream());
        }
        catch (SOAPException sOAPException) {
            throw new ServletException("unable to send error:", (Throwable)sOAPException);
        }
    }

    protected void sendAuthError(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException, ServletException {
        try {
            httpServletResponse.setHeader("WWW-Authenticate", "Basic realm=\"" + this.securityHelper.getSecurityRealm() + "\"");
            httpServletResponse.setStatus(401);
            SOAPMessage sOAPMessage = this.getFaultMessage("env:Client.Authentication", string);
            if (WsdlUtils.isSoap12(this.wsPort)) {
                httpServletResponse.setContentType("application/soap+xml");
            } else {
                httpServletResponse.setContentType("text/xml");
            }
            sOAPMessage.writeTo((OutputStream)httpServletResponse.getOutputStream());
        }
        catch (SOAPException sOAPException) {
            throw new ServletException("unable to send error:", (Throwable)sOAPException);
        }
    }

    private SOAPMessage getFaultMessage(String string, String string2) throws SOAPException {
        SOAPMessage sOAPMessage = WLMessageFactory.getInstance().getMessageFactory(WsdlUtils.isSoap12(this.wsPort)).createMessage();
        SOAPFault sOAPFault = sOAPMessage.getSOAPPart().getEnvelope().getBody().addFault();
        sOAPFault.setFaultCode(string);
        sOAPFault.setFaultString(string2);
        return sOAPMessage;
    }

    WsPort getPort() {
        return this.wsPort;
    }

    DeployInfo getDeployInfo() {
        return this.info;
    }

    private static boolean checkIfAuthRequired(DeployInfo deployInfo) throws ServletException {
        try {
            if (SecurityHelper.isBasicAuthReqByWssp(deployInfo.getEndpointPolicy())) {
                return true;
            }
        }
        catch (PolicyException policyException) {
            // empty catch block
        }
        Class clazz = deployInfo.getJwsClass();
        if (clazz.isAnnotationPresent(RolesAllowed.class)) {
            if (clazz.isAnnotationPresent(Policy.class) || clazz.isAnnotationPresent(Policies.class)) {
                return !BaseWSServlet.hasSecurityPolicy(deployInfo);
            }
            return true;
        }
        return false;
    }

    private static boolean hasSecurityPolicy(DeployInfo deployInfo) throws ServletException {
        QName qName = new QName(deployInfo.getWsdlDef().getTargetNamespace(), deployInfo.getServiceName());
        WsdlPort wsdlPort = deployInfo.getWsdlDef().getPorts().get(qName);
        WsdlBinding wsdlBinding = wsdlPort.getBinding();
        Iterator<? extends WsdlBindingOperation> iterator = wsdlBinding.getOperations().values().iterator();
        Iterator<? extends WsdlOperation> iterator2 = wsdlPort.getPortType().getOperations().values().iterator();
        Map map = deployInfo.gePolicySubject().getPolicies();
        PolicyServer policyServer = deployInfo.getWssPolicyContext().getPolicyServer();
        try {
            NormalizedExpression normalizedExpression = null;
            while (iterator.hasNext()) {
                WsdlBindingOperation wsdlBindingOperation = iterator.next();
                while (iterator2.hasNext()) {
                    WsdlOperation wsdlOperation = iterator2.next();
                    normalizedExpression = PolicyContext.getRequestEffectivePolicy(wsdlPort, wsdlOperation, wsdlBindingOperation, policyServer, map);
                    if (normalizedExpression == null || !SecurityPolicyAssertionFactory.hasSecurityPolicy(normalizedExpression) && (!SecurityHelper.hasWsspMessageSecurityPolicy(normalizedExpression) || SecurityHelper.hasWsTrustPolicy(normalizedExpression))) continue;
                    return true;
                }
            }
        }
        catch (PolicyException policyException) {
            throw new ServletException((Throwable)policyException);
        }
        return false;
    }

    private HttpServletResponse createWrappedNoFlushResponse(HttpServletResponse httpServletResponse) {
        return new HttpServletResponseWrapper(httpServletResponse){
            private ServletOutputStream wrappedStream;
            {
                this.wrappedStream = null;
            }

            public ServletOutputStream getOutputStream() throws IOException {
                if (this.wrappedStream == null) {
                    this.wrappedStream = new NoFlushServletOutputStream(super.getOutputStream());
                }
                return this.wrappedStream;
            }
        };
    }

    private static class AuthorizedInvoke
    implements PrivilegedExceptionAction {
        HttpServletRequest request;
        HttpServletResponse response;
        BaseWSServlet servlet;

        AuthorizedInvoke(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BaseWSServlet baseWSServlet) {
            this.request = httpServletRequest;
            this.response = httpServletResponse;
            this.servlet = baseWSServlet;
        }

        public Object run() throws Exception {
            Processor processor;
            boolean bl;
            Iterator iterator = this.servlet.processerList.iterator();
            while (iterator.hasNext() && !(bl = (processor = (Processor)iterator.next()).process(this.request, this.response, this.servlet))) {
            }
            return null;
        }
    }
}

