/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.server.servlet;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Element;
import weblogic.wsee.policy.framework.DOMUtils;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.framework.PolicyStatement;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.server.servlet.BaseWSServlet;
import weblogic.wsee.server.servlet.Processor;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsService;

public class PolicyRequestProcessor
implements Processor {
    private static final boolean verbose = Verbose.isVerbose(PolicyRequestProcessor.class);
    private static final boolean debug = false;

    public boolean process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BaseWSServlet baseWSServlet) throws IOException {
        String string = httpServletRequest.getQueryString();
        if (verbose) {
            Verbose.log("qString = " + string);
            Verbose.log("name = " + httpServletRequest.getParameter("name"));
            Verbose.log("inbound = " + httpServletRequest.getParameter("inbound"));
        }
        if (!"GET".equalsIgnoreCase(httpServletRequest.getMethod()) || !string.startsWith("POLICY&")) {
            return false;
        }
        WsService wsService = baseWSServlet.getPort().getEndpoint().getService();
        PolicyServer policyServer = this.getPolicyServer(wsService);
        PolicyStatement policyStatement = null;
        String string2 = httpServletRequest.getParameter("name");
        policyStatement = this.loadPolicy(httpServletRequest, string2, policyServer);
        if (policyStatement == null) {
            return false;
        }
        Element element = this.toXml(policyStatement, string2);
        this.writePolicy(httpServletResponse, element, string2);
        return true;
    }

    private PolicyStatement loadPolicy(HttpServletRequest httpServletRequest, String string, PolicyServer policyServer) {
        PolicyStatement policyStatement;
        block2: {
            policyStatement = null;
            try {
                String string2 = httpServletRequest.getParameter("inbound");
                boolean bl = "true".equalsIgnoreCase(string2);
                policyStatement = policyServer.getPolicy(string, bl);
            }
            catch (PolicyException policyException) {
                if (!verbose) break block2;
                Verbose.log("Failed to find policy '" + httpServletRequest.getParameter("name") + "'");
                Verbose.log(policyException);
            }
        }
        return policyStatement;
    }

    private Element toXml(PolicyStatement policyStatement, String string) {
        Element element;
        block2: {
            element = null;
            try {
                element = policyStatement.toXML();
            }
            catch (PolicyException policyException) {
                if (!verbose) break block2;
                Verbose.log("Failed to write policy to XML: '" + string + "'");
                Verbose.log(policyException);
            }
        }
        return element;
    }

    private void writePolicy(HttpServletResponse httpServletResponse, Element element, String string) throws IOException {
        httpServletResponse.setContentType("text/xml");
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        servletOutputStream.write(DOMUtils.toXMLString(element).getBytes());
        servletOutputStream.write(10);
        servletOutputStream.flush();
        if (verbose) {
            Verbose.log("Wrote policy '" + string + "'");
        }
    }

    public PolicyServer getPolicyServer(WsService wsService) {
        return wsService.getPolicyServer();
    }
}

