/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.server.servlet;

import java.util.ArrayList;
import java.util.List;
import weblogic.wsee.deploy.DeployInfo;
import weblogic.wsee.deploy.DeployInfoUtil;
import weblogic.wsee.server.servlet.ConsolePageProcessor;
import weblogic.wsee.server.servlet.IndexPageProcessor;
import weblogic.wsee.server.servlet.Processor;
import weblogic.wsee.server.servlet.ServiceInfoProcessor;
import weblogic.wsee.server.servlet.SoapProcessor;
import weblogic.wsee.server.servlet.TestPageProcessor;
import weblogic.wsee.server.servlet.UnknownProcessor;
import weblogic.wsee.server.servlet.WsdlRequestProcessor;
import weblogic.wsee.util.ToStringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProcessorFactory {
    private static ProcessorFactory factory = new ProcessorFactory();
    private List<Processor> processors = new ArrayList<Processor>();
    private List<Processor> processorsNoWsdl = new ArrayList<Processor>();

    private ProcessorFactory() {
        this.processorsNoWsdl.add(new SoapProcessor());
        this.processorsNoWsdl.add(new IndexPageProcessor());
        this.processorsNoWsdl.add(new TestPageProcessor());
        this.processorsNoWsdl.add(new ConsolePageProcessor());
        this.processorsNoWsdl.add(new UnknownProcessor());
        this.processors.addAll(this.processorsNoWsdl);
        this.processors.add(2, new WsdlRequestProcessor());
        this.processors.add(5, new ServiceInfoProcessor());
    }

    static ProcessorFactory instance() {
        return factory;
    }

    List<Processor> getProcessorList(DeployInfo deployInfo) {
        if (DeployInfoUtil.exposeWsdl(deployInfo)) {
            return this.processors;
        }
        return this.processorsNoWsdl;
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.end();
    }
}

