/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.server.servlet;

import java.security.cert.X509Certificate;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import weblogic.management.configuration.SSLMBean;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.utils.http.HttpParsing;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.security.wssp.HttpsTokenAssertion;
import weblogic.wsee.security.wssp.SecurityPolicyAssertionInfo;
import weblogic.wsee.security.wssp.SecurityPolicyAssertionInfoFactory;
import weblogic.wsee.security.wssp.TransportBindingInfo;
import weblogic.wsee.util.MBeanUtil;
import weblogic.wsee.util.ServerSecurityHelper;

public class SecurityHelper {
    private static String AUTHENTICATION_HEADER = "Authorization";
    private final String securityRealm;

    public SecurityHelper(WebAppServletContext webAppServletContext) {
        this.securityRealm = webAppServletContext.getSecurityRealmName();
    }

    public String getSecurityRealm() {
        return this.securityRealm;
    }

    public static boolean isAnonymous(AuthenticatedSubject authenticatedSubject) {
        return SubjectUtils.isUserAnonymous((AuthenticatedSubject)authenticatedSubject);
    }

    public final AuthenticatedSubject getRequestSubject(HttpServletRequest httpServletRequest) throws LoginException {
        return SecurityHelper.getRequestSubject(httpServletRequest, this.securityRealm);
    }

    public static AuthenticatedSubject getRequestSubject(HttpServletRequest httpServletRequest, String string) throws LoginException {
        Object[] objectArray;
        String string2 = httpServletRequest.getHeader(AUTHENTICATION_HEADER);
        if (string2 != null) {
            objectArray = HttpParsing.getAuthInfo((String)string2);
            if (objectArray == null) {
                return null;
            }
            if (objectArray != null && objectArray[0] != null && objectArray[1] != null) {
                return ServerSecurityHelper.assertIdentity((String)objectArray[0], (String)objectArray[1], string);
            }
        }
        if (httpServletRequest.isSecure() && (objectArray = SecurityHelper.getClientCerts(httpServletRequest)) != null && objectArray.length > 0) {
            return ServerSecurityHelper.assertIdentity((X509Certificate[])objectArray, string);
        }
        return null;
    }

    public static boolean isHttpsRequiredByWssp(NormalizedExpression normalizedExpression) {
        return SecurityPolicyAssertionInfoFactory.hasTransportSecurityPolicy(normalizedExpression);
    }

    public static boolean hasWsspMessageSecurityPolicy(NormalizedExpression normalizedExpression) {
        return SecurityPolicyAssertionInfoFactory.hasMessageSecurityPolicy(normalizedExpression);
    }

    public static boolean hasWsTrustPolicy(NormalizedExpression normalizedExpression) {
        return SecurityPolicyAssertionInfoFactory.hasWsTrustPolicy(normalizedExpression);
    }

    public static HttpsTokenAssertion getHttpsTokenAssertion(NormalizedExpression normalizedExpression) {
        if (normalizedExpression.getPolicyAlternatives() != null) {
            for (PolicyAlternative policyAlternative : normalizedExpression.getPolicyAlternatives()) {
                TransportBindingInfo transportBindingInfo;
                SecurityPolicyAssertionInfo securityPolicyAssertionInfo = SecurityPolicyAssertionInfoFactory.getSecurityPolicyAssertionInfo(policyAlternative);
                if (securityPolicyAssertionInfo == null || (transportBindingInfo = securityPolicyAssertionInfo.getTransportBindingInfo()) == null) continue;
                return transportBindingInfo.getHttpsTokenAssertion();
            }
        }
        return null;
    }

    public static boolean isClientCertRequiredByWssp(NormalizedExpression normalizedExpression) {
        HttpsTokenAssertion httpsTokenAssertion = SecurityHelper.getHttpsTokenAssertion(normalizedExpression);
        return httpsTokenAssertion != null && httpsTokenAssertion.isClientCertificateRequired();
    }

    public static boolean isClientCertPresent(HttpServletRequest httpServletRequest) {
        X509Certificate[] x509CertificateArray = SecurityHelper.getClientCerts(httpServletRequest);
        return x509CertificateArray != null && x509CertificateArray.length > 0;
    }

    public static boolean isBasicAuthReqByWssp(NormalizedExpression normalizedExpression) {
        HttpsTokenAssertion httpsTokenAssertion = SecurityHelper.getHttpsTokenAssertion(normalizedExpression);
        return httpsTokenAssertion != null && httpsTokenAssertion.isHttpBasicAuthenticationRequired();
    }

    private static final X509Certificate[] getClientCerts(HttpServletRequest httpServletRequest) {
        try {
            return (X509Certificate[])httpServletRequest.getAttribute("javax.servlet.request.X509Certificate");
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public static boolean isTwoWaySSLEnabled() {
        SSLMBean sSLMBean = MBeanUtil.getLocalSSLMBean();
        return sSLMBean.isTwoWaySSLEnabled() || sSLMBean.isClientCertificateEnforced();
    }
}

