/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.server.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.wsee.server.servlet.BaseWSServlet;
import weblogic.wsee.server.servlet.Processor;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsService;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlService;

public class ServiceInfoProcessor
implements Processor {
    private static final boolean verbose = Verbose.isVerbose(ServiceInfoProcessor.class);

    public boolean process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BaseWSServlet baseWSServlet) throws IOException {
        if ("GET".equalsIgnoreCase(httpServletRequest.getMethod()) && "INFO".equalsIgnoreCase(httpServletRequest.getQueryString())) {
            this.writeSystemInfo(httpServletRequest, httpServletResponse, baseWSServlet);
            return true;
        }
        return false;
    }

    private void writeSystemInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BaseWSServlet baseWSServlet) throws IOException {
        PrintWriter printWriter = httpServletResponse.getWriter();
        this.writeHeader(printWriter);
        this.writeWsService(printWriter, baseWSServlet.getPort());
        this.writeWsdl(printWriter, baseWSServlet.getPort());
        this.writeFooter(printWriter);
    }

    private void writeWsdl(PrintWriter printWriter, WsPort wsPort) {
        this.writeHeading("Web Service Description", printWriter);
        WsService wsService = wsPort.getEndpoint().getService();
        WsdlService wsdlService = wsService.getWsdlService();
        WsdlDefinitions wsdlDefinitions = wsdlService.getDefinitions();
        this.writePre(this.clean(wsdlDefinitions.toString()), printWriter);
    }

    private void writeWsService(PrintWriter printWriter, WsPort wsPort) {
        this.writeHeading("Web Service Info", printWriter);
        WsService wsService = wsPort.getEndpoint().getService();
        this.writePre(this.clean(wsService.toString()), printWriter);
    }

    private void writePre(String string, PrintWriter printWriter) {
        printWriter.println("<table border='1' background='#FFFFEE'>");
        printWriter.println("<tr background='#FFFFEE'><td background='#FFFFEE'>");
        printWriter.println("<pre>");
        printWriter.println(string);
        printWriter.println("</pre>");
        printWriter.println("</td></tr>");
        printWriter.println("<table>");
    }

    private void writeHeading(String string, PrintWriter printWriter) {
        printWriter.println("<h2>");
        printWriter.println(string);
        printWriter.println("</h2>");
    }

    private void writeFooter(PrintWriter printWriter) {
        printWriter.println("</body></html>");
    }

    private void writeHeader(PrintWriter printWriter) {
        printWriter.println("<html><body>");
        printWriter.println("<h1>Web Service System Info</h1>");
    }

    private String clean(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "<>", true);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ("<".equals(string2)) {
                stringBuffer.append("&lt;");
                continue;
            }
            if (">".equals(string2)) {
                stringBuffer.append("&gt;");
                continue;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.end();
    }
}

