/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.server.servlet;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.wsee.connection.Connection;
import weblogic.wsee.connection.ConnectionException;
import weblogic.wsee.connection.ConnectionFactory;
import weblogic.wsee.connection.transport.servlet.HttpServerTransport;
import weblogic.wsee.server.servlet.BaseWSServlet;
import weblogic.wsee.server.servlet.Processor;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsSkel;

public class SoapProcessor
implements Processor {
    private static final boolean verbose = Verbose.isVerbose(SoapProcessor.class);

    public boolean process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BaseWSServlet baseWSServlet) throws IOException {
        if ("POST".equalsIgnoreCase(httpServletRequest.getMethod())) {
            this.handlePost(baseWSServlet, httpServletRequest, httpServletResponse);
            return true;
        }
        return false;
    }

    private void handlePost(BaseWSServlet baseWSServlet, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        assert (baseWSServlet.getPort() != null);
        WsPort wsPort = baseWSServlet.getPort();
        String string = wsPort.getWsdlPort().getBinding().getBindingType();
        HttpServerTransport httpServerTransport = new HttpServerTransport(httpServletRequest, httpServletResponse);
        WsSkel wsSkel = (WsSkel)wsPort.getEndpoint();
        try {
            Connection connection = ConnectionFactory.instance().createServerConnection(httpServerTransport, string);
            wsSkel.invoke(connection, wsPort);
        }
        catch (ConnectionException connectionException) {
            this.sendError(httpServletResponse, connectionException, "Failed to create connection");
        }
        catch (Throwable throwable) {
            this.sendError(httpServletResponse, throwable, "Unknown error");
        }
    }

    private void sendError(HttpServletResponse httpServletResponse, Throwable throwable, String string) throws IOException {
        if (verbose) {
            Verbose.log((Object)"SOAP request failed", throwable);
        }
        httpServletResponse.sendError(500, string + throwable);
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.end();
    }
}

