/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.server.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.wsee.WseeCoreLogger;
import weblogic.wsee.connection.transport.jms.JmsTransportInfo;
import weblogic.wsee.deploy.WsdlAddressInfo;
import weblogic.wsee.policy.deployment.PolicyDeployUtils;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.server.ServerURLNotFoundException;
import weblogic.wsee.server.ServerUtil;
import weblogic.wsee.server.servlet.BaseWSServlet;
import weblogic.wsee.server.servlet.Processor;
import weblogic.wsee.server.servlet.SecurityHelper;
import weblogic.wsee.util.ToStringWriter;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlFilter;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlSchema;
import weblogic.wsee.wsdl.WsdlService;
import weblogic.wsee.wsdl.WsdlUtils;
import weblogic.wsee.wsdl.builder.WsdlDefinitionsBuilder;
import weblogic.wsee.wsdl.builder.WsdlSchemaBuilder;
import weblogic.wsee.wsdl.builder.WsdlServiceBuilder;
import weblogic.wsee.wsdl.internal.WsdlDefinitionsImpl;
import weblogic.wsee.wsdl.soap11.SoapAddress;

public class WsdlRequestProcessor
implements Processor {
    private static final String PATH_TRIM_HEADER = "WL-PATH-TRIM";
    private static final String PATH_PREPEND_HEADER = "WL-PATH-PREPEND";
    private static boolean verbose = Verbose.isVerbose(WsdlRequestProcessor.class);
    private boolean embedPolicies = true;
    private String sslPort = null;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public boolean process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BaseWSServlet baseWSServlet) throws IOException {
        String string = httpServletRequest.getMethod();
        if (string.equalsIgnoreCase("GET") || string.equalsIgnoreCase("HEAD")) {
            WsdlDefinitions wsdlDefinitions = WsdlUtils.findWsdlDefinition(httpServletRequest.getQueryString(), baseWSServlet.getPort().getWsdlPort().getService().getDefinitions());
            if (wsdlDefinitions != null) {
                WsdlAddressInfo wsdlAddressInfo = this.getAddressInfo(httpServletRequest, baseWSServlet);
                this.embedPoliciesInWsdl(wsdlDefinitions, baseWSServlet);
                this.writeWsdl(httpServletResponse, wsdlAddressInfo, wsdlDefinitions);
                return true;
            }
            WsdlSchema wsdlSchema = WsdlUtils.findSchema(httpServletRequest.getQueryString(), (WsdlDefinitionsImpl)baseWSServlet.getPort().getWsdlPort().getService().getDefinitions());
            if (wsdlSchema != null) {
                WsdlAddressInfo wsdlAddressInfo = this.getAddressInfo(httpServletRequest, baseWSServlet);
                this.writeSchema(httpServletResponse, wsdlAddressInfo, wsdlSchema, wsdlDefinitions == null ? null : wsdlDefinitions.getEncoding());
                return true;
            }
        }
        return false;
    }

    private void embedPoliciesInWsdl(WsdlDefinitions wsdlDefinitions, BaseWSServlet baseWSServlet) {
        if (this.embedPolicies) {
            try {
                PolicyDeployUtils.embedPoliciesInWsdl(wsdlDefinitions, baseWSServlet.getPort().getEndpoint().getService().getPolicyServer());
            }
            catch (PolicyException policyException) {
                policyException.printStackTrace();
            }
        }
    }

    private void writeSchema(HttpServletResponse httpServletResponse, WsdlAddressInfo wsdlAddressInfo, WsdlSchema wsdlSchema, String string) throws IOException {
        httpServletResponse.setContentType("text/xml");
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        try {
            ((WsdlSchemaBuilder)wsdlSchema).write((OutputStream)servletOutputStream, wsdlAddressInfo, string);
        }
        catch (WsdlException wsdlException) {
            if (verbose) {
                Verbose.log((Object)"Failed to write schema", wsdlException);
            }
            throw new IOException("Failed to write schema: " + wsdlException);
        }
        if (verbose) {
            Verbose.log("Wrote schema: " + wsdlSchema.getLocationUrl());
        }
    }

    private void writeWsdl(HttpServletResponse httpServletResponse, WsdlAddressInfo wsdlAddressInfo, WsdlDefinitions wsdlDefinitions) throws IOException {
        httpServletResponse.setContentType("text/xml");
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        if (wsdlDefinitions.getEncoding() != null) {
            httpServletResponse.setCharacterEncoding(wsdlDefinitions.getEncoding());
        }
        try {
            ((WsdlDefinitionsBuilder)wsdlDefinitions).write((OutputStream)servletOutputStream, wsdlAddressInfo);
        }
        catch (WsdlException wsdlException) {
            if (verbose) {
                Verbose.log((Object)"Failed to write wsdl", wsdlException);
            }
            throw new IOException("Failed to write WSDL: " + wsdlException);
        }
        if (verbose) {
            Verbose.log("Wrote WSDL: " + wsdlDefinitions.getName());
        }
    }

    private WsdlAddressInfo getAddressInfo(HttpServletRequest httpServletRequest, BaseWSServlet baseWSServlet) throws IOException {
        WsdlAddressInfo wsdlAddressInfo = new WsdlAddressInfo();
        UnsupportedPortsWsdlFilter unsupportedPortsWsdlFilter = null;
        WsdlFilter wsdlFilter = baseWSServlet.getPort().getWsdlPort().getService().getWsdlFilter();
        if (wsdlFilter instanceof UnsupportedPortsWsdlFilter) {
            unsupportedPortsWsdlFilter = (UnsupportedPortsWsdlFilter)wsdlFilter;
            unsupportedPortsWsdlFilter.reset();
        } else {
            unsupportedPortsWsdlFilter = new UnsupportedPortsWsdlFilter(wsdlFilter);
            ((WsdlServiceBuilder)baseWSServlet.getPort().getWsdlPort().getService()).setWsdlFilter(unsupportedPortsWsdlFilter);
        }
        wsdlAddressInfo.setWsdlFilter(unsupportedPortsWsdlFilter);
        boolean bl = httpServletRequest.isSecure();
        URL uRL = new URL(ServerUtil.getHTTPServerURL(bl, httpServletRequest));
        String string = uRL.getHost();
        wsdlAddressInfo.setHost(string);
        int n = uRL.getPort();
        wsdlAddressInfo.setPort("" + n);
        String string2 = httpServletRequest.getRequestURI();
        String string3 = httpServletRequest.getHeader(PATH_TRIM_HEADER);
        String string4 = httpServletRequest.getHeader(PATH_PREPEND_HEADER);
        string2 = WsdlRequestProcessor.rewriteUriForProxyHeaders(string2, string4, string3);
        String string5 = uRL.toString() + string2 + "?WSDL";
        wsdlAddressInfo.setImportPrefix(string5);
        WsdlDefinitions wsdlDefinitions = baseWSServlet.getPort().getWsdlPort().getDefinitions();
        String string6 = string2;
        for (WsdlService wsdlService : wsdlDefinitions.getServices().values()) {
            for (WsdlPort wsdlPort : wsdlService.getPorts().values()) {
                SoapAddress soapAddress;
                if (verbose) {
                    Verbose.log(" process WsdlPort '" + wsdlPort + "'");
                }
                wsdlAddressInfo.addWsdlPort(wsdlPort.getName(), wsdlPort.getPortAddress());
                WsdlAddressInfo.PortAddress portAddress = wsdlPort.getPortAddress();
                if (portAddress == null) {
                    portAddress = wsdlAddressInfo.addWsdlPort(wsdlPort.getName());
                }
                String string7 = this.getProtocol(wsdlPort);
                URL uRL2 = uRL;
                boolean bl2 = string7.equalsIgnoreCase("jms");
                if (bl2) {
                    uRL2 = new URL(ServerUtil.swapProtocol(ServerUtil.getJMSServerURL(), "http"));
                    portAddress.setProtocol("jms");
                } else {
                    if (SecurityHelper.isHttpsRequiredByWssp(WsdlRequestProcessor.getEndpointPolicy(baseWSServlet, wsdlPort))) {
                        uRL2 = new URL(ServerUtil.getHTTPServerURL(true));
                    } else if (!(bl && string7.equalsIgnoreCase("http") || bl || !string7.equalsIgnoreCase("https"))) {
                        try {
                            uRL2 = new URL(ServerUtil.getHTTPServerURL(true));
                        }
                        catch (ServerURLNotFoundException serverURLNotFoundException) {
                            unsupportedPortsWsdlFilter.addUnsupportedPort(wsdlPort.getName());
                            WseeCoreLogger.logServicePortNotAvailableInWSDL((String)wsdlService.getName().getLocalPart(), (String)wsdlPort.getName().getLocalPart(), (String)(uRL.toString() + string2 + "?WSDL"));
                            continue;
                        }
                    }
                    portAddress.setProtocol(uRL2.getProtocol());
                }
                portAddress.setHost(uRL2.getHost());
                portAddress.setListenPort(String.valueOf(uRL2.getPort()));
                String string8 = WsdlUtils.getQueryString(wsdlPort);
                if (verbose) {
                    Verbose.log("Query string:" + string8);
                }
                if ((soapAddress = WsdlUtils.getSoapAddress(wsdlPort)) != null) {
                    try {
                        Serializable serializable;
                        String string9 = soapAddress.getLocation();
                        if (string9.toLowerCase(Locale.ENGLISH).startsWith("jms:")) {
                            serializable = new JmsTransportInfo(string9);
                            string6 = ((JmsTransportInfo)serializable).getServiceUri();
                        }
                        serializable = new URL(string9);
                        string6 = WsdlRequestProcessor.rewriteUriForProxyHeaders(((URL)serializable).getPath(), string4, string3);
                    }
                    catch (Throwable throwable) {
                        throw new IOException(" Error.  Could not determine uri from 'location' for WsdlPort " + wsdlPort + "   " + throwable.getMessage());
                    }
                } else {
                    if (verbose) {
                        Verbose.log("wsdlPort " + wsdlPort + "  has no wsdl extensions (therefore no Soap address) ");
                    }
                    if (portAddress.getServiceuri() != null) {
                        string6 = portAddress.getServiceuri();
                    }
                }
                if (string8 != null) {
                    string6 = string6 + "?" + string8;
                }
                if (verbose) {
                    Verbose.log(" setting Address ServiceUri to '" + string6 + "'");
                }
                portAddress.setServiceuri(string6);
            }
        }
        return wsdlAddressInfo;
    }

    private static final NormalizedExpression getEndpointPolicy(BaseWSServlet baseWSServlet, WsdlPort wsdlPort) throws IOException {
        try {
            return baseWSServlet.getDeployInfo().getWssPolicyContext().getPolicyServer().getEndpointPolicy(wsdlPort);
        }
        catch (PolicyException policyException) {
            throw new IOException(policyException.getMessage());
        }
    }

    private static String rewriteUriForProxyHeaders(String string, String string2, String string3) {
        if (string2 != null && string.startsWith(string2)) {
            string = string.substring(string2.length());
        }
        if (string3 != null) {
            string = string3 + string;
        }
        return string;
    }

    private String getProtocol(WsdlPort wsdlPort) {
        return wsdlPort.getBinding().getTransportProtocol();
    }

    public String toString() {
        ToStringWriter toStringWriter = new ToStringWriter();
        this.toString(toStringWriter);
        return toStringWriter.toString();
    }

    public void toString(ToStringWriter toStringWriter) {
        toStringWriter.start(this);
        toStringWriter.end();
    }

    private class UnsupportedPortsWsdlFilter
    implements WsdlFilter {
        private WsdlFilter delegate = null;
        private Set<QName> unsupportedPorts = new HashSet<QName>();

        public UnsupportedPortsWsdlFilter(WsdlFilter wsdlFilter) {
            this.setDelegate(wsdlFilter);
        }

        public void setDelegate(WsdlFilter wsdlFilter) {
            this.delegate = wsdlFilter;
        }

        public WsdlFilter getDelegate() {
            return this.delegate;
        }

        public void addUnsupportedPort(QName qName) {
            this.unsupportedPorts.add(qName);
        }

        public void removeUnsupportedPort(QName qName) {
            this.unsupportedPorts.remove(qName);
        }

        public void reset() {
            this.unsupportedPorts.clear();
        }

        public boolean isPortSupported(QName qName) {
            if (this.unsupportedPorts.contains(qName)) {
                return false;
            }
            if (this.delegate != null) {
                return this.delegate.isPortSupported(qName);
            }
            return true;
        }

        public boolean isMessagePartSupported(QName qName, String string) {
            if (this.delegate != null) {
                return this.delegate.isMessagePartSupported(qName, string);
            }
            return true;
        }

        public String rewritePortUrl(QName qName, String string, String string2, String string3, String string4, String string5) {
            if (this.delegate != null) {
                return this.delegate.rewritePortUrl(qName, string, string2, string3, string4, string5);
            }
            return string + "://" + string2 + ":" + string3 + string4;
        }
    }
}

