/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.tools.ant.Project;
import weblogic.wsee.tools.anttasks.AntUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TempDirManager {
    private final Project project;
    private Set<File> tempDirs = new HashSet<File>();

    public TempDirManager(Project project) {
        this.project = project;
    }

    public File createTempDir(String string, File file) throws IOException {
        String string2 = "_" + Long.toString(Math.abs(string.hashCode()), 36);
        File file2 = new File(file, string2);
        int n = 0;
        while (file2.exists()) {
            file2 = new File(file, string2 + n++);
        }
        if (!file2.mkdirs()) {
            throw new IOException("Unable to create temp dir " + file2);
        }
        this.tempDirs.add(file2);
        return file2;
    }

    public void cleanup() {
        for (File file : this.tempDirs) {
            AntUtil.deleteDir(this.project, file);
        }
        this.tempDirs.clear();
    }

    public Set<File> getTempDirs() {
        return Collections.unmodifiableSet(this.tempDirs);
    }
}

