/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.tools.logging.Logger;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.Verbose;

public class ToolsUtil {
    private static final boolean verbose = Verbose.isVerbose(ToolsUtil.class);

    private ToolsUtil() {
    }

    public static PrintStream createJavaSourceStream(File file, String string) throws WsBuildException {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            throw new WsBuildException("Package name not found in:" + string);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, string.length());
        return ToolsUtil.createJavaSourceStream(file, string2, string3);
    }

    public static PrintStream createJavaSourceStream(File file, String string, String string2) throws WsBuildException {
        File file2 = new File(file, string.replace('.', File.separatorChar));
        file2.mkdirs();
        File file3 = new File(file2, string2 + ".java");
        if (verbose) {
            Verbose.log("Creating java source file at: " + file3);
        }
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(new FileOutputStream(file3), true);
        }
        catch (IOException iOException) {
            throw new WsBuildException("Failed to open file for ouput." + iOException, iOException);
        }
        return printStream;
    }

    public static String getPackageName(String string) {
        int n = string.lastIndexOf(".");
        return n == -1 ? null : string.substring(0, n);
    }

    public static void validateNonEmptyAttr(String string, String string2) throws WsBuildException {
        ToolsUtil.validateNonEmptyAttr(string, string2, null);
    }

    public static void validateNonEmptyAttr(String string, String string2, Logger logger) throws WsBuildException {
        if (StringUtil.isEmpty(string)) {
            ToolsUtil.throwException("The empty string is not a valid attribute for: " + string2, logger);
        }
    }

    public static void throwException(String string, Logger logger) throws WsBuildException {
        if (logger != null) {
            logger.log(EventLevel.ERROR, string);
        }
        throw new WsBuildException(string);
    }

    public static void validateRequiredFile(File file, String string) throws WsBuildException {
        ToolsUtil.validateRequiredFile(file, string, null);
    }

    public static void validateRequiredFile(File file, String string, Logger logger) throws WsBuildException {
        if (file == null) {
            ToolsUtil.throwException("The required attribute: " + string + " must be set.", logger);
        } else {
            ToolsUtil.validateNonEmptyAttr(file.getName(), string, logger);
        }
    }

    public static void createDir(File file, String string) throws WsBuildException {
        if (!file.exists() && !file.mkdirs()) {
            throw new WsBuildException("Unable to create the directory " + string + ":  " + file.getName());
        }
    }

    public static void validateRequiredAttr(String string, String string2) throws WsBuildException {
        ToolsUtil.validateRequiredAttr(string, string2, null);
    }

    public static void validateRequiredAttr(String string, String string2, Logger logger) throws WsBuildException {
        if (string == null) {
            ToolsUtil.throwException("The required attribute: " + string2 + " must be set", logger);
        } else {
            ToolsUtil.validateNonEmptyAttr(string, string2, logger);
        }
    }

    public static String normalize(String string) {
        if (StringUtil.isEmpty(string)) {
            throw new IllegalArgumentException(string);
        }
        String string2 = string.replaceAll("\\\\", "/");
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        return string2;
    }
}

