/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.anttasks;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.Javadoc;
import org.apache.tools.ant.taskdefs.Move;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntUtil {
    private AntUtil() {
    }

    public static void deleteDir(Project project, File file) throws BuildException {
        Delete delete = new Delete();
        delete.setTaskName("AntUtil.deleteDir");
        delete.setProject(project);
        delete.setDir(file);
        delete.setIncludeEmptyDirs(true);
        delete.setDeleteOnExit(true);
        delete.execute();
    }

    public static void copyFile(Project project, File file, File file2) throws BuildException {
        Copy copy = new Copy();
        copy.setProject(project);
        copy.setTaskName("AntUtil.copyFile");
        copy.setFile(file);
        copy.setTofile(file2);
        copy.setOverwrite(true);
        copy.execute();
    }

    public static void copyFiles(Project project, List<FileSet> list, File file) throws BuildException {
        if (list.isEmpty()) {
            return;
        }
        Copy copy = new Copy();
        copy.setProject(project);
        copy.setTaskName("AntUtil.copyFiles");
        for (FileSet fileSet : list) {
            copy.addFileset(fileSet);
        }
        copy.setTodir(file);
        copy.setOverwrite(true);
        copy.execute();
    }

    public static void moveFiles(Project project, File file, File file2, String string) throws BuildException {
        Move move = new Move();
        move.setTaskName("AntUtil.moveFiles");
        move.setProject(project);
        move.setTodir(file2);
        FileSet fileSet = new FileSet();
        fileSet.setDir(file);
        fileSet.setIncludes(string);
        move.addFileset(fileSet);
        move.execute();
    }

    public static void copyFiles(Project project, File file, File file2, String string) throws BuildException {
        Copy copy = new Copy();
        copy.setTaskName("AntUtil.copyFiles");
        copy.setProject(project);
        file2.mkdirs();
        FileSet fileSet = new FileSet();
        fileSet.setDir(file);
        fileSet.setIncludes(string);
        copy.addFileset(fileSet);
        copy.setTodir(file2);
        copy.execute();
    }

    public static void javadocFiles(Project project, String string, File file) {
        Javadoc javadoc = new Javadoc();
        javadoc.setTaskName("AntUtil.javadocFiles");
        javadoc.setProject(project);
        file.mkdirs();
        javadoc.setDestdir(file);
        javadoc.setSourcefiles(string);
        javadoc.execute();
    }

    public static File[] getFiles(Collection<FileSet> collection, Project project) {
        if (collection.size() == 0) {
            return null;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (FileSet fileSet : collection) {
            AntUtil.loadFiles(fileSet, arrayList, project);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public static File[] getFiles(FileSet fileSet, Project project) {
        ArrayList<File> arrayList = new ArrayList<File>();
        AntUtil.loadFiles(fileSet, arrayList, project);
        return arrayList.toArray(new File[arrayList.size()]);
    }

    private static void loadFiles(FileSet fileSet, List<File> list, Project project) {
        String[] stringArray;
        DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(project);
        for (String string : stringArray = directoryScanner.getIncludedFiles()) {
            File file = new File(fileSet.getDir(project), string);
            if (!file.isFile()) continue;
            list.add(file);
        }
    }

    public static Collection<FileSet> getFileSets(File[] fileArray, Project project) {
        HashMap<File, FileSet> hashMap = new HashMap<File, FileSet>();
        if (fileArray != null) {
            for (File file : fileArray) {
                FileSet fileSet = (FileSet)hashMap.get(file.getParentFile());
                if (fileSet == null) {
                    fileSet = new FileSet();
                    fileSet.setProject(project);
                    fileSet.setDir(file.getParentFile());
                    hashMap.put(file.getParentFile(), fileSet);
                }
                fileSet.createInclude().setName(file.getName());
            }
        }
        return hashMap.values();
    }
}

