/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.anttasks;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.XMLCatalog;
import weblogic.wsee.WebServiceType;
import weblogic.wsee.bind.TypeFamily;
import weblogic.wsee.tools.ToolsUtil;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.anttasks.AntUtil;
import weblogic.wsee.tools.clientgen.ClientGen;
import weblogic.wsee.tools.clientgen.ClientGenFactory;
import weblogic.wsee.tools.clientgen.jaxrpc.ClientGenProcessor;
import weblogic.wsee.tools.clientgen.jaxrpc.Options;
import weblogic.wsee.tools.logging.AntLogger;

public class ClientGenFacadeTask
extends Task {
    protected String wsdl;
    private String packageName;
    protected File destDir;
    private List<FileSet> bindingFileSets = new ArrayList<FileSet>();
    protected WebServiceType type = WebServiceType.JAXRPC;
    private Options jaxrpcOptions;
    protected weblogic.wsee.tools.clientgen.jaxws.Options jaxwsOptions;

    private void initJAXRPCOptions() {
        if (this.jaxrpcOptions == null) {
            this.jaxrpcOptions = new Options();
        }
    }

    public void initJAXWSOptions() {
        if (this.jaxwsOptions == null) {
            this.jaxwsOptions = new weblogic.wsee.tools.clientgen.jaxws.Options();
        }
    }

    public void setCatalog(File file) {
        this.initJAXWSOptions();
        this.jaxwsOptions.setCatalog(file);
    }

    public void addConfiguredSysProperty(Environment.Variable variable) {
        this.initJAXRPCOptions();
        this.jaxrpcOptions.addSysemProperty(variable.getKey(), variable.getValue());
        this.initJAXWSOptions();
        this.jaxwsOptions.addSysemProperty(variable.getKey(), variable.getValue());
    }

    public void addConfiguredDepends(FileSet fileSet) {
        this.initJAXWSOptions();
        this.jaxwsOptions.addConfiguredDepends(fileSet);
    }

    public void addConfiguredProduces(FileSet fileSet) {
        this.initJAXWSOptions();
        this.jaxwsOptions.addConfiguredProduces(fileSet);
    }

    @Deprecated
    public void addXsdConfig(FileSet fileSet) {
        this.log("xsdConfig is deprecated.  Use binding instead.", 1);
        this.addBinding(fileSet);
    }

    public void addBinding(FileSet fileSet) {
        this.bindingFileSets.add(fileSet);
    }

    public void setAutoDetectWrapped(boolean bl) {
        this.initJAXRPCOptions();
        this.jaxrpcOptions.setAutoDetectWrapped(bl);
    }

    public void setIncludeGlobalTypes(boolean bl) {
        this.initJAXRPCOptions();
        this.jaxrpcOptions.setIncludeGlobalTypes(bl);
    }

    public void setSortSchemaTypes(boolean bl) {
        this.initJAXRPCOptions();
        this.jaxrpcOptions.setSortSchemaTypes(bl);
    }

    public void setFillIncompleteParameterOrderList(boolean bl) {
        this.initJAXRPCOptions();
        this.jaxrpcOptions.setFillIncompleteParameterOrderList(bl);
    }

    public void setWsdl(String string) {
        try {
            ToolsUtil.validateRequiredAttr(string, "wsdl");
        }
        catch (WsBuildException wsBuildException) {
            throw new BuildException(wsBuildException.getMessage());
        }
        File file = this.getProject().resolveFile(string);
        if (file != null && file.isDirectory()) {
            throw new BuildException("wsdl attribute must not be a directory");
        }
        this.wsdl = file != null && file.exists() ? file.toURI().toString() : string;
    }

    public void setServiceName(String string) {
        this.initJAXRPCOptions();
        this.jaxrpcOptions.setServiceName(string);
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    void setDestDir(File file) {
        this.destDir = file;
    }

    public File getDestDir() {
        return this.destDir;
    }

    public void setHandlerChainFile(File file) {
        this.initJAXRPCOptions();
        this.jaxrpcOptions.setHandlerChain(file);
    }

    public void setGeneratePolicyMethods(boolean bl) {
        this.initJAXRPCOptions();
        this.jaxrpcOptions.setGeneratePolicyMethods(bl);
    }

    public void setJaxRPCWrappedArrayStyle(boolean bl) {
        this.initJAXRPCOptions();
        this.jaxrpcOptions.setJaxRPCWrappedArrayStyle(bl);
    }

    public void setGenerateAsyncMethods(boolean bl) {
        this.initJAXRPCOptions();
        this.jaxrpcOptions.setGenerateAsyncMethods(bl);
    }

    public void setTypeFamily(String string) {
        this.initJAXRPCOptions();
        TypeFamily typeFamily = TypeFamily.getTypeFamilyForKey(string);
        this.jaxrpcOptions.setTypeFamily(typeFamily);
    }

    public WebServiceType getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = WebServiceType.valueOf(string);
    }

    void addProcessor(ClientGenProcessor clientGenProcessor) {
        this.initJAXRPCOptions();
        this.jaxrpcOptions.addProcessor(clientGenProcessor);
    }

    private void validate() throws BuildException {
        if (this.type == WebServiceType.JAXWS && this.jaxrpcOptions != null) {
            this.log("Ignoring JAX-RPC options - building a JAX-WS client", 1);
        }
        if (this.type == WebServiceType.JAXRPC && this.jaxwsOptions != null) {
            if (this.jaxwsOptions.getCatalog() != null || this.jaxwsOptions.getXmlCatalog() != null) {
                throw new BuildException("clientgen does not support catalog feature on JAXRPC type!");
            }
            this.log("Ignoring JAX-WS options - building a JAX-RPC client", 1);
        }
    }

    public void execute() throws BuildException {
        this.validate();
        try {
            ClientGen clientGen = ClientGenFactory.newInstance(this.type);
            clientGen.setDestDir(this.destDir);
            clientGen.setPackageName(this.packageName);
            clientGen.setWsdl(this.wsdl);
            File[] fileArray = AntUtil.getFiles(this.bindingFileSets, this.getProject());
            if (!(this.bindingFileSets.isEmpty() || fileArray != null && fileArray.length != 0)) {
                this.log("Warning: Not found binding files defined in binding sub-element, some binding configuration might not take effect!");
            }
            clientGen.setBindingFiles(fileArray);
            clientGen.setLogger(new AntLogger(this));
            if (this.type == WebServiceType.JAXRPC) {
                clientGen.setOptions(this.jaxrpcOptions);
            } else if (this.type == WebServiceType.JAXWS) {
                clientGen.setOptions(this.jaxwsOptions);
            }
            this.log(clientGen.toString(), 2);
            clientGen.execute();
        }
        catch (WsBuildException wsBuildException) {
            throw new BuildException((Throwable)wsBuildException);
        }
    }

    public void init() {
        this.jaxrpcOptions = null;
    }

    public void addConfiguredXmlCatalog(XMLCatalog xMLCatalog) {
        this.initJAXWSOptions();
        xMLCatalog.setProject(this.getProject());
        this.jaxwsOptions.setXmlCatalog(xMLCatalog);
    }

    public void setGenerateRuntimeCatalog(boolean bl) {
        this.initJAXWSOptions();
        this.jaxwsOptions.setGenRuntimeCatalog(bl);
    }

    public void setWsdlLocation(String string) {
        this.initJAXWSOptions();
        this.jaxwsOptions.setWsdllocationOverride(string);
    }

    public void setCopyWsdl(boolean bl) {
        this.initJAXWSOptions();
        this.jaxwsOptions.setCopyWsdl(bl);
    }

    public void setAllowWrappedArrayForDocLiteral(boolean bl) {
        this.initJAXRPCOptions();
        this.jaxrpcOptions.setAllowWrappedArrayForDocLiteral(bl);
    }

    public void setXauthfile(File file) {
        this.initJAXWSOptions();
        this.jaxwsOptions.setXauthfile(file);
    }
}

