/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.anttasks;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import weblogic.wsee.WebServiceType;
import weblogic.wsee.tools.TempDirManager;
import weblogic.wsee.tools.anttasks.AntUtil;
import weblogic.wsee.tools.anttasks.ClientGenFacadeTask;
import weblogic.wsee.tools.anttasks.DelegatingJavacTask;
import weblogic.wsee.tools.xcatalog.CatalogInfo;
import weblogic.wsee.tools.xcatalog.ClientGenXMLs;
import weblogic.wsee.util.JAXWSClassLoaderFactory;

public class ClientGenTask
extends ClientGenFacadeTask {
    private boolean failOnError = true;
    private File destFile;
    private File srcDir;
    private List<FileSet> fileSets = new ArrayList<FileSet>();
    private boolean overwrite = false;
    private final DelegatingJavacTask javac = new DelegatingJavacTask();

    public void setSrcdir(File file) {
        this.srcDir = file;
    }

    public void addFileSet(FileSet fileSet) {
        assert (fileSet != null);
        this.fileSets.add(fileSet);
    }

    public void setDestfile(File file) {
        this.destFile = file;
    }

    public void setDestDir(File file) {
        super.setDestDir(file);
        this.javac.setDestdir(file);
    }

    private void compileAndMakeJar() throws Exception {
        if (this.destFile == null) {
            AntUtil.copyFiles(this.javac.getProject(), this.fileSets, this.javac.getDestdir());
        } else {
            this.compileFiles();
            this.makeJar();
        }
    }

    private void compileFiles() throws IOException {
        FileSet fileSet = new FileSet();
        fileSet.setProject(this.javac.getProject());
        fileSet.setDir(this.javac.getDestdir());
        fileSet.setIncludes("**/*.java");
        DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.javac.getProject());
        String[] stringArray = directoryScanner.getIncludedFiles();
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string : stringArray) {
            arrayList.add(new File(this.javac.getDestdir(), string).getCanonicalFile());
        }
        this.javac.compile(arrayList.toArray(new File[arrayList.size()]));
    }

    private void makeJar() {
        Jar jar = new Jar();
        jar.setProject(this.javac.getProject());
        jar.setDestFile(this.destFile);
        jar.setBasedir(this.javac.getDestdir());
        FileSet fileSet = new FileSet();
        fileSet.setDir(this.javac.getDestdir());
        jar.addFileset(fileSet);
        for (FileSet fileSet2 : this.fileSets) {
            jar.addFileset(fileSet2);
        }
        jar.setExcludes("**/*");
        if (this.overwrite) {
            jar.setUpdate(true);
        }
        jar.execute();
        this.deleteTempFiles();
    }

    private void deleteTempFiles() {
        AntUtil.deleteDir(this.javac.getProject(), this.javac.getDestdir());
    }

    private void intializeCompilerClasspath() {
        if (this.javac.getClasspath() == null) {
            this.javac.createClasspath();
        }
    }

    private void validate() throws BuildException {
        if (this.javac.getDestdir() != null && this.destFile != null) {
            throw new BuildException("Both DestDir and DestFile options are specified. Please specify only one");
        }
        if (this.destFile != null && this.destFile.isDirectory()) {
            throw new BuildException("Destination File cannot be a directory");
        }
    }

    private AntClassLoader createClassLoader() {
        ClassLoader classLoader = ClientGenTask.class.getClassLoader();
        return new AntClassLoader(classLoader, this.javac.getProject(), this.javac.getClasspath(), true);
    }

    public void setDebugLevel(String string) {
        this.javac.setDebugLevel(string);
    }

    public void setProject(Project project) {
        super.setProject(project);
        this.javac.setProject(project);
    }

    public void setSource(String string) {
        this.javac.setSource(string);
    }

    public void setSourcepath(Path path) {
        this.javac.setSourcepath(path);
    }

    public Path createSourcepath() {
        return this.javac.createSourcepath();
    }

    public void setSourcepathRef(Reference reference) {
        this.javac.setSourcepathRef(reference);
    }

    public void setClasspath(Path path) {
        this.javac.setClasspath(path);
    }

    public Path createClasspath() {
        return this.javac.createClasspath();
    }

    public void setClasspathRef(Reference reference) {
        this.javac.setClasspathRef(reference);
    }

    public void setBootclasspath(Path path) {
        this.javac.setBootclasspath(path);
    }

    public void setBootClasspathRef(Reference reference) {
        this.javac.setBootClasspathRef(reference);
    }

    public void setExtdirs(Path path) {
        this.javac.setExtdirs(path);
    }

    public Path createExtdirs() {
        return this.javac.createExtdirs();
    }

    public void setListfiles(boolean bl) {
        this.javac.setListfiles(bl);
    }

    public void setFailonerror(boolean bl) {
        this.failOnError = bl;
        this.javac.setFailonerror(bl);
    }

    public void setProceed(boolean bl) {
        this.javac.setProceed(bl);
    }

    public void setDeprecation(boolean bl) {
        this.javac.setDeprecation(bl);
    }

    public void setMemoryMaximumSize(String string) {
        this.javac.setMemoryMaximumSize(string);
    }

    public void setMemoryInitialSize(String string) {
        this.javac.setMemoryInitialSize(string);
    }

    public void setEncoding(String string) {
        this.javac.setEncoding(string);
    }

    public void setDebug(boolean bl) {
        this.javac.setDebug(bl);
    }

    public void setOptimize(boolean bl) {
        this.javac.setOptimize(bl);
    }

    public void setDepend(boolean bl) {
        this.javac.setDepend(bl);
    }

    public void setVerbose(boolean bl) {
        this.javac.setVerbose(bl);
    }

    public void setIncludeantruntime(boolean bl) {
        this.javac.setIncludeantruntime(bl);
    }

    public void setIncludejavaruntime(boolean bl) {
        this.javac.setIncludejavaruntime(bl);
    }

    public void setFork(boolean bl) {
        this.javac.setFork(bl);
    }

    public void setTempdir(File file) {
        this.javac.setTempdir(file);
    }

    public void setExecutable(String string) {
        this.javac.setExecutable(string);
    }

    public void setNowarn(boolean bl) {
        this.javac.setNowarn(bl);
    }

    public Javac.ImplementationSpecificArgument createCompilerArg() {
        return this.javac.createCompilerArg();
    }

    public void setCompiler(String string) {
        this.javac.setCompiler(string);
    }

    public Path getSourcepath() {
        if (this.javac.getSourcepath() == null) {
            Path path = this.createSourcepath();
            path.createPathElement().setLocation(this.srcDir);
        }
        return this.javac.getSourcepath();
    }

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        this.validate();
        this.intializeCompilerClasspath();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        AntClassLoader antClassLoader = this.createClassLoader();
        if (WebServiceType.JAXWS.equals((Object)this.type)) {
            JAXWSClassLoaderFactory.getInstance().setContextLoader((ClassLoader)antClassLoader);
        } else {
            Thread.currentThread().setContextClassLoader((ClassLoader)antClassLoader);
        }
        TempDirManager tempDirManager = null;
        try {
            tempDirManager = this.initialize();
            this.initJAXWSOptions();
            this.jaxwsOptions.setDebug(this.javac.getDebug());
            this.jaxwsOptions.setDebugLevel(this.javac.getDebugLevel());
            this.jaxwsOptions.setVerbose(this.javac.getVerbose());
            this.jaxwsOptions.setOptimize(this.javac.getOptimize());
            this.jaxwsOptions.setIncludeantruntime(this.javac.getIncludeantruntime());
            this.jaxwsOptions.setIncludejavaruntime(this.javac.getIncludejavaruntime());
            this.jaxwsOptions.setFork(this.javac.getFork());
            CatalogInfo catalogInfo = ClientGenXMLs.processClient(this, this.type, this.jaxwsOptions, this.wsdl, null);
            super.execute();
            File file = this.destDir;
            if (this.destFile != null) {
                file = this.javac.getDestdir();
            }
            ClientGenXMLs.doAllCatalogFiles(this, new File(file, "META-INF"), catalogInfo);
            this.compileAndMakeJar();
        }
        catch (Exception exception) {
            if (this.javac.getVerbose()) {
                StringWriter stringWriter = new StringWriter();
                exception.printStackTrace(new PrintWriter(stringWriter));
                this.log(stringWriter.toString(), 0);
            }
            if (this.failOnError) {
                throw new BuildException((Throwable)exception);
            }
            this.log("ClientGen Build Failed : " + exception.getMessage(), 0);
        }
        finally {
            if (antClassLoader != null) {
                antClassLoader.cleanup();
            }
            Thread.currentThread().setContextClassLoader(classLoader);
            if (tempDirManager != null) {
                tempDirManager.cleanup();
            }
        }
    }

    private TempDirManager initialize() throws IOException {
        TempDirManager tempDirManager = new TempDirManager(this.getProject());
        if (this.destFile != null) {
            File file = tempDirManager.createTempDir("clientgen", this.javac.getTempdir());
            this.setDestDir(file);
        }
        return tempDirManager;
    }
}

