/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.anttasks;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import weblogic.application.ApplicationDescriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.j2ee.descriptor.ModuleBean;
import weblogic.j2ee.descriptor.WebBean;
import weblogic.j2ee.descriptor.wl.LibraryRefBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.wsee.util.DescriptorBeanUtil;
import weblogic.wsee.util.IOUtil;

class EarFile {
    private File earDir = null;
    private File applicationXml = null;
    private File weblogicApplicationXml = null;
    private boolean appBeanDirty = false;
    private boolean weblogicAppBeanDirty = false;
    private ApplicationBean appBean = null;
    private WeblogicApplicationBean weblogicAppBean = null;
    private String enc = null;
    private Set<String> addedModules = new HashSet<String>();

    EarFile(File file, String string) {
        this.earDir = file;
        this.enc = string;
        this.setApplicationXml(null);
    }

    void setApplicationXml(File file) {
        this.applicationXml = file == null ? new File(this.earDir, "META-INF/application.xml") : file;
        this.weblogicApplicationXml = new File(this.applicationXml.getParentFile(), "weblogic-application.xml");
    }

    File getEarDir() {
        return this.earDir;
    }

    File getAppInfDir() {
        return new File(this.earDir, "APP-INF");
    }

    void addWebModule(String string, String string2) throws IOException {
        WebBean webBean;
        ApplicationBean applicationBean = this.getApplicationBean();
        ModuleBean[] moduleBeanArray = applicationBean.getModules();
        boolean bl = false;
        for (int i = 0; i < moduleBeanArray.length && !bl; ++i) {
            webBean = moduleBeanArray[i].getWeb();
            if (webBean == null) continue;
            if (webBean.getWebUri().equals(string)) {
                bl = true;
                if (webBean.getContextRoot().equals(string2)) continue;
                webBean.setContextRoot(string2);
                this.appBeanDirty = true;
                continue;
            }
            if (!webBean.getContextRoot().equals(string2)) continue;
            throw new IOException("Context path " + string2 + " for web application " + string + " is already in use by this application.");
        }
        if (!bl) {
            ModuleBean moduleBean = applicationBean.createModule();
            webBean = moduleBean.createWeb();
            webBean.setWebUri(string);
            webBean.setContextRoot(string2);
            this.appBeanDirty = true;
        }
        this.addedModules.add(string);
    }

    void addEjbModule(String string) throws IOException {
        ApplicationBean applicationBean = this.getApplicationBean();
        ModuleBean[] moduleBeanArray = applicationBean.getModules();
        for (int i = 0; i < moduleBeanArray.length; ++i) {
            if (!string.equals(moduleBeanArray[i].getEjb())) continue;
            return;
        }
        ModuleBean moduleBean = applicationBean.createModule();
        moduleBean.setEjb(string);
        this.appBeanDirty = true;
        this.addedModules.add(string);
    }

    boolean isAdded(String string) {
        return this.addedModules.contains(string);
    }

    void addLibrary(String string) throws IOException {
        LibraryRefBean libraryRefBean;
        WeblogicApplicationBean weblogicApplicationBean = this.getWeblogicApplicationBean();
        for (LibraryRefBean libraryRefBean2 : libraryRefBean = weblogicApplicationBean.getLibraryRefs()) {
            if (!libraryRefBean2.getLibraryName().equals(string)) continue;
            return;
        }
        LibraryRefBean libraryRefBean3 = weblogicApplicationBean.createLibraryRef();
        libraryRefBean3.setLibraryName(string);
        this.weblogicAppBeanDirty = true;
    }

    private synchronized ApplicationBean getApplicationBean() throws IOException {
        if (this.appBean == null) {
            System.out.println("[EarFile] Application File : " + this.applicationXml.getAbsolutePath());
            ApplicationDescriptor applicationDescriptor = new ApplicationDescriptor(this.applicationXml, null, (File)null, null, null, null);
            applicationDescriptor.setValidateSchema(false);
            try {
                this.appBean = applicationDescriptor.getApplicationDescriptor();
            }
            catch (IOException iOException) {
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
            if (this.appBean == null) {
                this.appBean = (ApplicationBean)new EditableDescriptorManager().createDescriptorRoot(ApplicationBean.class).getRootBean();
                this.appBean.setVersion("5");
                int n = this.earDir.getAbsolutePath().lastIndexOf("/");
                if (n == -1) {
                    n = this.earDir.getAbsolutePath().lastIndexOf("\\");
                }
                String string = this.earDir.getAbsolutePath().substring(n + 1);
                this.appBean.setDisplayNames(new String[]{string});
            }
        }
        return this.appBean;
    }

    private synchronized WeblogicApplicationBean getWeblogicApplicationBean() throws IOException {
        if (this.weblogicAppBean == null) {
            this.weblogicAppBean = DescriptorBeanUtil.loadWeblogicAppBean(this.weblogicApplicationXml);
            if (this.weblogicAppBean == null) {
                this.weblogicAppBean = (WeblogicApplicationBean)new EditableDescriptorManager().createDescriptorRoot(WeblogicApplicationBean.class).getRootBean();
            }
        }
        return this.weblogicAppBean;
    }

    void write() throws IOException {
        this.writeBean(this.applicationXml, this.getApplicationBean());
        this.writeBean(this.weblogicApplicationXml, this.getWeblogicApplicationBean());
        this.addedModules.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBean(File file, Object object) throws IOException {
        file.getParentFile().mkdirs();
        OutputStream outputStream = IOUtil.createEncodedFileOutputStream(file, this.enc);
        try {
            new EditableDescriptorManager().writeDescriptorAsXML(((DescriptorBean)object).getDescriptor(), outputStream, this.enc);
            outputStream.flush();
        }
        finally {
            outputStream.close();
        }
    }
}

