/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.anttasks;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ZipFileSet;
import weblogic.wsee.tools.WsBuildException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JarFile {
    private static final Zip.Duplicate DUPLICATE = new Zip.Duplicate();
    private final Task owningTask;
    private final File outputFile;
    private final File baseDir;
    private final List<ZipFileSet> zipFileSets = new ArrayList<ZipFileSet>();

    JarFile(Task task, File file, File file2) {
        assert (task != null);
        assert (file != null);
        assert (file2 != null);
        this.owningTask = task;
        this.outputFile = file;
        this.baseDir = file2;
    }

    void addZipFileSet(ZipFileSet zipFileSet) {
        this.zipFileSets.add(zipFileSet);
    }

    void addZipFileSets(List<ZipFileSet> list) {
        this.zipFileSets.addAll(list);
    }

    private void copy() {
        File file = this.outputFile;
        file.mkdirs();
        for (ZipFileSet zipFileSet : this.zipFileSets) {
            Copy copy = new Copy();
            copy.setTaskName(this.owningTask.getTaskName());
            copy.setProject(this.owningTask.getProject());
            copy.addFileset((FileSet)zipFileSet);
            String string = zipFileSet.getPrefix(this.owningTask.getProject());
            String string2 = string == null ? "" : string;
            copy.setTodir(new File(file, string2));
            copy.execute();
        }
    }

    private void jar() throws WsBuildException {
        File file = this.outputFile;
        this.prepareJar(file);
        Jar jar = new Jar();
        jar.setDuplicate(DUPLICATE);
        for (ZipFileSet zipFileSet : this.zipFileSets) {
            jar.addFileset((FileSet)zipFileSet);
        }
        jar.setProject(this.owningTask.getProject());
        jar.setTaskName(this.owningTask.getTaskName());
        jar.setBasedir(this.baseDir);
        jar.setDestFile(file);
        jar.setExcludes("**/*");
        jar.execute();
        this.owningTask.log("Created JWS deployment outputFile: " + jar.getDestFile());
    }

    private void prepareJar(File file) throws WsBuildException {
        if (file.exists()) {
            this.owningTask.log("Deleting existing module outputFile " + file.getAbsolutePath());
            if (!file.delete()) {
                this.owningTask.log("Unable to delete module outputFile " + file.getAbsolutePath());
            }
        }
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new WsBuildException("Unable to create output directory " + file.getParentFile().getAbsolutePath());
        }
    }

    void write(boolean bl) throws WsBuildException {
        if (bl) {
            this.copy();
        } else {
            this.jar();
        }
        this.zipFileSets.clear();
    }

    String getName() {
        return this.outputFile.getName();
    }

    static {
        DUPLICATE.setValue("preserve");
    }
}

