/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.anttasks;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import weblogic.wsee.WebServiceType;
import weblogic.wsee.tools.anttasks.JwsModule;
import weblogic.wsee.tools.jws.build.Jws;
import weblogic.wsee.tools.jws.decl.WebMethodDecl;
import weblogic.wsee.tools.jws.decl.WebParamDecl;
import weblogic.wsee.tools.jws.decl.WebServiceDecl;
import weblogic.wsee.tools.jws.decl.WebServiceSEIDecl;
import weblogic.wsee.tools.jws.decl.WebTypeDecl;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JwsCompileList {
    private static final String JAVA_PATTERN = "**/*.java";
    private final JwsModule module;
    private final List<File> sourcepaths;

    JwsCompileList(JwsModule jwsModule) {
        assert (jwsModule != null);
        this.module = jwsModule;
        this.sourcepaths = JwsCompileList.getSourcepaths(jwsModule);
    }

    File[] getFiles() throws IOException {
        HashSet<File> hashSet = new HashSet<File>();
        this.addJwsSources(hashSet);
        this.addDependentSources(hashSet);
        this.addGeneratedSources(hashSet);
        this.addFileSetSources(hashSet);
        return hashSet.toArray(new File[hashSet.size()]);
    }

    private void addJwsSources(Set<File> set) {
        for (Jws jws : this.module.getJwsFiles()) {
            File file = jws.getAbsoluteFile();
            set.add(file);
        }
    }

    private void addDependentSources(Set<File> set) {
        for (WebServiceDecl webServiceDecl : this.module.getWebServices()) {
            this.addDependentSources(webServiceDecl, set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDependentSources(WebServiceDecl webServiceDecl, Set<File> set) {
        Path path = this.module.getTask().getCompleteClasspath();
        if (WebServiceType.JAXWS.equals((Object)webServiceDecl.getType()) && webServiceDecl.getCowReader() != null) {
            path.createPathElement().setLocation(webServiceDecl.getCowReader().getCowFile());
        }
        AntClassLoader antClassLoader = new AntClassLoader(this.module.getTask().getProject(), path);
        try {
            Set<String> set2 = JwsCompileList.getDependentClasses(webServiceDecl);
            for (String string : set2) {
                this.log(EventLevel.VERBOSE, "Checking dependent class " + string + ".");
                try {
                    antClassLoader.loadClass(string);
                    this.log(EventLevel.VERBOSE, "Dependent class " + string + " was found in classpath.");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    File file = this.getSourceFile(string);
                    if (file == null) {
                        this.log(EventLevel.INFO, "Dependent class " + string + " was not found in the classpath or sourcpath.");
                        continue;
                    }
                    this.log(EventLevel.VERBOSE, "Dependent class " + string + " was found in sourcepath at " + file.getAbsolutePath() + ".'");
                    set.add(file);
                }
            }
        }
        finally {
            antClassLoader.cleanup();
        }
    }

    private static Set<String> getDependentClasses(WebServiceDecl webServiceDecl) {
        HashSet<String> hashSet = new HashSet<String>();
        JwsCompileList.addEndpointInterface(webServiceDecl, hashSet);
        JwsCompileList.addHandlers(webServiceDecl, hashSet);
        if (webServiceDecl instanceof WebServiceSEIDecl) {
            JwsCompileList.addDeploymentListeners((WebServiceSEIDecl)webServiceDecl, hashSet);
            JwsCompileList.addAlternativeTypes((WebServiceSEIDecl)webServiceDecl, hashSet);
        }
        return hashSet;
    }

    private static void addEndpointInterface(WebServiceDecl webServiceDecl, Set<String> set) {
        if (!webServiceDecl.getJClass().getQualifiedName().equals(webServiceDecl.getEIClass().getQualifiedName())) {
            set.add(webServiceDecl.getEIClass().getQualifiedName());
        }
    }

    private static void addAlternativeTypes(WebServiceSEIDecl webServiceSEIDecl, Set<String> set) {
        Iterator<WebMethodDecl> iterator = webServiceSEIDecl.getWebMethods();
        while (iterator.hasNext()) {
            WebMethodDecl webMethodDecl = iterator.next();
            JwsCompileList.addAlternativeTypes(webMethodDecl.getWebResult(), set);
            Iterator<WebParamDecl> iterator2 = webMethodDecl.getWebParams();
            while (iterator2.hasNext()) {
                WebParamDecl webParamDecl = iterator2.next();
                JwsCompileList.addAlternativeTypes(webParamDecl, set);
            }
        }
    }

    private static void addAlternativeTypes(WebTypeDecl webTypeDecl, Set<String> set) {
        if (webTypeDecl.getTypeClassNames() != null) {
            for (int i = 0; i < webTypeDecl.getTypeClassNames().length; ++i) {
                set.add(webTypeDecl.getTypeClassNames()[i]);
            }
        }
    }

    private static void addDeploymentListeners(WebServiceSEIDecl webServiceSEIDecl, Set<String> set) {
        Iterator<String> iterator = webServiceSEIDecl.getDeploymentListeners();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
    }

    private static void addHandlers(WebServiceDecl webServiceDecl, Set<String> set) {
        for (String string : webServiceDecl.getHandlerChainDecl().getHandlerClassNames()) {
            set.add(string);
        }
    }

    private File getSourceFile(String string) {
        String string2 = StringUtil.getRelativeSourcePath(string);
        for (File file : this.sourcepaths) {
            File file2 = new File(file, string2);
            this.log(EventLevel.VERBOSE, "Checking for dependent class " + string + " at " + file2.getAbsolutePath() + ".");
            try {
                if (!file2.equals(file2.getCanonicalFile()) || !file2.exists()) continue;
                return file2;
            }
            catch (IOException iOException) {
                this.log(EventLevel.WARNING, "Unable to determine canonical file for " + file2 + ": " + iOException.getMessage());
            }
        }
        return null;
    }

    private static List<File> getSourcepaths(JwsModule jwsModule) {
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.add(jwsModule.getOutputDir());
        for (String string : jwsModule.getSourcepath().list()) {
            arrayList.add(new File(string));
        }
        return arrayList;
    }

    private void addGeneratedSources(Set<File> set) throws IOException {
        FileSet fileSet = new FileSet();
        fileSet.setProject(this.module.getTask().getProject());
        fileSet.setDir(this.module.getOutputDir());
        fileSet.setIncludes(JAVA_PATTERN);
        this.addFileSet(fileSet, set);
    }

    private void addFileSetSources(Set<File> set) throws IOException {
        for (FileSet fileSet : this.module.getFileSets()) {
            String[] stringArray;
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.module.getTask().getProject());
            for (String string : stringArray = directoryScanner.getIncludedFiles()) {
                if (!string.endsWith(".java")) continue;
                set.add(new File(fileSet.getDir(this.module.getTask().getProject()), string).getCanonicalFile());
            }
        }
    }

    private void addFileSet(FileSet fileSet, Set<File> set) throws IOException {
        String[] stringArray;
        DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.module.getTask().getProject());
        for (String string : stringArray = directoryScanner.getIncludedFiles()) {
            set.add(new File(fileSet.getDir(this.module.getTask().getProject()), string).getCanonicalFile());
        }
    }

    private void log(EventLevel eventLevel, String string) {
        this.module.getBuildContext().getLogger().log(eventLevel, string);
    }
}

