/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.anttasks;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import weblogic.wsee.WebServiceType;
import weblogic.wsee.tools.jws.build.Jws;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JwsFileSet
extends MatchingTask {
    private Path srcDir;
    private WebServiceType type = WebServiceType.JAXRPC;

    public void setSrcdir(Path path) {
        this.srcDir = path;
    }

    public void setType(String string) {
        this.type = WebServiceType.valueOf(string);
    }

    public Path getSrcdir() {
        return this.srcDir;
    }

    List<Jws> getFiles(File file) {
        ArrayList<Jws> arrayList = new ArrayList<Jws>();
        for (File file2 : this.getSrcDirs(file)) {
            DirectoryScanner directoryScanner = this.getDirectoryScanner(file2);
            for (String string : directoryScanner.getIncludedFiles()) {
                String string2 = string.replace('\\', '/');
                Jws jws = new Jws();
                jws.setFile(string2);
                jws.srcdir(file2);
                jws.setType(this.type.toString());
                arrayList.add(jws);
            }
        }
        return arrayList;
    }

    private List<File> getSrcDirs(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (this.srcDir == null) {
            arrayList.add(file);
        } else {
            for (String string : this.srcDir.list()) {
                File file2 = new File(string);
                if (!file2.exists()) continue;
                arrayList.add(file2);
            }
        }
        return arrayList;
    }
}

