/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.anttasks;

import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JClass;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jws.WebService;
import org.apache.tools.ant.types.Path;
import weblogic.wsee.WebServiceType;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.jws.build.GeneratedCallbackJws;
import weblogic.wsee.tools.jws.build.Jws;
import weblogic.wsee.tools.jws.context.JwsBuildContext;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.util.ClassLoaderUtil;
import weblogic.wsee.util.ClassUtil;
import weblogic.wsee.util.JamUtil;
import weblogic.wsee.util.cow.CowFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JwsLoader {
    private final JwsBuildContext ctx;
    private final File outputDir;
    private final Path sourcepath;
    private final Path classpath;
    private final boolean autoDetectCows;

    JwsLoader(JwsBuildContext jwsBuildContext, File file, Path path, Path path2, boolean bl) {
        assert (jwsBuildContext != null);
        assert (file != null);
        assert (path != null);
        assert (path2 != null);
        this.ctx = jwsBuildContext;
        this.outputDir = file;
        this.sourcepath = path;
        this.classpath = path2;
        this.autoDetectCows = bl;
    }

    void load(Collection<Jws> collection) throws IOException, WsBuildException {
        List<Jws> list;
        this.extractCows(collection);
        this.loadJClasses(collection);
        this.removeNonWebServices(collection);
        if (this.autoDetectCows && !(list = this.autoDectectCOWs(collection)).isEmpty()) {
            this.load(list);
        }
    }

    private void extractCows(Collection<Jws> collection) throws IOException {
        this.ctx.getLogger().log(EventLevel.INFO, "Parsing source files");
        for (Jws jws : collection) {
            this.extractCow(jws);
        }
    }

    private void extractCow(Jws jws) throws IOException {
        if (jws.getCowReader() != null) {
            this.ctx.getLogger().log(EventLevel.VERBOSE, "Using compiledWsdl " + jws.getCowReader());
            boolean bl = WebServiceType.JAXWS.equals((Object)jws.getType());
            File file = this.outputDir;
            if (jws instanceof GeneratedCallbackJws) {
                file = jws.getCowFile().getParentFile();
            }
            new CowFile(jws.getCowFile()).extract(file, this.ctx.getLogger(), bl);
            if (bl) {
                this.classpath.createPathElement().setLocation(jws.getCowFile());
            }
        }
    }

    private void removeNonWebServices(Collection<Jws> collection) {
        Iterator<Jws> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Jws jws = iterator.next();
            if (ClassUtil.isWebService(jws.getJClass())) continue;
            iterator.remove();
        }
    }

    private List<Jws> autoDectectCOWs(Collection<Jws> collection) throws IOException, WsBuildException {
        ArrayList<Jws> arrayList = new ArrayList<Jws>();
        for (Jws jws : collection) {
            File file;
            if (jws.getCowFile() != null || (file = this.findCow(jws)) == null) continue;
            jws.setCompiledWsdl(file);
            this.extractCow(jws);
            arrayList.add(jws);
        }
        return arrayList;
    }

    private File findCow(Jws jws) throws IOException, WsBuildException {
        String string = JwsLoader.getEndpointInterface(jws.getJClass());
        if (string != null) {
            String string2 = string.replace('.', '/') + ".java";
            List<URI> list = ClassLoaderUtil.getSourceURIs(this.ctx.getClassLoader(), string2);
            if (list.size() > 1) {
                throw new WsBuildException("Too many source URIs for " + string2);
            }
            if (list.size() == 1) {
                return new File(list.get(0));
            }
        }
        return null;
    }

    private static String getEndpointInterface(JClass jClass) {
        JAnnotation jAnnotation = jClass.getAnnotation(WebService.class);
        if (jAnnotation != null) {
            return JamUtil.getAnnotationStringValue(jAnnotation, "endpointInterface");
        }
        return null;
    }

    private void loadJClasses(Collection<Jws> collection) throws WsBuildException {
        this.ctx.getLogger().log(EventLevel.INFO, "Parsing source files");
        ArrayList<File> arrayList = new ArrayList<File>(collection.size());
        for (Jws object2 : collection) {
            arrayList.add(object2.getAbsoluteFile());
        }
        JClass[] jClassArray = JamUtil.parseSource(arrayList.toArray(new File[arrayList.size()]), this.sourcepath.toString(), this.classpath.toString(), this.ctx.getSrcEncoding());
        Map<File, JClass> map = JwsLoader.buildClassMap(jClassArray);
        for (Jws jws : collection) {
            File file = jws.getAbsoluteFile();
            if (!map.containsKey(file)) {
                throw new WsBuildException(file + " has no corresponding jclass");
            }
            jws.setJClass(map.remove(file));
        }
    }

    private static Map<File, JClass> buildClassMap(JClass[] jClassArray) throws WsBuildException {
        HashMap<File, JClass> hashMap = new HashMap<File, JClass>();
        for (JClass jClass : jClassArray) {
            if (jClass.getSourcePosition() == null || jClass.getSourcePosition().getSourceURI() == null) {
                throw new WsBuildException("Unable to determine source for " + jClass.getQualifiedName());
            }
            hashMap.put(new File(jClass.getSourcePosition().getSourceURI()), jClass);
        }
        return hashMap;
    }
}

