/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.anttasks;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.ZipFileSet;
import weblogic.wsee.WebServiceType;
import weblogic.wsee.tools.TempDirManager;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.anttasks.AntUtil;
import weblogic.wsee.tools.anttasks.ClientGenFacadeTask;
import weblogic.wsee.tools.anttasks.EarFile;
import weblogic.wsee.tools.anttasks.JarFile;
import weblogic.wsee.tools.anttasks.JwsCompileList;
import weblogic.wsee.tools.anttasks.JwsLoader;
import weblogic.wsee.tools.anttasks.JwscTask;
import weblogic.wsee.tools.anttasks.ModuleFileSets;
import weblogic.wsee.tools.clientgen.callback.CallbackGen81Processor;
import weblogic.wsee.tools.clientgen.callback.CallbackGenProcessor;
import weblogic.wsee.tools.clientgen.jaxws.Options;
import weblogic.wsee.tools.jws.build.Jws;
import weblogic.wsee.tools.jws.build.JwsCompiler;
import weblogic.wsee.tools.jws.context.JwsBuildContext;
import weblogic.wsee.tools.jws.decl.WebServiceDecl;
import weblogic.wsee.tools.jws.decl.WebServiceDeclFactory;
import weblogic.wsee.tools.jws.decl.port.PortDecl;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.tools.xcatalog.CatalogInfo;
import weblogic.wsee.tools.xcatalog.ClientGenXMLs;
import weblogic.wsee.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JwsModule {
    private final JwscTask owningTask;
    private JwsBuildContext ctx;
    private JwsCompiler compiler;
    private String name = null;
    private String defaultContextPath = null;
    private boolean explode = false;
    private List<FileSet> fileSets = new ArrayList<FileSet>();
    List<Jws> callbackJwsFiles;
    private List<ClientGenFacadeTask> clients = new ArrayList<ClientGenFacadeTask>();
    private List<Descriptor> descriptors = new ArrayList<Descriptor>();
    private final TempDirManager tempDirs;
    private ZipFileSet catalogFS = null;

    JwsModule(JwscTask jwscTask, JwsBuildContext jwsBuildContext) {
        assert (jwscTask != null);
        assert (jwsBuildContext != null);
        this.owningTask = jwscTask;
        this.ctx = jwsBuildContext;
        this.compiler = new JwsCompiler(jwsBuildContext, jwscTask);
        this.tempDirs = new TempDirManager(jwscTask.getProject());
    }

    public void addFileSet(FileSet fileSet) {
        assert (fileSet != null);
        fileSet.setProject(this.owningTask.getProject());
        this.fileSets.add(fileSet);
    }

    public void addZipFileSet(ZipFileSet zipFileSet) {
        assert (zipFileSet != null);
        zipFileSet.setProject(this.owningTask.getProject());
        this.fileSets.add((FileSet)zipFileSet);
    }

    List<FileSet> getFileSets() {
        return this.fileSets;
    }

    public void setName(String string) {
        if (StringUtil.isEmpty(string)) {
            throw new IllegalArgumentException("name must not be null or empty.");
        }
        this.name = string;
    }

    String getName() {
        return this.name;
    }

    String getFileName() {
        StringBuilder stringBuilder = new StringBuilder(this.getName());
        if (!this.isExplode()) {
            if (this.isEjb()) {
                stringBuilder.append(".jar");
            } else {
                stringBuilder.append(".war");
            }
        }
        return stringBuilder.toString();
    }

    public void setContextPath(String string) {
        this.defaultContextPath = string;
        this.ctx.getProperties().put("jwsc.contextPathOverride", true);
    }

    public void setExplode(boolean bl) {
        this.explode = bl;
    }

    boolean isExplode() {
        return this.explode || this.isWsdlOnly();
    }

    public void setWsdlOnly(boolean bl) {
        this.compiler.setWsdlOnly(bl);
    }

    boolean isWsdlOnly() {
        return this.compiler.isWsdlOnly();
    }

    public void setGenerateWsdl(boolean bl) {
        this.compiler.setGenerateWsdl(bl);
    }

    boolean isGenerateWsdl() {
        return this.compiler.isGenerateWsdl();
    }

    public void setGenerateDescriptors(boolean bl) {
        this.compiler.setGenerateDescriptors(bl);
    }

    boolean isGenerateDescriptors() {
        return this.compiler.isGenerateDescriptors();
    }

    public ClientGenFacadeTask createClientGen() {
        ClientGenFacadeTask clientGenFacadeTask = new ClientGenFacadeTask();
        clientGenFacadeTask.setProject(this.owningTask.getProject());
        this.clients.add(clientGenFacadeTask);
        return clientGenFacadeTask;
    }

    public Descriptor createDescriptor() {
        Descriptor descriptor = new Descriptor();
        this.descriptors.add(descriptor);
        return descriptor;
    }

    abstract Collection<Jws> getJwsFiles();

    File getOutputDir() {
        return this.compiler.getOutputDir();
    }

    JwscTask getTask() {
        return this.owningTask;
    }

    boolean isEjb() {
        return this.compiler.isEjb();
    }

    List<WebServiceDecl> getWebServices() {
        return this.compiler.getWebServices();
    }

    JwsBuildContext getBuildContext() {
        return this.compiler.getJwsBuildContext();
    }

    Path getSourcepath() {
        Path path = new Path(this.owningTask.getProject());
        path.add(this.owningTask.getSourcepath());
        for (File file : this.tempDirs.getTempDirs()) {
            path.createPathElement().setLocation(file);
        }
        for (FileSet fileSet : this.fileSets) {
            path.createPathElement().setLocation(fileSet.getDir(this.owningTask.getProject()));
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void build(EarFile earFile) throws IOException, WsBuildException {
        this.log(EventLevel.INFO, "JWS: processing module " + this.getName());
        this.validate();
        this.initialize();
        try {
            boolean bl = this.generate(earFile);
            if (bl) {
                this.log(EventLevel.WARNING, "No web services specified.  Module will not be built");
            } else {
                this.compile();
                if (this.catalogFS != null) {
                    if (this.isEjb()) {
                        this.catalogFS.setPrefix("META-INF/");
                    } else {
                        this.catalogFS.setPrefix("WEB-INF/");
                    }
                    this.fileSets.add((FileSet)this.catalogFS);
                }
                this.doPackage(earFile);
            }
        }
        finally {
            this.cleanup();
        }
    }

    private void validate() {
        this.validateFileSets();
        this.validateImpl();
    }

    private void validateFileSets() {
        for (FileSet fileSet : this.fileSets) {
            ZipFileSet zipFileSet;
            if (!(fileSet instanceof ZipFileSet) || StringUtil.isEmpty((zipFileSet = (ZipFileSet)fileSet).getFullpath(this.getTask().getProject()))) continue;
            throw new BuildException("Fullpath not supported on zipFileSet in jwsc");
        }
    }

    abstract void validateImpl();

    private void initialize() throws IOException {
        this.compiler.setOutputDir(this.tempDirs.createTempDir(this.name, this.owningTask.getTempdir()));
        this.compiler.setBindingFiles(this.owningTask.getBindingFiles());
        this.compiler.setJaxRPCWrappedArrayStyle(this.owningTask.isJaxRpcByteArrayStyle());
        this.compiler.setUpperCasePropName(this.owningTask.isUpperCasePropName());
        this.compiler.setLocalElementDefaultRequired(this.owningTask.isLocalElementDefaultRequired());
        this.compiler.setLocalElementDefaultNillable(this.owningTask.isLocalElementDefaultNillable());
        for (Descriptor descriptor : this.descriptors) {
            this.compiler.addDescriptor(descriptor.file);
        }
    }

    private void cleanup() {
        Collection<Jws> collection = this.getJwsFiles();
        if (collection != null) {
            for (Jws object : collection) {
                object.setJClass(null);
            }
        }
        collection = null;
        this.reset();
        if (this.getTask().isKeepTempFiles()) {
            StringBuilder stringBuilder = new StringBuilder("Temporary files for module " + this.getName() + " created in:\n");
            for (File file : this.tempDirs.getTempDirs()) {
                stringBuilder.append("\t" + file + "\n");
            }
            this.log(EventLevel.INFO, stringBuilder.toString());
        } else {
            if (this.callbackJwsFiles != null) {
                for (Jws jws : this.callbackJwsFiles) {
                    if (jws.getCowReader() == null) continue;
                    jws.getCowReader().cleanup();
                }
            }
            this.tempDirs.cleanup();
        }
        this.compiler.cleanup();
        this.compiler = null;
        this.fileSets = null;
        this.clients = null;
        this.descriptors = null;
        this.catalogFS = null;
        this.ctx = null;
    }

    abstract void reset();

    private boolean generate(EarFile earFile) throws IOException, WsBuildException {
        this.callbackJwsFiles = this.generateClients();
        this.loadWebServices(this.getJwsFiles(), this.defaultContextPath);
        if (!this.callbackJwsFiles.isEmpty()) {
            this.loadWebServices(this.callbackJwsFiles, this.getCallbackContextPath());
        }
        if (earFile.isAdded(this.getFileName())) {
            throw new BuildException("Module " + this.getName() + " already exists in this jws compile set.");
        }
        this.compiler.compile();
        return this.compiler.getWebServices().isEmpty();
    }

    private void compile() throws IOException {
        Path path = this.getSourcepath();
        Collection<Jws> collection = this.getJwsFiles();
        for (Jws jws : collection) {
            if (!WebServiceType.JAXWS.equals((Object)jws.getType()) || jws.getCowFile() == null) continue;
            path.createPathElement().setLocation(jws.getCowFile());
        }
        this.owningTask.javac(this.getOutputDir(), new JwsCompileList(this).getFiles(), path);
    }

    private void doPackage(EarFile earFile) throws WsBuildException, IOException {
        if (this.isWsdlOnly()) {
            this.copyWsdl(earFile.getEarDir());
        } else {
            FileSet fileSet = this.owningTask.getResourceFileSet();
            if (fileSet != null) {
                this.addFileSet(fileSet);
            }
            File file = new File(earFile.getEarDir(), this.getFileName());
            JarFile jarFile = new JarFile(this.getTask(), file, this.getOutputDir());
            jarFile.addZipFileSets(new ModuleFileSets(this, this.getTask().isKeepGenerated()).getZipFileSets());
            jarFile.write(this.isExplode());
            this.addToEar(earFile, this.getFileName());
        }
    }

    private void copyWsdl(File file) {
        for (WebServiceDecl webServiceDecl : this.getWebServices()) {
            Object object;
            if (WebServiceType.JAXWS.equals((Object)webServiceDecl.getType())) {
                object = new ZipFileSet();
                object.setDir(this.getOutputDir());
                object.setIncludes("**/policies/*.xml, **/*.wsdl, **/*.xsd");
                object.setPrefix(this.getName());
                this.copy((ZipFileSet)object, file);
                continue;
            }
            object = new File(file, this.getFileName());
            ((File)object).mkdirs();
            File file2 = new File(this.getOutputDir(), webServiceDecl.getWsdlFile());
            AntUtil.copyFile(this.getTask().getProject(), file2, new File((File)object, file2.getName()));
            AntUtil.copyFiles(this.getTask().getProject(), this.getOutputDir(), (File)object, "*.xsd");
        }
    }

    private void copy(ZipFileSet zipFileSet, File file) {
        file.mkdirs();
        Copy copy = new Copy();
        copy.setTaskName(this.owningTask.getTaskName());
        copy.setProject(this.owningTask.getProject());
        copy.addFileset((FileSet)zipFileSet);
        String string = zipFileSet.getPrefix(this.owningTask.getProject());
        String string2 = string == null ? "" : string;
        copy.setTodir(new File(file, string2));
        copy.execute();
    }

    private void addToEar(EarFile earFile, String string) throws IOException {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (this.isEjb()) {
            earFile.addEjbModule(string);
        } else {
            Iterator<PortDecl> iterator = this.getWebServices().get(0).getPorts();
            assert (iterator.hasNext());
            earFile.addWebModule(string, iterator.next().getContextPath());
        }
    }

    private List<Jws> generateClients() throws IOException {
        ArrayList<Jws> arrayList = new ArrayList<Jws>();
        if (!this.clients.isEmpty()) {
            ClientGenFacadeTask clientGenFacadeTask22;
            File file = this.tempDirs.createTempDir(this.name, this.owningTask.getTempdir());
            CatalogInfo catalogInfo = new CatalogInfo(true);
            for (ClientGenFacadeTask clientGenFacadeTask22 : this.clients) {
                List<Jws> list;
                CallbackGenProcessor callbackGenProcessor = new CallbackGenProcessor(this.owningTask.getProject());
                CallbackGen81Processor callbackGen81Processor = new CallbackGen81Processor(this.owningTask.getProject());
                if (WebServiceType.JAXWS.equals((Object)clientGenFacadeTask22.getType())) {
                    clientGenFacadeTask22.initJAXWSOptions();
                    list = clientGenFacadeTask22.jaxwsOptions;
                    ((Options)((Object)list)).setDebug(this.owningTask.getDebug());
                    if (this.owningTask.getDebugLevel() != null) {
                        ((Options)((Object)list)).setDebugLevel(this.owningTask.getDebugLevel());
                    }
                    ((Options)((Object)list)).setVerbose(this.owningTask.getVerbose());
                    ((Options)((Object)list)).setFailonerror(this.owningTask.getFailonerror());
                    ((Options)((Object)list)).setIncludeantruntime(this.owningTask.getIncludeantruntime());
                    ((Options)((Object)list)).setIncludejavaruntime(this.owningTask.getIncludejavaruntime());
                    ((Options)((Object)list)).setOptimize(this.owningTask.getOptimize());
                }
                for (FileSet fileSet : this.owningTask.getBindingFileSets()) {
                    clientGenFacadeTask22.addBinding(fileSet);
                }
                clientGenFacadeTask22.setDestDir(file);
                clientGenFacadeTask22.addProcessor(callbackGenProcessor);
                clientGenFacadeTask22.addProcessor(callbackGen81Processor);
                catalogInfo = ClientGenXMLs.processClient(clientGenFacadeTask22, clientGenFacadeTask22.type, clientGenFacadeTask22.jaxwsOptions, clientGenFacadeTask22.wsdl, catalogInfo);
                clientGenFacadeTask22.execute();
                list = callbackGenProcessor.getCallbackJws();
                if (list.size() == 0) {
                    list = callbackGen81Processor.getCallbackJws();
                }
                for (Jws jws : list) {
                    arrayList.add(jws);
                }
            }
            File file2 = this.tempDirs.createTempDir(this.name, this.owningTask.getTempdir());
            ClientGenXMLs.doAllCatalogFiles(this.owningTask, file2, catalogInfo);
            clientGenFacadeTask22 = new FileSet();
            clientGenFacadeTask22.setProject(this.owningTask.getProject());
            clientGenFacadeTask22.setDir(file);
            this.fileSets.add((FileSet)clientGenFacadeTask22);
            if (catalogInfo != null && catalogInfo.catalogSize() > 0) {
                this.catalogFS = new ZipFileSet();
                this.catalogFS.setProject(this.owningTask.getProject());
                this.catalogFS.setDir(file2);
            }
            this.ctx.getClientGenOutputDirs().add(file);
        }
        return arrayList;
    }

    private String getCallbackContextPath() {
        assert (!this.compiler.isEjb()) : "Callbacks can only be used in webapps";
        assert (!this.compiler.getWebServices().isEmpty()) : "No web services found";
        WebServiceDecl webServiceDecl = this.compiler.getWebServices().get(0);
        Iterator<PortDecl> iterator = webServiceDecl.getPorts();
        assert (iterator.hasNext()) : "No ports for web service " + webServiceDecl.getSourceFile();
        PortDecl portDecl = iterator.next();
        return portDecl.getContextPath();
    }

    private void loadWebServices(Collection<Jws> collection, String string) throws IOException, WsBuildException {
        this.setDefaultSrcDirOnJwses(collection);
        boolean bl = this.owningTask.getClasspath() != null;
        JwsLoader jwsLoader = new JwsLoader(this.getBuildContext(), this.getOutputDir(), this.getSourcepath(), this.owningTask.getCompleteClasspath(), bl);
        jwsLoader.load(collection);
        this.log(EventLevel.INFO, collection.size() + " JWS files being processed for module " + this.getName());
        for (Jws jws : collection) {
            this.compiler.addWebService(this.buildAndValidate(jws, string));
        }
        this.compiler.validate();
        if (this.getBuildContext().isInError()) {
            throw new WsBuildException("Compiler validation failed: " + this.getBuildContext().getErrorMsgs());
        }
    }

    private WebServiceDecl buildAndValidate(Jws jws, String string) throws WsBuildException {
        Object t = new WebServiceDeclFactory(this.getBuildContext(), string).newInstance(jws);
        t.validate();
        if (this.getBuildContext().isInError()) {
            throw new WsBuildException("JWS Validation failed: " + this.getBuildContext().getErrorMsgs());
        }
        this.log(EventLevel.INFO, "JWS: " + jws.getAbsoluteFile() + " Validated.");
        return t;
    }

    private void setDefaultSrcDirOnJwses(Collection<Jws> collection) {
        for (Jws jws : collection) {
            if (jws.hasSrcDir()) continue;
            if (this.getTask().getSrcdir() == null) {
                throw new BuildException("srcdir attribute must be set!", this.owningTask.getLocation());
            }
            jws.srcdir(this.getTask().getSrcdir());
        }
    }

    private void log(EventLevel eventLevel, String string) {
        this.getBuildContext().getLogger().log(eventLevel, string);
    }

    public static class Descriptor {
        private File file = null;

        public void setFile(File file) {
            this.file = file;
        }
    }
}

