/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.anttasks;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import weblogic.wsee.tools.anttasks.AntUtil;
import weblogic.wsee.tools.anttasks.EarFile;
import weblogic.wsee.tools.anttasks.JwsModule;
import weblogic.wsee.tools.anttasks.MatchingJavacTask;
import weblogic.wsee.tools.anttasks.MultipleJwsModule;
import weblogic.wsee.tools.anttasks.SingleJwsModule;
import weblogic.wsee.tools.jws.context.JwsBuildContextImpl;
import weblogic.wsee.tools.logging.AntLogger;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.util.Verbose;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JwscTask
extends MatchingJavacTask {
    private static final boolean verbose = Verbose.isVerbose(JwscTask.class);
    private List<JwsModule> modules = new ArrayList<JwsModule>();
    private JwsBuildContextImpl ctx = new JwsBuildContextImpl();
    private File includeResourcesDir = null;
    private boolean dotNetStyle = true;
    private File srcDir = null;
    private boolean keepTempFiles = false;
    private File applicationXml = null;
    private boolean keepGenerated = false;
    private List<FileSet> bindingFileSets = new ArrayList<FileSet>();
    private File[] bindingFiles;
    private boolean jaxRpcByteArrayStyle;
    private boolean upperCasePropName = true;
    private boolean localElementDefaultRequired = true;
    private boolean localElementDefaultNillable = true;

    public void setKeepTempFiles(boolean bl) {
        this.keepTempFiles = bl;
    }

    boolean isKeepTempFiles() {
        return this.keepTempFiles;
    }

    public void setSrcdir(File file) {
        this.srcDir = file;
    }

    File getSrcdir() {
        return this.srcDir;
    }

    @Deprecated
    public void setEnableAsyncService(boolean bl) {
        this.log("DEPRECATED - Use of enableAsyncService is deprecated.  The AsyncResponseService is now available by default in every domain.");
    }

    public void setKeepGenerated(boolean bl) {
        this.keepGenerated = bl;
    }

    public boolean isKeepGenerated() {
        return this.keepGenerated;
    }

    public void setApplicationXml(File file) {
        this.applicationXml = file;
    }

    public void setDotNetStyle(boolean bl) {
        this.dotNetStyle = bl;
    }

    @Deprecated
    public void setIncludeResourcesDir(File file) {
        this.log("DEPRECATED - Use of includeResourcesDir is deprecated.  Use nested fileset element under the modules instead.");
        this.includeResourcesDir = file;
    }

    public MultipleJwsModule createModule() {
        MultipleJwsModule multipleJwsModule = new MultipleJwsModule(this, this.ctx);
        this.modules.add(multipleJwsModule);
        return multipleJwsModule;
    }

    public SingleJwsModule createJws() {
        SingleJwsModule singleJwsModule = new SingleJwsModule(this, this.ctx);
        this.modules.add(singleJwsModule);
        return singleJwsModule;
    }

    public void setSrcEncoding(String string) {
        this.ctx.setSrcEncoding(string);
        super.setEncoding(string);
    }

    public void setDestEncoding(String string) {
        this.ctx.setDestEncoding(string);
    }

    @Override
    public Path getSourcepath() {
        if (super.getSourcepath() == null) {
            Path path = this.createSourcepath();
            if (this.srcDir != null) {
                path.createPathElement().setLocation(this.srcDir);
            }
        }
        return super.getSourcepath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(JwscTask.class.getClassLoader());
        try {
            try {
                this.checkParameters();
                this.initialize();
                EarFile earFile = new EarFile(this.getDestdir(), this.ctx.getDestEncoding());
                earFile.setApplicationXml(this.applicationXml);
                for (JwsModule jwsModule : this.modules) {
                    jwsModule.build(earFile);
                }
                earFile.write();
            }
            catch (Exception exception) {
                if (this.getFailonerror()) {
                    throw new BuildException((Throwable)exception);
                }
                this.log("JWS Compile failed: " + exception.getMessage());
                Object var6_7 = null;
                Thread.currentThread().setContextClassLoader(classLoader);
                this.cleanup();
            }
            Object var6_6 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            this.cleanup();
            throw throwable;
        }
    }

    @Override
    protected void checkParameters() {
        File file = this.getDestdir();
        if (file == null) {
            throw new BuildException("attribute destDir must be set!");
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        super.checkParameters();
    }

    private void initialize() {
        this.ctx.getProperties().put("jwsc.dotNetStyle", this.dotNetStyle);
        AntLogger antLogger = new AntLogger(this);
        this.ctx.addLogger(antLogger);
        this.ctx.getLogger().log(EventLevel.VERBOSE, "Verbose is on.");
        if (this.getClasspath() != null) {
            this.ctx.setClasspath(this.getClasspath().list());
        }
        this.ctx.setSourcepath(this.getSourcepath().list());
        if (this.includeResourcesDir != null) {
            this.createClasspath().setPath(this.includeResourcesDir.getAbsolutePath());
        }
        this.getSourcepath();
    }

    private void cleanup() {
        this.modules.clear();
        this.modules = null;
        this.ctx = null;
        this.includeResourcesDir = null;
        this.dotNetStyle = true;
        this.keepGenerated = false;
        this.bindingFileSets = null;
        this.bindingFiles = null;
    }

    Path getCompleteClasspath() {
        Path path = new Path(this.getProject());
        Path path2 = this.getClasspath();
        if (path2 == null) {
            path2 = new Path(this.getProject());
        }
        if (this.getIncludeantruntime()) {
            path.addExisting(path2.concatSystemClasspath("last"));
        } else {
            path.addExisting(path2.concatSystemClasspath("ignore"));
        }
        if (this.getIncludejavaruntime()) {
            path.addJavaRuntime();
        }
        return path;
    }

    void javac(File file, File[] fileArray, Path path) throws IOException {
        File file2 = this.getDestdir();
        this.setDestdir(file);
        this.compile(fileArray, path);
        this.setDestdir(file2);
    }

    FileSet getResourceFileSet() {
        if (this.includeResourcesDir != null) {
            ExposingFileSet exposingFileSet = new ExposingFileSet(this.getImplicitFileSet());
            exposingFileSet.setDir(this.includeResourcesDir);
            return exposingFileSet;
        }
        return null;
    }

    @Deprecated
    public void addXsdConfig(FileSet fileSet) {
        this.log("xsdConfig is deprecated.  Use binding instead.", 1);
        this.addBinding(fileSet);
    }

    public void addBinding(FileSet fileSet) {
        this.bindingFileSets.add(fileSet);
    }

    File[] getBindingFiles() {
        if (this.bindingFileSets.isEmpty()) {
            return null;
        }
        if (this.bindingFiles == null) {
            this.bindingFiles = AntUtil.getFiles(this.bindingFileSets, this.getProject());
        }
        if (this.bindingFiles == null || this.bindingFiles.length == 0) {
            this.log("Warning: Not found binding files defined in binding sub-element, some binding configuration might not take effect!");
        }
        return this.bindingFiles;
    }

    List<FileSet> getBindingFileSets() {
        return this.bindingFileSets;
    }

    public void setJaxRpcByteArrayStyle(boolean bl) {
        this.jaxRpcByteArrayStyle = bl;
    }

    public boolean isJaxRpcByteArrayStyle() {
        return this.jaxRpcByteArrayStyle;
    }

    public void setUpperCasePropName(boolean bl) {
        this.upperCasePropName = bl;
    }

    public boolean isUpperCasePropName() {
        return this.upperCasePropName;
    }

    public void setLocalElementDefaultRequired(boolean bl) {
        this.localElementDefaultRequired = bl;
    }

    public boolean isLocalElementDefaultRequired() {
        return this.localElementDefaultRequired;
    }

    public void setLocalElementDefaultNillable(boolean bl) {
        this.localElementDefaultNillable = bl;
    }

    public boolean isLocalElementDefaultNillable() {
        return this.localElementDefaultNillable;
    }

    private static class ExposingFileSet
    extends FileSet {
        ExposingFileSet(FileSet fileSet) {
            super(fileSet);
        }
    }
}

