/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.anttasks;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.ZipFileSet;
import weblogic.wsee.tools.anttasks.JwsModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ModuleFileSets {
    private final JwsModule module;
    private final boolean keepGenerated;

    public ModuleFileSets(JwsModule jwsModule, boolean bl) {
        assert (jwsModule != null);
        this.module = jwsModule;
        this.keepGenerated = bl;
    }

    private ZipFileSet buildZipSet(String string) {
        ZipFileSet zipFileSet = new ZipFileSet();
        zipFileSet.setDir(this.module.getOutputDir());
        PatternSet.NameEntry nameEntry = zipFileSet.createInclude();
        nameEntry.setName(string);
        return zipFileSet;
    }

    private ZipFileSet buildClassesSet() {
        ZipFileSet zipFileSet = new ZipFileSet();
        zipFileSet.setDir(this.module.getOutputDir());
        PatternSet.NameEntry nameEntry = zipFileSet.createInclude();
        nameEntry.setName("**/*.class");
        nameEntry = zipFileSet.createInclude();
        nameEntry.setName("**/*_handler.xml");
        nameEntry = zipFileSet.createInclude();
        nameEntry.setName("**/callbackclient/*.*");
        nameEntry = zipFileSet.createExclude();
        nameEntry.setName("schemacom_bea_xml/**/*.class");
        return zipFileSet;
    }

    private ZipFileSet buildArtifactSet() {
        ZipFileSet zipFileSet = new ZipFileSet();
        zipFileSet.setDir(this.module.getOutputDir());
        zipFileSet.setIncludes("*.xml, **/policies/*.xml, **/*.wsdl, **/*.xsd");
        zipFileSet.setExcludes("web.xml");
        if (this.keepGenerated) {
            zipFileSet.setIncludes("schemacom_bea_xml/**, META-INF/**");
        }
        return zipFileSet;
    }

    List<ZipFileSet> getZipFileSets() {
        ArrayList<ZipFileSet> arrayList = new ArrayList<ZipFileSet>();
        ZipFileSet zipFileSet = this.buildArtifactSet();
        ZipFileSet zipFileSet2 = this.buildClassesSet();
        if (this.module.isEjb()) {
            arrayList.add(zipFileSet2);
            for (FileSet fileSet : this.module.getFileSets()) {
                if (fileSet instanceof ZipFileSet) {
                    arrayList.add((ZipFileSet)fileSet);
                    continue;
                }
                arrayList.add(new ExposingZipFileSet(fileSet));
            }
            zipFileSet.setPrefix("META-INF/");
            arrayList.add(zipFileSet);
        } else {
            ZipFileSet zipFileSet3 = new ZipFileSet();
            zipFileSet3.setFile(new File(this.module.getOutputDir(), "web.xml"));
            zipFileSet3.setPrefix("WEB-INF/");
            arrayList.add(zipFileSet3);
            zipFileSet.setPrefix("WEB-INF/");
            arrayList.add(zipFileSet);
            zipFileSet2.setPrefix("WEB-INF/classes");
            arrayList.add(zipFileSet2);
            for (FileSet fileSet : this.module.getFileSets()) {
                if (fileSet instanceof ZipFileSet) {
                    arrayList.add((ZipFileSet)fileSet);
                    continue;
                }
                ExposingZipFileSet exposingZipFileSet = new ExposingZipFileSet(fileSet);
                exposingZipFileSet.setPrefix("WEB-INF/classes");
                arrayList.add(exposingZipFileSet);
            }
        }
        if (this.keepGenerated) {
            arrayList.add(this.buildZipSet("**/*.java"));
        }
        return arrayList;
    }

    private static class ExposingZipFileSet
    extends ZipFileSet {
        ExposingZipFileSet(FileSet fileSet) {
            super(fileSet);
        }
    }
}

