/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.anttasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.tools.ant.types.Path;
import weblogic.wsee.tools.anttasks.JwsFileSet;
import weblogic.wsee.tools.anttasks.JwsModule;
import weblogic.wsee.tools.anttasks.JwscTask;
import weblogic.wsee.tools.jws.build.Jws;
import weblogic.wsee.tools.jws.context.JwsBuildContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleJwsModule
extends JwsModule {
    private List<Jws> jwses = new ArrayList<Jws>();
    private List<JwsFileSet> jwsFileSets = new ArrayList<JwsFileSet>();
    private List<Jws> allJwses = null;

    MultipleJwsModule(JwscTask jwscTask, JwsBuildContext jwsBuildContext) {
        super(jwscTask, jwsBuildContext);
        this.setName("jws");
    }

    public Jws createJws() {
        Jws jws = new Jws();
        this.jwses.add(jws);
        return jws;
    }

    public JwsFileSet createJwsFileSet() {
        JwsFileSet jwsFileSet = new JwsFileSet();
        jwsFileSet.setProject(this.getTask().getProject());
        this.jwsFileSets.add(jwsFileSet);
        return jwsFileSet;
    }

    @Override
    Collection<Jws> getJwsFiles() {
        if (this.allJwses == null) {
            this.allJwses = new ArrayList<Jws>(this.jwses);
            for (JwsFileSet jwsFileSet : this.jwsFileSets) {
                this.allJwses.addAll(jwsFileSet.getFiles(this.getTask().getSrcdir()));
            }
        }
        return this.allJwses;
    }

    @Override
    Path getSourcepath() {
        Path path = super.getSourcepath();
        for (JwsFileSet jwsFileSet : this.jwsFileSets) {
            path.add(jwsFileSet.getSrcdir());
        }
        return path;
    }

    @Override
    void reset() {
        if (this.allJwses != null) {
            this.allJwses.clear();
            this.allJwses = null;
        }
        this.jwses.clear();
        this.jwses = null;
        this.jwsFileSets.clear();
        this.jwsFileSets = null;
    }

    @Override
    void validateImpl() {
    }
}

