/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.anttasks;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Path;
import weblogic.wsee.tools.ToolsUtil;
import weblogic.wsee.tools.anttasks.JwsModule;
import weblogic.wsee.tools.anttasks.JwscTask;
import weblogic.wsee.tools.jws.build.Jws;
import weblogic.wsee.tools.jws.context.JwsBuildContext;
import weblogic.wsee.tools.jws.decl.port.HttpPort;
import weblogic.wsee.tools.jws.decl.port.HttpsPort;
import weblogic.wsee.tools.jws.decl.port.JmsPort;
import weblogic.wsee.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleJwsModule
extends JwsModule {
    private static final boolean FLATTEN_DEFAULT_FILENAME = false;
    private Jws jws = new Jws();

    SingleJwsModule(JwscTask jwscTask, JwsBuildContext jwsBuildContext) {
        super(jwscTask, jwsBuildContext);
    }

    public HttpsPort createWLHttpsTransport() {
        HttpsPort httpsPort = this.jws.createWLHttpsTransport();
        httpsPort.setBuildContext(super.getBuildContext());
        return httpsPort;
    }

    public HttpPort createWLHttpTransport() {
        HttpPort httpPort = this.jws.createWLHttpTransport();
        httpPort.setBuildContext(super.getBuildContext());
        return httpPort;
    }

    public JmsPort createWLJmsTransport() {
        JmsPort jmsPort = this.jws.createWLJmsTransport();
        jmsPort.setBuildContext(super.getBuildContext());
        return jmsPort;
    }

    public void setCompiledWsdl(File file) {
        this.jws.setCompiledWsdl(file);
    }

    public void setFile(String string) {
        this.jws.setFile(string);
        this.initializeName();
    }

    public void setType(String string) {
        this.jws.setType(string);
    }

    private void initializeName() {
        String string = this.getName();
        if (StringUtil.isEmpty(string)) {
            string = this.jws.getFile().substring(0, this.jws.getFile().lastIndexOf(46));
            this.setName(ToolsUtil.normalize(string));
        }
    }

    @Deprecated
    public void setIncludeSchemas(Path path) {
        this.getTask().getProject().log("DEPRECATED - Use of includeSchemas is deprecated.  These will be ignored.", 1);
    }

    @Override
    Collection<Jws> getJwsFiles() {
        return Collections.singleton(this.jws);
    }

    @Override
    void reset() {
        this.jws = new Jws();
    }

    @Override
    void validateImpl() {
        if (StringUtil.isEmpty(this.jws.getFile())) {
            throw new BuildException("No file specified in jws");
        }
    }
}

