/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.anttasks;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.XMLCatalog;
import weblogic.wsee.tools.xcatalog.CatalogOptions;
import weblogic.wsee.tools.xcatalog.DownloadXMLs;
import weblogic.wsee.util.Verbose;

public class WsdlGetTask
extends Task {
    private static final boolean verbose = Verbose.isVerbose(WsdlGetTask.class);
    private String wsdl;
    private File catalog;
    private XMLCatalog xmlCatalog;
    private File destDir;

    public void execute() throws BuildException {
        this.validate();
        DownloadXMLs downloadXMLs = new DownloadXMLs();
        CatalogOptions catalogOptions = new CatalogOptions();
        catalogOptions.setCatalog(this.catalog);
        catalogOptions.setXmlCatalog(this.xmlCatalog);
        try {
            downloadXMLs.parseXMLs(catalogOptions, this.destDir, this.wsdl, true);
        }
        catch (BuildException buildException) {
            if (verbose) {
                Verbose.say("Build Error StackTrace:");
                buildException.printStackTrace();
            }
            this.log("WsdlGet failed : " + buildException.getMessage(), 0);
            throw buildException;
        }
    }

    private void validate() throws BuildException {
        if (this.wsdl == null) {
            throw new BuildException("Option wsdl must be defined to a wsdl file");
        }
        if (this.destDir == null) {
            throw new BuildException("option destDir [Destination directory] must be defined");
        }
    }

    public void setDestDir(File file) {
        this.destDir = file;
    }

    public void setWsdl(String string) {
        this.wsdl = string;
    }

    public void setCatalog(File file) {
        this.catalog = file;
    }

    public void addConfiguredXmlCatalog(XMLCatalog xMLCatalog) {
        xMLCatalog.setProject(this.getProject());
        this.xmlCatalog = xMLCatalog;
    }
}

