/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.anttasks;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import javax.xml.namespace.QName;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.XMLCatalog;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.apache.tools.ant.types.selectors.FilenameSelector;
import org.apache.tools.ant.types.selectors.OrSelector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import weblogic.wsee.WebServiceType;
import weblogic.wsee.bind.TypeFamily;
import weblogic.wsee.tools.TempDirManager;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.anttasks.AntUtil;
import weblogic.wsee.tools.anttasks.DelegatingJavacTask;
import weblogic.wsee.tools.logging.AntLogger;
import weblogic.wsee.tools.wsdlc.Wsdl2JwsBuilder;
import weblogic.wsee.tools.wsdlc.Wsdl2JwsBuilderFactory;
import weblogic.wsee.tools.wsdlc.WsdlcUtils;
import weblogic.wsee.tools.wsdlc.jaxrpc.Options;
import weblogic.wsee.tools.xcatalog.CatalogOptions;
import weblogic.wsee.tools.xcatalog.DownloadXMLs;
import weblogic.wsee.tools.xcatalog.XCatalogUtil;
import weblogic.wsee.util.JAXWSClassLoaderFactory;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.util.cow.CowWriter;
import weblogic.wsee.util.jspgen.Main;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlcTask
extends DelegatingJavacTask {
    private static final boolean verbose = Verbose.isVerbose(WsdlcTask.class);
    private static final String NS_JAXWS_BINDINGS = "http://java.sun.com/xml/ns/jaxws";
    private static final String NS_JAXB_BINDINGS = "http://java.sun.com/xml/ns/jaxb";
    private static final String JAXWS_BINDINGS_LOCAL = "bindings";
    private static final String JAXWS_ATTR_WSDL_LOCATION = "wsdlLocation";
    private static final String JAXWS_ATTR_SCHEMA_LOCATION = "schemaLocation";
    private File catalogDir = null;
    private String srcWsdl;
    private QName portName;
    private String packageName;
    private File destJwsDir;
    private File destImplDir;
    private File destJavadocDir;
    private AntLogger logger;
    private WsdlDefinitions definitions;
    private List<FileSet> fileSets = new ArrayList<FileSet>();
    private boolean explode = false;
    private List<FileSet> bindingFileSets = new ArrayList<FileSet>();
    private WebServiceType type = WebServiceType.JAXRPC;
    private String implTemplate = null;
    private String implTemplateClassName = null;
    private Options jaxrpcOptions = null;
    private weblogic.wsee.tools.wsdlc.jaxws.Options jaxwsOptions = null;
    private CatalogOptions catalogOptions = null;

    public void setType(String string) {
        this.type = WebServiceType.valueOf(string);
    }

    private void initCatalogOptions() {
        if (this.catalogOptions == null) {
            this.catalogOptions = new CatalogOptions();
        }
    }

    private void initJAXRPCOptions() {
        if (this.jaxrpcOptions == null) {
            this.jaxrpcOptions = new Options();
        }
    }

    private void initJAXWSOptions() {
        if (this.jaxwsOptions == null) {
            this.jaxwsOptions = new weblogic.wsee.tools.wsdlc.jaxws.Options();
        }
    }

    public void setCatalog(File file) {
        this.initCatalogOptions();
        this.catalogOptions.setCatalog(file);
    }

    public void addConfiguredDepends(FileSet fileSet) {
        this.initJAXWSOptions();
        this.jaxwsOptions.addConfiguredDepends(fileSet);
    }

    public void addConfiguredProduces(FileSet fileSet) {
        this.initJAXWSOptions();
        this.jaxwsOptions.addConfiguredProduces(fileSet);
    }

    public void setWlw81CallbackGen(boolean bl) {
        this.initJAXRPCOptions();
        this.jaxrpcOptions.setWlw81CallbackGen(bl);
    }

    public void setUpgraded81Jws(boolean bl) {
        this.initJAXRPCOptions();
        this.jaxrpcOptions.setUpgraded81Jws(bl);
    }

    public void setExplode(boolean bl) {
        this.explode = bl;
    }

    public void addFileSet(FileSet fileSet) {
        assert (fileSet != null);
        fileSet.setProject(this.getProject());
        this.fileSets.add(fileSet);
    }

    public void setSrcWsdl(String string) {
        File file = this.getProject().resolveFile(string);
        if (file.exists()) {
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.srcWsdl = file.toURI().toString();
        } else {
            this.srcWsdl = string;
        }
    }

    @Deprecated
    public void setSrcBindingName(String string) {
        this.log("DEPRECATED - Use of srcBindingName is deprecated.  Use srcPortName instead.");
        this.initJAXRPCOptions();
        this.jaxrpcOptions.setBindingName(QName.valueOf(string));
    }

    public void setSrcPortName(String string) {
        this.portName = QName.valueOf(string);
    }

    public void setSrcServiceName(String string) {
        this.initJAXRPCOptions();
        this.jaxrpcOptions.setServiceName(QName.valueOf(string));
        this.initJAXWSOptions();
        this.jaxwsOptions.setServiceName(QName.valueOf(string));
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    public void setTypeFamily(String string) {
        this.initJAXRPCOptions();
        this.jaxrpcOptions.setTypeFamily(TypeFamily.getTypeFamilyForKey(string));
    }

    public void setTypeFamily(TypeFamily typeFamily) {
        this.initJAXRPCOptions();
        this.jaxrpcOptions.setTypeFamily(typeFamily);
    }

    public void setDestJwsDir(File file) {
        this.destJwsDir = file;
    }

    public void setDestImplDir(File file) {
        this.destImplDir = file;
    }

    public void setImplTemplate(String string) {
        this.implTemplate = string;
    }

    public void setDestJavadocDir(File file) {
        this.destJavadocDir = file;
    }

    public void setAutoDetectWrapped(boolean bl) {
        this.initJAXRPCOptions();
        this.jaxrpcOptions.setAutoDetectWrapped(bl);
    }

    public void setJaxRPCWrappedArrayStyle(boolean bl) {
        this.initJAXRPCOptions();
        this.jaxrpcOptions.setJaxRPCWrappedArrayStyle(bl);
    }

    public void setIncludeGlobalTypes(boolean bl) {
        this.initJAXRPCOptions();
        this.jaxrpcOptions.setIncludeGlobalTypes(bl);
    }

    public void setSortSchemaTypes(boolean bl) {
        this.initJAXRPCOptions();
        this.jaxrpcOptions.setSortSchemaTypes(bl);
    }

    public void setFillIncompleteParameterOrderList(boolean bl) {
        this.initJAXRPCOptions();
        this.jaxrpcOptions.setFillIncompleteParameterOrderList(bl);
    }

    public void setCodeGenBaseData(Object object) {
        this.initJAXRPCOptions();
        this.jaxrpcOptions.setCodeGenBaseData(object);
    }

    public void setImplTemplateClassName(String string) {
        this.implTemplateClassName = string;
    }

    private void preProcessXCatalog() throws BuildException {
        DownloadXMLs downloadXMLs = new DownloadXMLs();
        String string = null;
        TempDirManager tempDirManager = new TempDirManager(this.getProject());
        try {
            this.catalogDir = tempDirManager.createTempDir("xcatalog", this.getTempdir());
        }
        catch (IOException iOException) {
            throw new BuildException("Can not create temporary directory for xcatalog");
        }
        this.initCatalogOptions();
        string = downloadXMLs.parseXMLs(this.catalogOptions, this.catalogDir, this.srcWsdl, true);
        if (this.bindingFileSets != null) {
            ListIterator<FileSet> listIterator = this.bindingFileSets.listIterator();
            while (listIterator.hasNext()) {
                FileSet fileSet = listIterator.next();
                DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
                String[] stringArray = directoryScanner.getIncludedFiles();
                File file = directoryScanner.getBasedir();
                if (stringArray == null) continue;
                FileSet fileSet2 = new FileSet();
                fileSet2.setProject(this.getProject());
                fileSet2.setDir(this.catalogDir);
                OrSelector orSelector = null;
                for (String string2 : stringArray) {
                    File file2 = new File(file, string2);
                    File file3 = new File(this.catalogDir, string2);
                    this.copyFile(this.getProject(), file2, file3, this.catalogOptions.getXmlMaps());
                    FilenameSelector filenameSelector = new FilenameSelector();
                    filenameSelector.setProject(this.getProject());
                    filenameSelector.setName(string2);
                    if (orSelector == null) {
                        orSelector = new OrSelector();
                        fileSet2.add((FileSelector)orSelector);
                    }
                    orSelector.add((FileSelector)filenameSelector);
                }
                listIterator.set(fileSet2);
            }
        }
        this.setSrcWsdl(string);
        System.out.println("srcWsdl is redefined as [ " + string + " ]");
    }

    private void addNodes(List<Element> list, NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            list.add((Element)node);
        }
    }

    private boolean replaceAttr(Element element, String string, String string2, HashMap<URL, String> hashMap) throws MalformedURLException, IOException {
        String string3 = null;
        URL uRL = null;
        string3 = element.getAttribute(string);
        if (string3 == null) {
            return false;
        }
        uRL = string3.startsWith("./") || string3.startsWith("../") ? new File(string2, string3).getCanonicalFile().toURI().toURL() : XCatalogUtil.toURL(string3);
        if ((string3 = hashMap.get(uRL)) == null) {
            return false;
        }
        element.setAttribute(string, string3);
        return true;
    }

    private void copyFile(Project project, File file, File file2, HashMap<URL, String> hashMap) {
        block10: {
            if (hashMap == null || hashMap.size() == 0) {
                AntUtil.copyFile(project, file, file2);
            } else {
                try {
                    boolean bl = false;
                    InputSource inputSource = new InputSource(file.getPath());
                    String string = file.getParent();
                    String string2 = inputSource.getEncoding();
                    Document document = XCatalogUtil.getDocument(inputSource);
                    ArrayList<Element> arrayList = new ArrayList<Element>();
                    NodeList nodeList = document.getElementsByTagNameNS(NS_JAXWS_BINDINGS, JAXWS_BINDINGS_LOCAL);
                    this.addNodes(arrayList, nodeList);
                    nodeList = document.getElementsByTagNameNS(NS_JAXB_BINDINGS, JAXWS_BINDINGS_LOCAL);
                    this.addNodes(arrayList, nodeList);
                    if (arrayList.size() > 0) {
                        for (Element element : arrayList) {
                            if (this.replaceAttr(element, JAXWS_ATTR_WSDL_LOCATION, string, hashMap) || this.replaceAttr(element, JAXWS_ATTR_SCHEMA_LOCATION, string, hashMap)) {
                                // empty if block
                            }
                            bl = true;
                        }
                    }
                    if (bl) {
                        XCatalogUtil.writeDoc2File(document, file2, string2);
                        if (verbose) {
                            Verbose.log("Copy file [" + file.getPath() + "] \ninto [" + file2.getPath() + "]");
                        }
                        break block10;
                    }
                    throw new NoWsdlLocationFoundException();
                }
                catch (Exception exception) {
                    if (exception instanceof NoWsdlLocationFoundException) {
                        AntUtil.copyFile(project, file, file2);
                    }
                    throw new BuildException("Process binding file failed", (Throwable)exception);
                }
            }
        }
    }

    private void postProcessXCatalog() throws BuildException {
        if (this.catalogDir != null) {
            AntUtil.deleteDir(this.getProject(), this.catalogDir);
        }
    }

    public void execute() throws BuildException {
        this.validate();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader2 = WsdlcTask.class.getClassLoader();
        if (WebServiceType.JAXWS.equals((Object)this.type)) {
            JAXWSClassLoaderFactory.getInstance().setContextLoader(classLoader2);
        } else {
            Thread.currentThread().setContextClassLoader(classLoader2);
        }
        try {
            this.preProcessXCatalog();
            this.initialize();
            CowWriter cowWriter = CowWriter.Factory.newInstance(WsdlcUtils.getWsdlFileName(this.definitions, this.srcWsdl), this.destJwsDir, this.explode);
            this.generateJws(cowWriter);
            this.generateJavadoc(cowWriter.getGeneratedDir());
            this.compileXmlBeansArtifacts(cowWriter.getGeneratedDir());
            this.buildCow(cowWriter);
        }
        catch (BuildException buildException) {
            throw buildException;
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
            this.postProcessXCatalog();
        }
    }

    private void buildCow(CowWriter cowWriter) throws IOException, WsdlException {
        cowWriter.writeWsdl(this.definitions);
        cowWriter.writeFiles(this.fileSets);
        cowWriter.writeCow();
    }

    private void generateJws(CowWriter cowWriter) throws WsBuildException {
        Wsdl2JwsBuilder wsdl2JwsBuilder = Wsdl2JwsBuilderFactory.newInstance(this.type);
        wsdl2JwsBuilder.setLogger(this.logger);
        wsdl2JwsBuilder.setWsdl(this.srcWsdl);
        wsdl2JwsBuilder.setWsdlLocation(cowWriter.getOutputWsdl());
        wsdl2JwsBuilder.setPortName(this.portName);
        wsdl2JwsBuilder.setDestDir(cowWriter.getGeneratedDir());
        wsdl2JwsBuilder.setPackageName(this.packageName);
        wsdl2JwsBuilder.setDestImplDir(this.destImplDir);
        if (this.getClasspath() != null) {
            wsdl2JwsBuilder.setClasspath(this.getClasspath().list());
        }
        wsdl2JwsBuilder.setBindingFiles(AntUtil.getFiles(this.bindingFileSets, this.getProject()));
        if (this.type == WebServiceType.JAXRPC) {
            this.initJAXRPCOptions();
            if (this.implTemplateClassName != null) {
                this.jaxrpcOptions.setImplTemplate(this.implTemplateClassName);
            }
            this.jaxrpcOptions.setDefinitions(this.definitions);
            wsdl2JwsBuilder.setOptions(this.jaxrpcOptions);
        } else if (this.type == WebServiceType.JAXWS) {
            this.initJAXWSOptions();
            this.jaxwsOptions.setDebug(this.getDebug());
            this.jaxwsOptions.setDebugLevel(this.getDebugLevel());
            this.jaxwsOptions.setVerbose(this.getVerbose());
            this.jaxwsOptions.setOptimize(this.getOptimize());
            this.jaxwsOptions.setIncludeantruntime(this.getIncludeantruntime());
            this.jaxwsOptions.setIncludejavaruntime(this.getIncludejavaruntime());
            this.jaxwsOptions.setFork(this.getFork());
            wsdl2JwsBuilder.setOptions(this.jaxwsOptions);
        }
        wsdl2JwsBuilder.execute();
    }

    private void validate() throws BuildException {
        if (this.type == WebServiceType.JAXWS && this.jaxrpcOptions != null) {
            this.log("Ignoring JAX-RPC options - building a JAX-WS web service", 1);
        }
        if (this.type == WebServiceType.JAXRPC && this.jaxwsOptions != null) {
            this.log("Ignoring JAX-WS options - building a JAX-RPC web service", 1);
        }
    }

    private void initialize() {
        this.logger = new AntLogger(this);
        this.initWsdl();
        this.initJavac();
        this.initImplTemplate();
    }

    private void initImplTemplate() {
        if (this.implTemplateClassName == null) {
            this.implTemplateClassName = this.buildImplTemplate();
        }
    }

    private void initWsdl() {
        try {
            this.definitions = WsdlFactory.getInstance().parse(this.srcWsdl);
        }
        catch (WsdlException wsdlException) {
            throw new BuildException((Throwable)wsdlException);
        }
    }

    private void initJavac() {
        this.setDestdir(this.destImplDir);
    }

    private String buildImplTemplate() {
        if (this.implTemplate == null) {
            return null;
        }
        try {
            WsdlcUtils.logVerbose(this.logger, "Parsing Jws impl template from ", this.implTemplate);
            Main main = new Main(this.implTemplate, this.destImplDir.toString(), true);
            File[] fileArray = new File[]{new File(main.getJavaFileName())};
            WsdlcUtils.logVerbose(this.logger, "Compiling Jws impl java source ", main.getJavaFileName());
            if (this.destImplDir == null) {
                this.compile(fileArray);
            } else {
                this.compile(fileArray, new Path(this.getProject(), this.destImplDir.getAbsolutePath()));
            }
            return main.getFullyQualifiedClassName();
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            return null;
        }
    }

    private void generateJavadoc(File file) {
        if (this.destJavadocDir != null) {
            Project project = this.getProject();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(WsdlcTask.buildJavadocSourceFiles(project, file));
            if (this.destImplDir != null) {
                stringBuilder.append(WsdlcTask.buildJavadocSourceFiles(project, this.destImplDir));
            }
            AntUtil.javadocFiles(project, stringBuilder.toString(), this.destJavadocDir);
        }
    }

    private static String buildJavadocSourceFiles(Project project, File file) {
        FileSet fileSet = new FileSet();
        fileSet.setDir(file);
        fileSet.setIncludes("**/*.java");
        DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(project);
        String[] stringArray = directoryScanner.getIncludedFiles();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(new File(file, string).getAbsolutePath() + ",");
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public void addXsdConfig(FileSet fileSet) {
        this.log("xsdConfig is deprecated.  Use binding instead.", 1);
        this.addBinding(fileSet);
    }

    public void addBinding(FileSet fileSet) {
        this.bindingFileSets.add(fileSet);
    }

    public void addConfiguredXmlCatalog(XMLCatalog xMLCatalog) {
        this.initCatalogOptions();
        xMLCatalog.setProject(this.getProject());
        this.catalogOptions.setXmlCatalog(xMLCatalog);
    }

    public void setAllowWrappedArrayForDocLiteral(boolean bl) {
        this.initJAXRPCOptions();
        this.jaxrpcOptions.setAllowWrappedArrayForDocLiteral(bl);
    }

    private void compileXmlBeansArtifacts(File file) {
        if (this.type == WebServiceType.JAXRPC && this.jaxrpcOptions != null && (this.jaxrpcOptions.getTypeFamily() == TypeFamily.XMLBEANS_APACHE || this.jaxrpcOptions.getTypeFamily() == TypeFamily.XMLBEANS)) {
            try {
                this.setDestdir(file);
                FileSet fileSet = new FileSet();
                fileSet.setProject(this.getProject());
                fileSet.setDir(file);
                fileSet.setIncludes("**/*.java");
                String[] stringArray = fileSet.getDirectoryScanner(this.getProject()).getIncludedFiles();
                ArrayList<File> arrayList = new ArrayList<File>();
                for (String string : stringArray) {
                    arrayList.add(new File(file, string).getCanonicalFile());
                }
                this.compile(arrayList.toArray(new File[arrayList.size()]));
            }
            catch (IOException iOException) {
                throw new BuildException((Throwable)iOException);
            }
            finally {
                this.setDestdir(this.destImplDir);
            }
        }
    }

    private class NoWsdlLocationFoundException
    extends RuntimeException {
    }
}

