/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.clientgen;

import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JAnnotationValue;
import com.bea.util.jam.JClass;
import com.bea.util.jam.JMethod;
import com.bea.xml.XmlException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jws.WebMethod;
import javax.xml.namespace.QName;
import weblogic.wsee.bind.TypeFamily;
import weblogic.wsee.bind.buildtime.BuildtimeBindings;
import weblogic.wsee.bind.buildtime.S2JBindingsBuilder;
import weblogic.wsee.bind.buildtime.TylarS2JBindingsBuilder;
import weblogic.wsee.callback.CallbackUtils;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.clientgen.ProcessInfo;
import weblogic.wsee.tools.source.EndpointBuilder;
import weblogic.wsee.tools.source.JsClass;
import weblogic.wsee.tools.source.JsMethod;
import weblogic.wsee.tools.source.JsService;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlFactory;
import weblogic.wsee.wsdl.WsdlPartnerLinkType;
import weblogic.wsee.wsdl.WsdlPortType;
import weblogic.wsee.wsdl.WsdlService;
import weblogic.wsee.wsdl.builder.WsdlDefinitionsBuilder;
import weblogic.wsee.wsdl.builder.WsdlServiceBuilder;

public class ClientGenUtil {
    public static void setupService(String string, String string2, ProcessInfo processInfo, boolean bl) throws WsBuildException {
        ClientGenUtil.setupService(string, string2, processInfo, bl, false, false, false);
    }

    public static void setupService(String string, String string2, ProcessInfo processInfo, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws WsBuildException {
        ClientGenUtil.setupService(string, string2, processInfo, bl, bl2, null, bl3, bl4, false);
    }

    public static void setupService(String string, String string2, ProcessInfo processInfo, boolean bl, boolean bl2, File[] fileArray, boolean bl3, boolean bl4, boolean bl5) throws WsBuildException {
        if (processInfo == null) {
            throw new WsBuildException("Invalid use of ClientGenUtil.setupService. The ProcessInfo object must be non-null.");
        }
        try {
            WsdlDefinitionsBuilder wsdlDefinitionsBuilder = (WsdlDefinitionsBuilder)WsdlFactory.getInstance().parse(string);
            processInfo.setWsdlDefs(wsdlDefinitionsBuilder);
            QName qName = ClientGenUtil.findServiceName(wsdlDefinitionsBuilder, string2, string);
            ClientGenUtil.setupBuildtimeBindingsFromScratch(wsdlDefinitionsBuilder, qName, processInfo, bl, bl2, fileArray, bl3, bl4);
            ClientGenUtil.setupJsService(wsdlDefinitionsBuilder, qName, processInfo, bl, bl5);
        }
        catch (WsdlException wsdlException) {
            throw new WsBuildException(wsdlException);
        }
    }

    public static void setupServiceWithExistingTypes(String string, String string2, ProcessInfo processInfo, URI uRI) throws WsBuildException {
        if (processInfo == null) {
            throw new WsBuildException("Invalid use of ClientGenUtil.setupServiceWithExistingTypes. The ProcessInfo object must be non-null.");
        }
        try {
            WsdlDefinitions wsdlDefinitions = WsdlFactory.getInstance().parse(string);
            processInfo.setWsdlDefs(wsdlDefinitions);
            QName qName = ClientGenUtil.findServiceName(wsdlDefinitions, string2, string);
            BuildtimeBindings buildtimeBindings = BuildtimeBindings.Loader.reloadBuildtimeBindings(uRI, processInfo.getTypeFamily());
            processInfo.setBuildtimeBindings(buildtimeBindings);
            ClientGenUtil.setupJsService(wsdlDefinitions, qName, processInfo, false);
        }
        catch (WsdlException wsdlException) {
            throw new WsBuildException(wsdlException);
        }
        catch (XmlException xmlException) {
            throw new WsBuildException(xmlException);
        }
        catch (IOException iOException) {
            throw new WsBuildException(iOException);
        }
    }

    public static BuildtimeBindings createBuildtimeBindings(WsdlDefinitionsBuilder wsdlDefinitionsBuilder, QName qName, File file, TypeFamily typeFamily, boolean bl, boolean bl2, boolean bl3) throws WsBuildException {
        return ClientGenUtil.createBuildtimeBindings(wsdlDefinitionsBuilder, qName, file, typeFamily, bl, bl2, bl3, false, null);
    }

    public static BuildtimeBindings createBuildtimeBindings(WsdlDefinitionsBuilder wsdlDefinitionsBuilder, QName qName, File file, TypeFamily typeFamily, boolean bl, boolean bl2, boolean bl3, boolean bl4, File[] fileArray) throws WsBuildException {
        return ClientGenUtil.createBuildtimeBindings(wsdlDefinitionsBuilder, qName, file, typeFamily, bl, bl2, bl3, bl4, true, fileArray, false, false);
    }

    public static BuildtimeBindings createBuildtimeBindings(WsdlDefinitionsBuilder wsdlDefinitionsBuilder, QName qName, File file, TypeFamily typeFamily, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, File[] fileArray, boolean bl6, boolean bl7) throws WsBuildException {
        try {
            WsdlServiceBuilder[] wsdlServiceBuilderArray = null;
            if (qName != null) {
                WsdlServiceBuilder wsdlServiceBuilder = wsdlDefinitionsBuilder.getServices().get(qName);
                WsdlServiceBuilder wsdlServiceBuilder2 = null;
                if (wsdlServiceBuilder == null) {
                    throw new WsBuildException("Invalid service name (" + qName + "). Could not find service in WSDL.");
                }
                QName qName2 = ClientGenUtil.getJsCallbackServiceName(wsdlDefinitionsBuilder);
                if (qName2 != null) {
                    wsdlServiceBuilder2 = wsdlDefinitionsBuilder.getServices().get(qName2);
                }
                wsdlServiceBuilderArray = wsdlServiceBuilder2 != null ? new WsdlServiceBuilder[]{wsdlServiceBuilder, wsdlServiceBuilder2} : new WsdlServiceBuilder[]{wsdlServiceBuilder};
            }
            return ClientGenUtil.createBindingProvider(wsdlServiceBuilderArray, wsdlDefinitionsBuilder, file, typeFamily, bl, bl2, bl3, bl4, bl5, fileArray, bl6, bl7);
        }
        catch (XmlException xmlException) {
            throw new WsBuildException(xmlException);
        }
        catch (IOException iOException) {
            throw new WsBuildException(iOException);
        }
    }

    public static void setupBuildtimeBindingsFromScratch(WsdlDefinitions wsdlDefinitions, QName qName, ProcessInfo processInfo, boolean bl) throws WsBuildException {
        ClientGenUtil.setupBuildtimeBindingsFromScratch(wsdlDefinitions, qName, processInfo, bl);
    }

    public static void setupBuildtimeBindingsFromScratch(WsdlDefinitionsBuilder wsdlDefinitionsBuilder, QName qName, ProcessInfo processInfo, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws WsBuildException {
        ClientGenUtil.setupBuildtimeBindingsFromScratch(wsdlDefinitionsBuilder, qName, processInfo, bl, bl2, null, bl3, bl4);
    }

    public static void setupBuildtimeBindingsFromScratch(WsdlDefinitionsBuilder wsdlDefinitionsBuilder, QName qName, ProcessInfo processInfo, boolean bl, boolean bl2, File[] fileArray, boolean bl3) throws WsBuildException {
        ClientGenUtil.setupBuildtimeBindingsFromScratch(wsdlDefinitionsBuilder, qName, processInfo, bl, bl2, true, fileArray, bl3, false);
    }

    public static void setupBuildtimeBindingsFromScratch(WsdlDefinitionsBuilder wsdlDefinitionsBuilder, QName qName, ProcessInfo processInfo, boolean bl, boolean bl2, File[] fileArray, boolean bl3, boolean bl4) throws WsBuildException {
        ClientGenUtil.setupBuildtimeBindingsFromScratch(wsdlDefinitionsBuilder, qName, processInfo, bl, bl2, true, fileArray, bl3, bl4);
    }

    public static void setupBuildtimeBindingsFromScratch(WsdlDefinitionsBuilder wsdlDefinitionsBuilder, QName qName, ProcessInfo processInfo, boolean bl, boolean bl2, boolean bl3, File[] fileArray, boolean bl4, boolean bl5) throws WsBuildException {
        BuildtimeBindings buildtimeBindings = processInfo.getBuildtimeBindings();
        if (buildtimeBindings != null) {
            return;
        }
        buildtimeBindings = ClientGenUtil.createBuildtimeBindings(wsdlDefinitionsBuilder, qName, processInfo.getDestDir(), processInfo.getTypeFamily(), bl, processInfo.isJaxRPCWrappedArrayStyle(), processInfo.isWriteJavaTypes(), bl2, bl3, fileArray, bl4, bl5);
        processInfo.setBuildtimeBindings(buildtimeBindings);
    }

    public static void setupJsService(WsdlDefinitions wsdlDefinitions, QName qName, ProcessInfo processInfo, boolean bl) throws WsBuildException {
        ClientGenUtil.setupJsService(wsdlDefinitions, qName, processInfo, bl, false);
    }

    public static void setupJsService(WsdlDefinitions wsdlDefinitions, QName qName, ProcessInfo processInfo, boolean bl, boolean bl2) throws WsBuildException {
        BuildtimeBindings buildtimeBindings = processInfo.getBuildtimeBindings();
        if (buildtimeBindings == null) {
            throw new WsBuildException("Invalid use of ClientGenUtil.setupJsService. ProcessInfo.getBuildtimeBindings() must return non-null.");
        }
        if (!wsdlDefinitions.getServices().values().iterator().hasNext()) {
            processInfo.setPartialWsdl(true);
        }
        processInfo.setServiceName(qName.getLocalPart());
        EndpointBuilder endpointBuilder = new EndpointBuilder(wsdlDefinitions, buildtimeBindings, processInfo.getPackageName());
        endpointBuilder.setAutoDetectWrapped(bl);
        endpointBuilder.setGenerateAsyncMethods(processInfo.isGenerateAsyncMethods());
        endpointBuilder.setFillIncompleteParameterOrderList(bl2);
        try {
            JsService jsService = endpointBuilder.buildJsService(qName);
            if (processInfo.getCallbackJClass() != null) {
                ClientGenUtil.setCallbackMethodName(jsService, processInfo.getCallbackJClass());
            }
            processInfo.setPackageName(endpointBuilder.getPackageName());
            processInfo.setJsService(jsService);
            QName qName2 = ClientGenUtil.getJsCallbackServiceName(wsdlDefinitions);
            if (qName2 != null) {
                JsService jsService2 = endpointBuilder.buildJsService(qName2);
                processInfo.setJsCallbackService(jsService2);
            }
        }
        catch (WsdlException wsdlException) {
            throw new WsBuildException("Failed to parse wsdl", wsdlException);
        }
    }

    private static void p(String string) {
        System.out.println("[ClientGenUtil] " + string);
    }

    public static QName getJsCallbackServiceName(WsdlDefinitions wsdlDefinitions) throws WsBuildException {
        WsdlPartnerLinkType wsdlPartnerLinkType = (WsdlPartnerLinkType)wsdlDefinitions.getExtension("PartnerLinkType");
        if (wsdlPartnerLinkType != null) {
            for (WsdlService wsdlService : wsdlDefinitions.getServices().values()) {
                for (WsdlPortType wsdlPortType : wsdlService.getPortTypes()) {
                    QName qName = null;
                    try {
                        qName = wsdlPartnerLinkType.getPortTypeName("Callback");
                        if (qName == null || !wsdlPortType.getName().equals(qName)) continue;
                        return wsdlService.getName();
                    }
                    catch (WsdlException wsdlException) {
                    }
                }
            }
        }
        return null;
    }

    protected static void setCallbackMethodName(JsService jsService, JClass jClass) throws WsBuildException {
        Map map = ClientGenUtil.buildOperationNameMap(jClass);
        Iterator iterator = jsService.getEndpoints();
        if (iterator.hasNext()) {
            String string = null;
            while (iterator.hasNext()) {
                JsClass jsClass = (JsClass)iterator.next();
                if (string == null) {
                    string = jsClass.getQualifiedName();
                } else if (!string.equals(jsClass.getQualifiedName())) {
                    throw new WsBuildException("Callback service has endpoints with different names");
                }
                for (JsMethod jsMethod : jsClass.getMethods()) {
                    String string2 = (String)map.get(jsMethod.getOperationName().getLocalPart());
                    if (string2 == null) {
                        throw new WsBuildException("operation name " + jsMethod.getOperationName() + " is not found in callback interface " + jClass.getQualifiedName());
                    }
                    jsMethod.setMethodName(string2);
                }
            }
        } else {
            throw new WsBuildException("Callback service doesn't have an Endpoint.");
        }
    }

    private static Map buildOperationNameMap(JClass jClass) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (JMethod jMethod : jClass.getMethods()) {
            String string = jMethod.getSimpleName();
            JAnnotation jAnnotation = jMethod.getAnnotation(WebMethod.class);
            if (jAnnotation != null) {
                string = ClientGenUtil.getOperationName(jAnnotation, jMethod);
            }
            hashMap.put(jMethod.getSimpleName(), string);
        }
        return hashMap;
    }

    private static String getOperationName(JAnnotation jAnnotation, JMethod jMethod) {
        JAnnotationValue jAnnotationValue = jAnnotation.getValue("operationName");
        String string = null;
        if (jAnnotationValue != null) {
            string = jAnnotationValue.asString();
        }
        if (StringUtil.isEmpty(string)) {
            string = jMethod.getSimpleName();
        }
        return string;
    }

    private static BuildtimeBindings createBindingProvider(WsdlServiceBuilder[] wsdlServiceBuilderArray, WsdlDefinitionsBuilder wsdlDefinitionsBuilder, File file, TypeFamily typeFamily, boolean bl, boolean bl2, boolean bl3, boolean bl4, File[] fileArray, boolean bl5) throws XmlException, IOException {
        return ClientGenUtil.createBindingProvider(wsdlServiceBuilderArray, wsdlDefinitionsBuilder, file, typeFamily, bl, bl2, bl3, bl4, true, fileArray, bl5, false);
    }

    private static BuildtimeBindings createBindingProvider(WsdlServiceBuilder[] wsdlServiceBuilderArray, WsdlDefinitionsBuilder wsdlDefinitionsBuilder, File file, TypeFamily typeFamily, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, File[] fileArray, boolean bl6, boolean bl7) throws XmlException, IOException {
        S2JBindingsBuilder s2JBindingsBuilder = null;
        if (TypeFamily.TYLAR.equals(typeFamily)) {
            TylarS2JBindingsBuilder tylarS2JBindingsBuilder = S2JBindingsBuilder.Factory.createTylarBindingsBuilder();
            tylarS2JBindingsBuilder.setJaxRPCWrappedArrayStyle(bl2);
            tylarS2JBindingsBuilder.setWriteJavaTypes(bl3);
            tylarS2JBindingsBuilder.setXsdConfig(fileArray);
            tylarS2JBindingsBuilder.setUseJaxRpcRules(bl5);
            s2JBindingsBuilder = tylarS2JBindingsBuilder;
        } else if (TypeFamily.XMLBEANS_APACHE.equals(typeFamily)) {
            s2JBindingsBuilder = S2JBindingsBuilder.Factory.createXmlBeansApacheBindingsBuilder();
            s2JBindingsBuilder.setXsdConfig(fileArray);
        } else if (TypeFamily.XMLBEANS.equals(typeFamily)) {
            s2JBindingsBuilder = S2JBindingsBuilder.Factory.createXmlBeansBindingsBuilder();
            s2JBindingsBuilder.setXsdConfig(fileArray);
        }
        return EndpointBuilder.setupBindingProviderWithServices(s2JBindingsBuilder, wsdlDefinitionsBuilder, file, wsdlServiceBuilderArray, bl, bl4, bl6, bl7);
    }

    public static QName findServiceName(WsdlDefinitions wsdlDefinitions, String string, String string2) throws WsBuildException {
        String string3;
        QName qName = null;
        String string4 = string3 = string2 == null ? wsdlDefinitions.getName() : string2;
        if (string != null) {
            qName = new QName(wsdlDefinitions.getTargetNamespace(), string);
            if (wsdlDefinitions.getServices().get(qName) == null) {
                for (WsdlDefinitions wsdlDefinitions2 : wsdlDefinitions.getImportedWsdlDefinitions()) {
                    qName = new QName(wsdlDefinitions2.getTargetNamespace(), string);
                    if (wsdlDefinitions.getServices().get(qName) == null) continue;
                    return qName;
                }
                throw new WsBuildException("Service \"" + string + "\" is not found in wsdl " + string3 + " or the wsdls imported by " + string3);
            }
        } else {
            Iterator<? extends WsdlService> iterator = wsdlDefinitions.getServices().values().iterator();
            if (!iterator.hasNext()) {
                throw new WsBuildException("No service found in wsdl " + string3);
            }
            WsdlService wsdlService = iterator.next();
            qName = wsdlService.getName();
            if (iterator.hasNext()) {
                throw new WsBuildException("WSDL at \"" + string3 + "\" has more than one service definition, please specify a serviceName.");
            }
        }
        return qName;
    }

    public static void addJsCallbackServiceToProcessInfoIfWlw81CallbackPresent(String string, String string2, ProcessInfo processInfo, boolean bl) throws WsBuildException {
        try {
            if (processInfo.getJsCallbackService() == null && CallbackUtils.has81StyleCallback(processInfo.getJsService())) {
                QName qName = ClientGenUtil.findServiceName(processInfo.getWsdlDefs(), string2, string);
                EndpointBuilder endpointBuilder = new EndpointBuilder(processInfo.getWsdlDefs(), processInfo.getBuildtimeBindings(), processInfo.getPackageName());
                endpointBuilder.setAutoDetectWrapped(bl);
                endpointBuilder.setGenerateAsyncMethods(processInfo.isGenerateAsyncMethods());
                endpointBuilder.setWlw81CallbackGen(true);
                JsService jsService = endpointBuilder.buildJsService(qName);
                processInfo.setJsCallbackService(jsService);
            }
        }
        catch (WsdlException wsdlException) {
            throw new WsBuildException(wsdlException);
        }
    }
}

