/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.clientgen;

import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JAnnotationValue;
import com.bea.util.jam.JClass;
import com.bea.util.jam.JMethod;
import com.bea.xbean.xb.xsdschema.SchemaDocument;
import com.bea.xml.XmlException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jws.WebMethod;
import javax.xml.namespace.QName;
import weblogic.wsee.bind.buildtime.BuildtimeBindings;
import weblogic.wsee.bind.buildtime.internal.WLW81TylarSchemaAndJavaBindingsBuilderImpl;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.clientgen.ClientGenUtil;
import weblogic.wsee.tools.clientgen.ProcessInfo;
import weblogic.wsee.tools.source.JsService;
import weblogic.wsee.tools.source.Wlw81EndpointBuilder;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.WsdlFactory;
import weblogic.wsee.wsdl.WsdlService;
import weblogic.wsee.wsdl.WsdlTypes;
import weblogic.wsee.wsdl.builder.WsdlDefinitionsBuilder;

public class ClientGenUtilForWLW81Types {
    public static void setupService(String string, String string2, JClass jClass, ProcessInfo processInfo, boolean bl) throws WsBuildException {
        if (processInfo == null) {
            throw new WsBuildException("Invalid use of ClientGenUtilForWLW81Types.setupService. The ProcessInfo object must be non-null.");
        }
        try {
            WsdlDefinitionsBuilder wsdlDefinitionsBuilder = (WsdlDefinitionsBuilder)WsdlFactory.getInstance().parse(string);
            processInfo.setWsdlDefs(wsdlDefinitionsBuilder);
            QName qName = ClientGenUtil.findServiceName(wsdlDefinitionsBuilder, string2, string);
            ClientGenUtilForWLW81Types.setupBuildtimeBindingsFromScratch(wsdlDefinitionsBuilder, qName, jClass, processInfo, bl);
            ClientGenUtilForWLW81Types.setupJsService(wsdlDefinitionsBuilder, qName, processInfo, jClass);
        }
        catch (WsdlException wsdlException) {
            throw new WsBuildException(wsdlException);
        }
    }

    public static BuildtimeBindings createBuildtimeBindings(WsdlDefinitionsBuilder wsdlDefinitionsBuilder, QName qName, JClass jClass, File file, boolean bl) throws WsBuildException {
        try {
            return ClientGenUtilForWLW81Types.createBindingProvider(wsdlDefinitionsBuilder.getServices().get(qName), jClass, file, bl);
        }
        catch (XmlException xmlException) {
            throw new WsBuildException(xmlException);
        }
        catch (IOException iOException) {
            throw new WsBuildException(iOException);
        }
    }

    public static void setupBuildtimeBindingsFromScratch(WsdlDefinitionsBuilder wsdlDefinitionsBuilder, QName qName, JClass jClass, ProcessInfo processInfo, boolean bl) throws WsBuildException {
        BuildtimeBindings buildtimeBindings = processInfo.getBuildtimeBindings();
        if (buildtimeBindings != null) {
            return;
        }
        buildtimeBindings = ClientGenUtilForWLW81Types.createBuildtimeBindings(wsdlDefinitionsBuilder, qName, jClass, processInfo.getDestDir(), bl);
        processInfo.setBuildtimeBindings(buildtimeBindings);
    }

    private static BuildtimeBindings createBindingProvider(WsdlService wsdlService, JClass jClass, File file, boolean bl) throws XmlException, IOException {
        WLW81TylarSchemaAndJavaBindingsBuilderImpl wLW81TylarSchemaAndJavaBindingsBuilderImpl = new WLW81TylarSchemaAndJavaBindingsBuilderImpl(bl);
        WsdlDefinitions wsdlDefinitions = wsdlService.getDefinitions();
        WsdlTypes wsdlTypes = wsdlDefinitions.getTypes();
        if (wsdlTypes != null) {
            SchemaDocument[] schemaDocumentArray = wsdlTypes.getSchemaArray();
            for (int i = 0; i < schemaDocumentArray.length; ++i) {
                wLW81TylarSchemaAndJavaBindingsBuilderImpl.addSchemaDocument(schemaDocumentArray[i]);
            }
        }
        wLW81TylarSchemaAndJavaBindingsBuilderImpl.setServiceJClass(jClass);
        wLW81TylarSchemaAndJavaBindingsBuilderImpl.setWsdlService(wsdlService);
        return wLW81TylarSchemaAndJavaBindingsBuilderImpl.createBuildtimeBindings(file);
    }

    public static void setupJsService(WsdlDefinitions wsdlDefinitions, QName qName, ProcessInfo processInfo, JClass jClass) throws WsBuildException {
        BuildtimeBindings buildtimeBindings = processInfo.getBuildtimeBindings();
        if (buildtimeBindings == null) {
            throw new WsBuildException("Invalid use of ClientGenUtil.setupJsService. ProcessInfo.getBuildtimeBindings() must return non-null.");
        }
        if (!wsdlDefinitions.getServices().values().iterator().hasNext()) {
            processInfo.setPartialWsdl(true);
        }
        processInfo.setServiceName(qName.getLocalPart());
        Wlw81EndpointBuilder wlw81EndpointBuilder = new Wlw81EndpointBuilder(wsdlDefinitions, buildtimeBindings, processInfo.getPackageName());
        wlw81EndpointBuilder.setAlwaysUseDataHandlerForMimeTypes(true);
        wlw81EndpointBuilder.setServiceInterfaceJClass(jClass);
        wlw81EndpointBuilder.setGenerateAsyncMethods(processInfo.isGenerateAsyncMethods());
        try {
            JsService jsService = wlw81EndpointBuilder.buildJsService(qName);
            if (processInfo.getCallbackJClass() != null) {
                ClientGenUtil.setCallbackMethodName(jsService, processInfo.getCallbackJClass());
            }
            processInfo.setJsService(jsService);
            QName qName2 = ClientGenUtil.getJsCallbackServiceName(wsdlDefinitions);
            if (qName2 != null) {
                JsService jsService2 = wlw81EndpointBuilder.buildJsService(qName2);
                processInfo.setJsCallbackService(jsService2);
            }
        }
        catch (WsdlException wsdlException) {
            throw new WsBuildException("Failed to parse wsdl", wsdlException);
        }
    }

    private static Map buildOperationNameMap(JClass jClass) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        JMethod[] jMethodArray = jClass.getMethods();
        for (int i = 0; i < jMethodArray.length; ++i) {
            JMethod jMethod = jMethodArray[i];
            JAnnotation jAnnotation = jMethod.getAnnotation(WebMethod.class);
            if (jAnnotation == null) continue;
            JAnnotationValue jAnnotationValue = jAnnotation.getValue("operationName");
            String string = null;
            if (jAnnotationValue != null) {
                string = jAnnotationValue.asString();
            }
            if (StringUtil.isEmpty(string)) {
                string = jMethod.getSimpleName();
            }
            hashMap.put(jMethod.getSimpleName(), jMethod.getSimpleName());
        }
        return hashMap;
    }
}

