/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.clientgen;

import com.bea.util.jam.JClass;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import weblogic.wsee.bind.TypeFamily;
import weblogic.wsee.bind.buildtime.BuildtimeBindings;
import weblogic.wsee.tools.source.JsService;
import weblogic.wsee.util.UniqueNameSet;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlService;
import weblogic.xml.schema.binding.internal.NameUtil;

public class ProcessInfo {
    private String wsdlUrl;
    private WsdlDefinitions wsdlDefs;
    private String serviceName;
    private String packageName;
    private String mappingFileUri;
    private File destDir;
    private File handlerChain;
    private boolean partialWsdl;
    private JsService jsService;
    private JsService callbackService;
    private StubInfo stubInfo;
    private BuildtimeBindings buildtimeBindings;
    private boolean generatePolicyMethods;
    private JClass callbackJClass;
    private JClass webserviceJClass;
    private boolean jaxRPCWrappedArrayStyle;
    private boolean generateAsyncMethods;
    private boolean writeJavaTypes = true;
    private TypeFamily typeFamily = TypeFamily.TYLAR;
    private File callbackDestDir;
    private String callbackContextRoot;

    public String getCallbackContextRoot() {
        return this.callbackContextRoot;
    }

    public void setCallbackContextRoot(String string) {
        this.callbackContextRoot = string;
    }

    public File getCallbackDestDir() {
        return this.callbackDestDir;
    }

    public void setCallbackDestDir(File file) {
        this.callbackDestDir = file;
    }

    public BuildtimeBindings getBuildtimeBindings() {
        return this.buildtimeBindings;
    }

    public void setBuildtimeBindings(BuildtimeBindings buildtimeBindings) {
        this.buildtimeBindings = buildtimeBindings;
    }

    public String getMappingFileUri() {
        return this.mappingFileUri;
    }

    public void setMappingFileUri(String string) {
        this.mappingFileUri = string;
    }

    public String getMappingFileName() {
        String string = this.getStubInfo().getServiceName();
        return string + "_java_wsdl_mapping.xml";
    }

    public String getWsdlFileName() {
        String string = this.getStubInfo().getServiceName();
        return string + "_saved_wsdl.wsdl";
    }

    public WsdlDefinitions getWsdlDefs() {
        return this.wsdlDefs;
    }

    public String getWsdlUrl() {
        return this.wsdlUrl;
    }

    public void setWsdlUrl(String string) {
        this.wsdlUrl = string;
    }

    public void setWsdlDefs(WsdlDefinitions wsdlDefinitions) {
        this.wsdlDefs = wsdlDefinitions;
    }

    public boolean isPartialWsdl() {
        return this.partialWsdl;
    }

    public void setPartialWsdl(boolean bl) {
        this.partialWsdl = bl;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    public JsService getJsService() {
        return this.jsService;
    }

    public void setJsService(JsService jsService) {
        this.jsService = jsService;
    }

    public JsService getJsCallbackService() {
        return this.callbackService;
    }

    public void setJsCallbackService(JsService jsService) {
        this.callbackService = jsService;
    }

    public File getDestDir() {
        return this.destDir;
    }

    public void setDestDir(File file) {
        this.destDir = file;
    }

    public File getHandlerChain() {
        return this.handlerChain;
    }

    public void setHandlerChain(File file) {
        this.handlerChain = file;
    }

    public StubInfo getStubInfo() {
        return this.stubInfo;
    }

    public void setStubInfo(StubInfo stubInfo) {
        this.stubInfo = stubInfo;
    }

    public void setGeneratePolicyMethods(boolean bl) {
        this.generatePolicyMethods = bl;
    }

    public boolean getGeneratePolicyMethods() {
        return this.generatePolicyMethods;
    }

    public void setGenerateAsyncMethods(boolean bl) {
        this.generateAsyncMethods = bl;
    }

    public boolean isGenerateAsyncMethods() {
        return this.generateAsyncMethods;
    }

    public void setCallbackJClass(JClass jClass) {
        this.callbackJClass = jClass;
    }

    public JClass getCallbackJClass() {
        return this.callbackJClass;
    }

    public void setWebServiceJClass(JClass jClass) {
        this.webserviceJClass = jClass;
    }

    public JClass getWebServiceJClass() {
        return this.webserviceJClass;
    }

    public void setJaxRPCWrappedArrayStyle(boolean bl) {
        this.jaxRPCWrappedArrayStyle = bl;
    }

    public boolean isJaxRPCWrappedArrayStyle() {
        return this.jaxRPCWrappedArrayStyle;
    }

    public void setTypeFamily(TypeFamily typeFamily) {
        this.typeFamily = typeFamily;
    }

    public TypeFamily getTypeFamily() {
        return this.typeFamily;
    }

    public boolean isWriteJavaTypes() {
        return this.writeJavaTypes;
    }

    public void setWriteJavaTypes(boolean bl) {
        this.writeJavaTypes = bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StubInfo {
        private String serviceName;
        private String serviceImplName;
        private Map<String, String> portNameMap = new HashMap<String, String>();
        private Map<String, String> portTypeNameMap = new HashMap<String, String>();
        private Map<String, String> stubNameMap = new HashMap<String, String>();

        public StubInfo(WsdlService wsdlService) {
            this.initPorts(wsdlService);
            String string = NameUtil.getJAXRPCClassName((String)wsdlService.getName().getLocalPart());
            UniqueNameSet uniqueNameSet = new UniqueNameSet();
            this.serviceName = this.portTypeNameMap.containsValue(string) ? uniqueNameSet.add(string + "_Service") : uniqueNameSet.add(string);
            this.serviceImplName = uniqueNameSet.add(this.serviceName + "_Impl");
            this.initStubs(string, uniqueNameSet);
        }

        private void initStubs(String string, UniqueNameSet uniqueNameSet) {
            Set<Map.Entry<String, String>> set = this.portTypeNameMap.entrySet();
            for (Map.Entry<String, String> entry : set) {
                String string2 = entry.getValue();
                if (string.equals(string2)) {
                    string2 = string2 + "_PortType";
                }
                string2 = uniqueNameSet.add(string2);
                entry.setValue(string2);
                String string3 = uniqueNameSet.add(string2 + "_Stub");
                this.stubNameMap.put(entry.getKey(), string3);
            }
        }

        private void initPorts(WsdlService wsdlService) {
            UniqueNameSet uniqueNameSet = new UniqueNameSet();
            for (WsdlPort wsdlPort : wsdlService.getPorts().values()) {
                this.portNameMap.put(wsdlPort.getName().getLocalPart(), uniqueNameSet.add(NameUtil.getJAXRPCClassName((String)wsdlPort.getName().getLocalPart())));
                String string = wsdlPort.getPortType().getName().getLocalPart();
                if (this.portTypeNameMap.containsKey(string)) continue;
                this.portTypeNameMap.put(string, NameUtil.getJAXRPCClassName((String)string));
            }
        }

        public Map<String, String> getPortNameMap() {
            return this.portNameMap;
        }

        public Map<String, String> getPortTypeNameMap() {
            return this.portTypeNameMap;
        }

        public Map<String, String> getStubNameMap() {
            return this.stubNameMap;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String string) {
            this.serviceName = string;
        }

        public String getServiceImplName() {
            return this.serviceImplName;
        }
    }
}

