/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.clientgen.callback;

import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import weblogic.wsee.callback.CallbackUtils;
import weblogic.wsee.tools.clientgen.ProcessInfo;
import weblogic.wsee.tools.source.JsFault;
import weblogic.wsee.tools.source.JsMethod;
import weblogic.wsee.tools.source.JsParameterType;
import weblogic.wsee.tools.source.JsReturnType;
import weblogic.wsee.tools.source.JsService;
import weblogic.wsee.tools.wsdlc.jaxrpc.JwsBase;

public abstract class CallbackBase
extends JwsBase {
    private ProcessInfo processInfo;

    public void setup(Object object) {
        if (object == null) {
            throw new JAXRPCException("No setup object found");
        }
        if (!(object instanceof ProcessInfo)) {
            throw new JAXRPCException("Incorrect type of setup object: " + object.getClass().getName());
        }
        this.processInfo = (ProcessInfo)object;
    }

    protected String wrap(JsParameterType jsParameterType) {
        String string = jsParameterType.getType();
        String string2 = jsParameterType.getParamName();
        String string3 = string.equals("float") ? "new Float(" + string2 + ")" : (string.equals("int") ? "new Integer(" + string2 + ")" : (string.equals("long") ? "new Long(" + string2 + ")" : (string.equals("boolean") ? "new Boolean(" + string2 + ")" : (string.equals("short") ? "new Short(" + string2 + ")" : (string.equals("double") ? "new Double(" + string2 + ")" : (string.equals("byte") ? "new Byte(" + string2 + ")" : string2))))));
        return string3;
    }

    public String arguments(JsMethod jsMethod) {
        StringBuffer stringBuffer = new StringBuffer();
        JsParameterType[] jsParameterTypeArray = jsMethod.getArguments();
        if (jsParameterTypeArray != null && jsParameterTypeArray.length > 0) {
            for (int i = 0; i < jsParameterTypeArray.length; ++i) {
                JsParameterType jsParameterType = jsParameterTypeArray[i];
                stringBuffer.append(jsParameterType.getType());
                stringBuffer.append(" " + jsParameterType.getParamName());
                if (i >= jsParameterTypeArray.length - 1) continue;
                stringBuffer.append(", ");
            }
        }
        return stringBuffer.toString();
    }

    public String exceptions(JsMethod jsMethod) {
        StringBuffer stringBuffer = new StringBuffer("");
        JsFault[] jsFaultArray = jsMethod.getFaults();
        if (jsFaultArray != null && jsFaultArray.length > 0) {
            stringBuffer.append(", ");
            for (int i = 0; i < jsFaultArray.length; ++i) {
                stringBuffer.append(jsFaultArray[i].getExceptionClass());
                if (i >= jsFaultArray.length - 1) continue;
                stringBuffer.append(", ");
            }
        }
        return stringBuffer.toString();
    }

    public String getReturnType(JsMethod jsMethod) {
        JsReturnType jsReturnType = jsMethod.getReturnType();
        return jsReturnType.getType();
    }

    public String getCallbackQueue() {
        return "@weblogic.wsee.CallbackQueue@";
    }

    public String getServiceUri(String string) {
        JsService jsService = this.processInfo.getJsCallbackService();
        String string2 = string;
        if (jsService == null && CallbackUtils.has81StyleCallback(this.processInfo.getJsService())) {
            jsService = this.processInfo.getJsService();
            string2 = string + "Callback";
        }
        if (jsService == null) {
            return null;
        }
        QName qName = jsService.getWsdlService().getName();
        return CallbackUtils.getServiceUri(qName, string2);
    }

    public String methodName(JsMethod jsMethod) {
        return jsMethod.getMethodName();
    }

    public String argTypes(JsMethod jsMethod) {
        JsParameterType[] jsParameterTypeArray = jsMethod.getArguments();
        StringBuffer stringBuffer = new StringBuffer("");
        if (jsParameterTypeArray != null && jsParameterTypeArray.length > 0) {
            stringBuffer.append("new Class[]{");
            for (int i = 0; i < jsParameterTypeArray.length; ++i) {
                String string = jsParameterTypeArray[i].getType();
                stringBuffer.append(this.getType(string));
                if (i >= jsParameterTypeArray.length - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("}");
        } else {
            stringBuffer.append("new Class[]{}");
        }
        return stringBuffer.toString();
    }

    public String argValues(JsMethod jsMethod) {
        JsParameterType[] jsParameterTypeArray = jsMethod.getArguments();
        StringBuffer stringBuffer = new StringBuffer("");
        if (jsParameterTypeArray != null && jsParameterTypeArray.length > 0) {
            stringBuffer.append("new Object[]{");
            for (int i = 0; i < jsParameterTypeArray.length; ++i) {
                String string = jsParameterTypeArray[i].getType();
                stringBuffer.append(this.wrapType(string, jsParameterTypeArray[i].getParamName()));
                if (i >= jsParameterTypeArray.length - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("}");
        } else {
            stringBuffer.append("new Class[]{}");
        }
        return stringBuffer.toString();
    }

    public String returnValue(JsMethod jsMethod) {
        JsReturnType jsReturnType = jsMethod.getReturnType();
        String string = "";
        if (!jsReturnType.getType().equals("void")) {
            String string2 = jsReturnType.getType();
            if (string2.indexOf("int") != -1) {
                string = "return ((Integer)_retVal).intValue();";
            } else if (string2.indexOf("float") != -1) {
                string = "return ((Float)_retVal).floatValue();";
            } else if (string2.indexOf("long") != -1) {
                string = "return ((Long)_retVal).longValue();";
            } else if (string2.indexOf("double") != -1) {
                string = "return ((Double)_retVal).doubleValue();";
            } else if (string2.indexOf("char") != -1) {
                string = "return ((Character)_retVal).charValue();";
            } else if (string2.indexOf("boolean") != -1) {
                string = "return ((Boolean)_retVal).booleanValue();";
            } else {
                string = "return (" + string2 + ")_retVal;";
                return string;
            }
        }
        return string;
    }

    private String getType(String string) {
        String string2 = "";
        string2 = string.indexOf("int") != -1 ? "Integer.TYPE" : (string.indexOf("float") != -1 ? "Float.TYPE" : (string.indexOf("long") != -1 ? "Long.TYPE" : (string.indexOf("double") != -1 ? "Double.TYPE" : (string.indexOf("char") != -1 ? "Character.TYPE" : (string.indexOf("boolean") != -1 ? "Boolean.TYPE" : string + ".class")))));
        return string2;
    }

    private String wrapType(String string, String string2) {
        String string3 = "";
        string3 = string.indexOf("int") != -1 ? "new Integer(" + string2 + ")" : (string.indexOf("float") != -1 ? "new Float(" + string2 + ")" : (string.indexOf("long") != -1 ? "new Long(" + string2 + ")" : (string.indexOf("double") != -1 ? "new Double(" + string2 + ")" : (string.indexOf("char") != -1 ? "new Character(" + string2 + ")" : (string.indexOf("boolean") != -1 ? "new Boolean(" + string2 + ")" : string2)))));
        return string3;
    }
}

