/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.clientgen.callback;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.Project;
import weblogic.wsee.callback.CallbackUtils;
import weblogic.wsee.tools.ToolsUtil;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.anttasks.WsdlcTask;
import weblogic.wsee.tools.clientgen.ProcessInfo;
import weblogic.wsee.tools.clientgen.jaxrpc.ClientGenProcessor;
import weblogic.wsee.tools.jws.build.GeneratedCallbackJws;
import weblogic.wsee.tools.jws.build.Jws;
import weblogic.wsee.tools.source.JsClass;
import weblogic.wsee.tools.source.JsPort;
import weblogic.wsee.tools.source.JsService;
import weblogic.wsee.wsdl.Callback81WsdlExtracter;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallbackGen81Processor
implements ClientGenProcessor {
    private Project project;
    private List<Jws> callbackJws = new ArrayList<Jws>();

    public CallbackGen81Processor(Project project) {
        this.project = project;
    }

    @Override
    public void process(ProcessInfo processInfo) throws WsBuildException {
        if (processInfo.isPartialWsdl()) {
            return;
        }
        JsService jsService = processInfo.getJsService();
        if (jsService == null) {
            return;
        }
        if (!CallbackUtils.has81StyleCallback(jsService)) {
            return;
        }
        String string = processInfo.getPackageName();
        if (string.endsWith(".callbackclient")) {
            return;
        }
        File file = processInfo.getDestDir();
        String string2 = "destDir";
        ToolsUtil.validateRequiredFile(file, string2);
        ToolsUtil.createDir(file, string2);
        List<String> list = this.getSoapPortName(jsService);
        this.callbackJws.clear();
        for (String string3 : list) {
            WsdlcTask wsdlcTask = new WsdlcTask();
            wsdlcTask.setProject(this.project);
            String string4 = processInfo.getWsdlUrl();
            File file2 = Callback81WsdlExtracter.extract(string4, string3, file);
            string4 = file2.getAbsolutePath();
            wsdlcTask.setSrcWsdl(string4);
            wsdlcTask.setDestJwsDir(file);
            wsdlcTask.setDestImplDir(file);
            wsdlcTask.setPackageName(string);
            wsdlcTask.setCodeGenBaseData(processInfo);
            wsdlcTask.setImplTemplateClassName("weblogic.wsee.tools.clientgen.callback.CallbackImpl");
            wsdlcTask.setWlw81CallbackGen(true);
            wsdlcTask.setUpgraded81Jws(true);
            wsdlcTask.setSrcPortName(string3);
            wsdlcTask.setJaxRPCWrappedArrayStyle(false);
            wsdlcTask.setTypeFamily(processInfo.getTypeFamily());
            wsdlcTask.setExplode(false);
            wsdlcTask.execute();
            file2.delete();
            JsPort jsPort = jsService.getPort(string3);
            assert (jsPort != null);
            JsClass jsClass = jsPort.getEndpoint();
            GeneratedCallbackJws generatedCallbackJws = new GeneratedCallbackJws();
            generatedCallbackJws.setFile(jsClass.getQualifiedName().replace('.', '/') + "CallbackImpl.java");
            generatedCallbackJws.srcdir(processInfo.getDestDir());
            generatedCallbackJws.setCompiledWsdl(new File(file, file2.getName().replace('.', '_') + ".jar"));
            this.callbackJws.add(generatedCallbackJws);
        }
    }

    private List<String> getSoapPortName(JsService jsService) throws WsBuildException {
        ArrayList<String> arrayList = new ArrayList<String>();
        WsdlService wsdlService = jsService.getWsdlService();
        for (WsdlPort wsdlPort : wsdlService.getPorts().values()) {
            if (!wsdlPort.getName().getLocalPart().endsWith("Soap")) continue;
            arrayList.add(wsdlPort.getName().getLocalPart());
        }
        if (arrayList.size() == 0) {
            throw new WsBuildException("No suitable SOAP port found for callback");
        }
        return arrayList;
    }

    public List<Jws> getCallbackJws() {
        return this.callbackJws;
    }
}

