/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.clientgen.callback;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.Project;
import weblogic.wsee.tools.ToolsUtil;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.anttasks.WsdlcTask;
import weblogic.wsee.tools.clientgen.ProcessInfo;
import weblogic.wsee.tools.clientgen.jaxrpc.ClientGenProcessor;
import weblogic.wsee.tools.jws.UpgradedJwsWsdlWriter;
import weblogic.wsee.tools.jws.build.Jws;
import weblogic.wsee.tools.source.JsClass;
import weblogic.wsee.tools.source.JsService;
import weblogic.wsee.wsdl.WsdlPartnerLinkType;
import weblogic.wsee.wsdl.WsdlService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallbackGenProcessor
implements ClientGenProcessor {
    private Project project;
    private List<Jws> callbackJws = new ArrayList<Jws>();

    public CallbackGenProcessor(Project project) {
        this.project = project;
    }

    @Override
    public void process(ProcessInfo processInfo) throws WsBuildException {
        if (processInfo.isPartialWsdl()) {
            return;
        }
        JsService jsService = processInfo.getJsCallbackService();
        if (jsService == null) {
            return;
        }
        WsdlService wsdlService = jsService.getWsdlService();
        WsdlPartnerLinkType wsdlPartnerLinkType = (WsdlPartnerLinkType)wsdlService.getDefinitions().getExtension("PartnerLinkType");
        if (wsdlPartnerLinkType == null) {
            return;
        }
        String string = processInfo.getPackageName();
        if (string.endsWith(".callbackclient")) {
            return;
        }
        File file = processInfo.getDestDir();
        String string2 = "destDir";
        ToolsUtil.validateRequiredFile(file, string2);
        ToolsUtil.createDir(file, string2);
        WsdlcTask wsdlcTask = new WsdlcTask();
        wsdlcTask.setProject(this.project);
        wsdlcTask.setSrcWsdl(processInfo.getWsdlUrl());
        wsdlcTask.setDestJwsDir(file);
        wsdlcTask.setDestImplDir(file);
        wsdlcTask.setPackageName(string);
        wsdlcTask.setCodeGenBaseData(processInfo);
        wsdlcTask.setImplTemplateClassName("weblogic.wsee.tools.clientgen.callback.CallbackImpl");
        wsdlcTask.setSrcServiceName(wsdlService.getName().toString());
        wsdlcTask.setJaxRPCWrappedArrayStyle(false);
        wsdlcTask.setTypeFamily(processInfo.getTypeFamily());
        wsdlcTask.setExplode(true);
        if (UpgradedJwsWsdlWriter.narrow(processInfo.getJsService().getWsdlService()) != null) {
            wsdlcTask.setUpgraded81Jws(true);
        }
        wsdlcTask.execute();
        Iterator iterator = processInfo.getJsCallbackService().getEndpoints();
        assert (iterator.hasNext()) : "Service has no endpoints";
        JsClass jsClass = (JsClass)iterator.next();
        this.callbackJws.clear();
        Jws jws = new Jws();
        jws.setFile(jsClass.getQualifiedName().replace('.', '/') + "Impl.java");
        jws.srcdir(processInfo.getDestDir());
        this.callbackJws.add(jws);
    }

    public List<Jws> getCallbackJws() {
        return this.callbackJws;
    }
}

