/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.clientgen.jaxrpc;

import com.bea.util.jam.JClass;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import weblogic.jws.wlw.UseWLW81BindingTypes;
import weblogic.wsee.tools.ToolsUtil;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.clientgen.ClientGen;
import weblogic.wsee.tools.clientgen.ClientGenUtil;
import weblogic.wsee.tools.clientgen.ClientGenUtilForWLW81Types;
import weblogic.wsee.tools.clientgen.ProcessInfo;
import weblogic.wsee.tools.clientgen.jaxrpc.ClientGenProcessor;
import weblogic.wsee.tools.clientgen.jaxrpc.Options;
import weblogic.wsee.tools.clientgen.mapping.JaxrpcMappingProcessor;
import weblogic.wsee.tools.clientgen.serviceref.ServiceRefProcessor;
import weblogic.wsee.tools.clientgen.stubgen.StubGenProcessor;
import weblogic.wsee.tools.logging.DefaultLogger;
import weblogic.wsee.tools.logging.Logger;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlException;
import weblogic.wsee.wsdl.builder.WsdlDefinitionsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientGenImpl
implements ClientGen<Options> {
    private ProcessInfo processInfo = new ProcessInfo();
    private WsdlDefinitionsBuilder definitions;
    private Options options = new Options();
    private File[] bindingFiles = null;
    private Logger logger = new DefaultLogger();
    private final List<ClientGenProcessor> standardProcessors = Collections.unmodifiableList(new ArrayList<ClientGenProcessor>(Arrays.asList(new StubGenProcessor(), new JaxrpcMappingProcessor(), new ServiceRefProcessor())));

    public ClientGenImpl() {
        this.syncProcessInfo();
    }

    @Override
    public void setWsdl(String string) {
        this.processInfo.setWsdlUrl(string);
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger == null ? new DefaultLogger() : logger;
    }

    public void setWsdlDefinitions(WsdlDefinitions wsdlDefinitions) {
        this.definitions = (WsdlDefinitionsBuilder)wsdlDefinitions;
    }

    @Override
    public void setBindingFiles(File[] fileArray) {
        this.bindingFiles = fileArray;
    }

    @Override
    public void setOptions(Options options) {
        this.options = options == null ? new Options() : options;
        this.syncProcessInfo();
    }

    private void syncProcessInfo() {
        this.processInfo.setServiceName(this.options.getServiceName());
        this.processInfo.setGeneratePolicyMethods(this.options.isGeneratePolicyMethods());
        this.processInfo.setJaxRPCWrappedArrayStyle(this.options.isJaxRPCWrappedArrayStyle());
        this.processInfo.setGenerateAsyncMethods(this.options.isGenerateAsyncMethods());
        this.processInfo.setHandlerChain(this.options.getHandlerChain());
        this.processInfo.setTypeFamily(this.options.getTypeFamily());
        this.processInfo.setWriteJavaTypes(this.options.isWriteJavaTypes());
    }

    public void setCallbackJClass(JClass jClass) {
        this.processInfo.setCallbackJClass(jClass);
    }

    public void setWebServiceJClass(JClass jClass) {
        this.processInfo.setWebServiceJClass(jClass);
    }

    @Override
    public void setPackageName(String string) {
        if (string != null) {
            string = string.trim();
        }
        this.processInfo.setPackageName(string);
    }

    @Override
    public void setDestDir(File file) {
        this.processInfo.setDestDir(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws WsBuildException {
        this.setSystemProperties();
        try {
            this.validate();
            this.setupProcessInfo();
            for (ClientGenProcessor clientGenProcessor : this.getProcessors()) {
                clientGenProcessor.process(this.processInfo);
            }
            this.cleanupMetaInf(this.processInfo.getDestDir());
            this.writeWsdl(this.processInfo);
        }
        finally {
            this.resetSystemProperties();
        }
    }

    private void validate() throws WsBuildException {
        this.validateWsdlUrl();
        this.validateTypeFamily();
        this.validateDestinationDir();
    }

    private void validateDestinationDir() throws WsBuildException {
        File file = this.processInfo.getDestDir();
        ToolsUtil.validateRequiredFile(file, "destDir", this.logger);
        ToolsUtil.createDir(file, "destDir");
    }

    private void validateTypeFamily() throws WsBuildException {
        if (this.processInfo.getTypeFamily() == null) {
            ToolsUtil.throwException("unknown type family - " + this.processInfo.getTypeFamily().getId(), this.logger);
        }
    }

    private void validateWsdlUrl() throws WsBuildException {
        if (this.definitions == null) {
            ToolsUtil.validateRequiredAttr(this.processInfo.getWsdlUrl(), "wsdl", this.logger);
        }
    }

    private List<ClientGenProcessor> getProcessors() {
        ArrayList<ClientGenProcessor> arrayList = new ArrayList<ClientGenProcessor>(this.standardProcessors);
        arrayList.addAll(this.options.getProcessors());
        return arrayList;
    }

    private void setupProcessInfo() throws WsBuildException {
        boolean bl = this.useWLW81Types();
        if (this.processInfo.getWsdlUrl() != null) {
            if (bl) {
                ClientGenUtilForWLW81Types.setupService(this.processInfo.getWsdlUrl(), this.processInfo.getServiceName(), this.processInfo.getWebServiceJClass(), this.processInfo, false);
            } else {
                ClientGenUtil.setupService(this.processInfo.getWsdlUrl(), this.processInfo.getServiceName(), this.processInfo, this.options.isAutoDetectWrapped(), this.options.isIncludeGlobalTypes(), this.bindingFiles, this.options.isAllowWrappedArrayForDocLiteral(), this.options.isSortSchemaTypes(), this.options.isFillIncompleteParameterOrderList());
            }
        } else {
            QName qName = ClientGenUtil.findServiceName(this.definitions, this.processInfo.getServiceName(), this.processInfo.getWsdlUrl());
            if (bl) {
                ClientGenUtilForWLW81Types.setupBuildtimeBindingsFromScratch(this.definitions, qName, this.processInfo.getWebServiceJClass(), this.processInfo, false);
                ClientGenUtilForWLW81Types.setupJsService(this.definitions, qName, this.processInfo, this.processInfo.getWebServiceJClass());
            } else {
                ClientGenUtil.setupBuildtimeBindingsFromScratch(this.definitions, qName, this.processInfo, this.options.isAutoDetectWrapped(), this.options.isIncludeGlobalTypes(), this.options.isUseJaxRpcRules(), this.bindingFiles, this.options.isAllowWrappedArrayForDocLiteral(), this.options.isSortSchemaTypes());
                ClientGenUtil.setupJsService(this.definitions, qName, this.processInfo, this.options.isAutoDetectWrapped(), this.options.isFillIncompleteParameterOrderList());
            }
        }
    }

    private boolean useWLW81Types() {
        if (this.processInfo.getWebServiceJClass() == null) {
            return false;
        }
        return this.processInfo.getWebServiceJClass().getAnnotation(UseWLW81BindingTypes.class) != null;
    }

    private void cleanupMetaInf(File file) {
        File file2;
        File file3;
        File file4;
        File file5 = new File(file, "META-INF/binding-file.xml");
        if (file5.exists()) {
            file5.delete();
        }
        if ((file4 = new File(file, "META-INF/binding-file.ser")).exists()) {
            file4.delete();
        }
        if ((file3 = new File(file, "META-INF/binding-mapping-file.ser")).exists()) {
            file3.delete();
        }
        if ((file2 = new File(file, "META-INF")).exists() && file2.listFiles().length == 0) {
            file2.delete();
        }
    }

    private void writeWsdl(ProcessInfo processInfo) throws WsBuildException {
        block6: {
            try {
                File file;
                String string = processInfo.getPackageName().replace('.', '/');
                String string2 = string + "/" + processInfo.getWsdlFileName();
                File file2 = processInfo.getDestDir();
                File file3 = new File(file2, string2);
                WsdlDefinitionsBuilder wsdlDefinitionsBuilder = (WsdlDefinitionsBuilder)processInfo.getJsService().getWsdlService().getDefinitions();
                wsdlDefinitionsBuilder.writeToFile(file3, "UTF-8");
                String string3 = processInfo.getWsdlUrl();
                if (string3 == null) break block6;
                try {
                    file = new File(new URL(string3).getPath());
                }
                catch (MalformedURLException malformedURLException) {
                    file = new File(string3);
                }
                if (file.exists()) {
                    File file4 = new File(file2, string + "/" + file.getName());
                    wsdlDefinitionsBuilder.writeToFile(file4, "UTF-8");
                }
            }
            catch (IOException iOException) {
                throw new WsBuildException(iOException);
            }
            catch (WsdlException wsdlException) {
                wsdlException.printStackTrace();
                throw new WsBuildException(wsdlException);
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n*********** jax-rpc clientgen attribute settings ***************\n\n");
        stringBuilder.append("wsdlURI: " + this.processInfo.getWsdlUrl() + "\n");
        stringBuilder.append("serviceName : " + this.processInfo.getServiceName() + "\n");
        stringBuilder.append("packageName : " + this.processInfo.getPackageName() + "\n");
        stringBuilder.append("destDir : " + this.processInfo.getDestDir() + "\n");
        stringBuilder.append("handlerChainFile : " + this.processInfo.getHandlerChain() + "\n");
        stringBuilder.append("generatePolicyMethods : " + this.processInfo.getGeneratePolicyMethods() + "\n");
        stringBuilder.append("autoDetectWrapped : " + this.options.isAutoDetectWrapped() + "\n");
        stringBuilder.append("jaxRPCWrappedArrayStyle : " + this.processInfo.isJaxRPCWrappedArrayStyle() + "\n");
        stringBuilder.append("generateAsyncMethods : " + this.processInfo.isGenerateAsyncMethods() + "\n");
        stringBuilder.append("\n*********** jax-rpc clientgen attribute settings end ***************\n");
        return stringBuilder.toString();
    }

    private void setSystemProperties() {
        Properties properties = this.options.getSystemProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            System.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void resetSystemProperties() {
        Properties properties = this.options.getSystemProperties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            System.setProperty((String)enumeration.nextElement(), "");
        }
    }
}

