/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.clientgen.jaxrpc;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import weblogic.wsee.bind.TypeFamily;
import weblogic.wsee.tools.clientgen.jaxrpc.ClientGenProcessor;
import weblogic.wsee.util.Verbose;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Options {
    private String serviceName;
    private File handlerChain;
    private boolean generatePolicyMethods;
    private boolean jaxRPCWrappedArrayStyle = true;
    private boolean generateAsyncMethods = true;
    private TypeFamily typeFamily = TypeFamily.TYLAR;
    private boolean autoDetectWrapped = true;
    private boolean includeGlobalTypes = false;
    private boolean sortSchemaTypes = false;
    private boolean fillIncompleteParameterOrderList = false;
    private Properties systemProperties = new Properties();
    private boolean writeJavaTypes = true;
    private boolean useJaxRpcRules = true;
    private List<ClientGenProcessor> processors = new ArrayList<ClientGenProcessor>();
    private boolean allowWrappedArrayForDocLiteral = false;
    private static HashSet<String> supportedSysPropNames = new HashSet();

    public void addSysemProperty(String string, String string2) {
        if (supportedSysPropNames.contains(string)) {
            this.systemProperties.setProperty(string, string2);
        } else {
            Verbose.say("System property \"" + string2 + "\" is not supported");
        }
    }

    Properties getSystemProperties() {
        return this.systemProperties;
    }

    boolean isWriteJavaTypes() {
        return this.writeJavaTypes;
    }

    public void setWriteJavaTypes(boolean bl) {
        this.writeJavaTypes = bl;
    }

    String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String string) {
        if (string != null) {
            string = string.trim();
        }
        this.serviceName = string;
    }

    File getHandlerChain() {
        return this.handlerChain;
    }

    public void setHandlerChain(File file) {
        this.handlerChain = file;
    }

    boolean isGeneratePolicyMethods() {
        return this.generatePolicyMethods;
    }

    public void setGeneratePolicyMethods(boolean bl) {
        this.generatePolicyMethods = bl;
    }

    boolean isJaxRPCWrappedArrayStyle() {
        return this.jaxRPCWrappedArrayStyle;
    }

    public void setJaxRPCWrappedArrayStyle(boolean bl) {
        this.jaxRPCWrappedArrayStyle = bl;
    }

    boolean isGenerateAsyncMethods() {
        return this.generateAsyncMethods;
    }

    public void setGenerateAsyncMethods(boolean bl) {
        this.generateAsyncMethods = bl;
    }

    TypeFamily getTypeFamily() {
        return this.typeFamily;
    }

    public void setTypeFamily(TypeFamily typeFamily) {
        this.typeFamily = typeFamily;
    }

    boolean isAutoDetectWrapped() {
        return this.autoDetectWrapped;
    }

    public void setAutoDetectWrapped(boolean bl) {
        this.autoDetectWrapped = bl;
    }

    boolean isIncludeGlobalTypes() {
        return this.includeGlobalTypes;
    }

    public void setIncludeGlobalTypes(boolean bl) {
        this.includeGlobalTypes = bl;
    }

    boolean isSortSchemaTypes() {
        return this.sortSchemaTypes;
    }

    public void setSortSchemaTypes(boolean bl) {
        this.sortSchemaTypes = bl;
    }

    public void setFillIncompleteParameterOrderList(boolean bl) {
        this.fillIncompleteParameterOrderList = bl;
    }

    public boolean isFillIncompleteParameterOrderList() {
        return this.fillIncompleteParameterOrderList;
    }

    boolean isUseJaxRpcRules() {
        return this.useJaxRpcRules;
    }

    public void setUseJaxRpcRules(boolean bl) {
        this.useJaxRpcRules = bl;
    }

    public void addProcessor(ClientGenProcessor clientGenProcessor) {
        this.processors.add(clientGenProcessor);
    }

    List<ClientGenProcessor> getProcessors() {
        return this.processors;
    }

    public void setAllowWrappedArrayForDocLiteral(boolean bl) {
        this.allowWrappedArrayForDocLiteral = bl;
    }

    public boolean isAllowWrappedArrayForDocLiteral() {
        return this.allowWrappedArrayForDocLiteral;
    }

    static {
        supportedSysPropNames.add("javax.xml.rpc.security.auth.username");
        supportedSysPropNames.add("javax.xml.rpc.security.auth.password");
        supportedSysPropNames.add("javax.net.ssl.trustStore");
        supportedSysPropNames.add("javax.net.ssl.trustStorePassword");
        supportedSysPropNames.add("javax.net.ssl.keyStore");
        supportedSysPropNames.add("javax.net.ssl.keyStorePassword");
        supportedSysPropNames.add("weblogic.wsee.client.ssl.stricthostchecking");
        supportedSysPropNames.add("java.protocol.handler.pkgs");
        supportedSysPropNames.add("weblogic.security.SSL.trustedCAKeyStore");
        supportedSysPropNames.add("weblogic.security.SSL.ignoreHostnameVerification");
    }
}

