/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.clientgen.jaxws;

import com.sun.tools.ws.ant.WsImport2;
import com.sun.xml.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.ws.api.streaming.XMLStreamWriterFactory;
import java.io.File;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.anttasks.AntUtil;
import weblogic.wsee.tools.clientgen.ClientGen;
import weblogic.wsee.tools.clientgen.jaxws.Options;
import weblogic.wsee.tools.logging.BuildListenerLogger;
import weblogic.wsee.tools.logging.DefaultLogger;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.tools.logging.Logger;
import weblogic.wsee.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientGenImpl
implements ClientGen<Options> {
    private File destDir = null;
    private String packageName = null;
    private String wsdl = null;
    private File[] bindingFiles = null;
    private Options options = new Options();
    private Logger logger = new DefaultLogger();

    @Override
    public void setDestDir(File file) {
        this.destDir = file;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger == null ? new DefaultLogger() : logger;
    }

    @Override
    public void setPackageName(String string) {
        if (string != null) {
            string = string.trim();
        }
        this.packageName = string;
    }

    @Override
    public void setWsdl(String string) {
        this.wsdl = string;
    }

    @Override
    public void setBindingFiles(File[] fileArray) {
        this.bindingFiles = fileArray;
    }

    private void validate() throws WsBuildException {
        boolean bl = true;
        if (StringUtil.isEmpty(this.wsdl)) {
            this.logger.log(EventLevel.ERROR, "No wsdl specified");
            bl = false;
        }
        if (this.destDir == null) {
            this.logger.log(EventLevel.ERROR, "No destDir specified");
            bl = false;
        }
        if (!bl) {
            throw new WsBuildException("ClientGen invalid - see log for details");
        }
    }

    private void setSystemProperties() {
        Properties properties = this.options.getSystemProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            System.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void resetSystemProperties() {
        Properties properties = this.options.getSystemProperties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            System.setProperty((String)enumeration.nextElement(), "");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute() throws WsBuildException {
        this.validate();
        if (!this.destDir.exists()) {
            this.destDir.mkdirs();
        }
        Project project = new Project();
        project.setBaseDir(this.destDir.getAbsoluteFile());
        project.addBuildListener((BuildListener)new BuildListenerLogger(this.logger));
        WsImport2 wsImport2 = new WsImport2();
        wsImport2.setProject(project);
        wsImport2.setDestdir(this.destDir);
        wsImport2.setSourcedestdir(this.destDir);
        wsImport2.setPackage(this.packageName);
        wsImport2.setWsdl(this.wsdl);
        wsImport2.setDebug(this.options.isDebug());
        wsImport2.setVerbose(this.options.isVerbose());
        wsImport2.setExtension(true);
        wsImport2.setFailonerror(this.options.isFailonerror());
        wsImport2.setFork(this.options.isFork());
        wsImport2.setIncludeantruntime(this.options.isIncludeantruntime());
        wsImport2.setIncludejavaruntime(this.options.isIncludejavaruntime());
        wsImport2.setOptimize(this.options.isOptimize());
        wsImport2.setXauthfile(this.options.getXauthfile());
        if (this.options.getCatalog() != null) {
            wsImport2.setCatalog(this.options.getCatalog());
        }
        if (this.options.getXmlCatalog() != null) {
            if (this.options.getCatalog() == null) {
                wsImport2.setCatalog(new File("fake_cfile_123.xml"));
            }
            wsImport2.addConfiguredXMLCatalog(this.options.getXmlCatalog());
        }
        for (FileSet object : AntUtil.getFileSets(this.bindingFiles, project)) {
            wsImport2.addConfiguredBinding(object);
        }
        for (FileSet fileSet : this.options.getConfiguredDepends()) {
            wsImport2.addConfiguredDepends(fileSet);
        }
        for (FileSet fileSet : this.options.getConfiguredProduces()) {
            wsImport2.addConfiguredProduces(fileSet);
        }
        if (this.options.getWsdllocationOverride() != null) {
            wsImport2.setWsdllocation(this.options.getWsdllocationOverride());
        }
        this.setSystemProperties();
        try {
            wsImport2.execute();
        }
        catch (BuildException buildException) {
            void var4_11;
            BuildException buildException2 = buildException;
            while (var4_11 != null && var4_11.getCause() != null && var4_11 instanceof BuildException) {
                Throwable throwable = var4_11.getCause();
            }
            throw new WsBuildException("Error running JAX-WS clientgen: " + var4_11.getLocalizedMessage(), buildException);
        }
        finally {
            this.resetSystemProperties();
        }
    }

    @Override
    public void setOptions(Options options) {
        this.options = options == null ? new Options() : options;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n*********** jax-ws clientgen attribute settings ***************\n\n");
        stringBuilder.append("wsdlURI: " + this.wsdl + "\n");
        stringBuilder.append("packageName : " + this.packageName + "\n");
        stringBuilder.append("destDir : " + this.destDir + "\n");
        stringBuilder.append("\n*********** jax-ws clientgen attribute settings end ***************\n");
        return stringBuilder.toString();
    }

    static {
        System.setProperty(XMLStreamWriterFactory.class.getName() + ".woodstox", "true");
        System.setProperty(XMLStreamReaderFactory.class.getName() + ".woodstox", "true");
    }
}

