/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.clientgen.mapping;

import com.bea.staxb.buildtime.internal.bts.XmlTypeName;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.j2ee.descriptor.ConstructorParameterOrderBean;
import weblogic.j2ee.descriptor.ExceptionMappingBean;
import weblogic.j2ee.descriptor.JavaWsdlMappingBean;
import weblogic.j2ee.descriptor.MethodParamPartsMappingBean;
import weblogic.j2ee.descriptor.PackageMappingBean;
import weblogic.j2ee.descriptor.PortMappingBean;
import weblogic.j2ee.descriptor.ServiceEndpointInterfaceMappingBean;
import weblogic.j2ee.descriptor.ServiceEndpointMethodMappingBean;
import weblogic.j2ee.descriptor.ServiceInterfaceMappingBean;
import weblogic.j2ee.descriptor.WsdlMessageMappingBean;
import weblogic.j2ee.descriptor.WsdlReturnValueMappingBean;
import weblogic.wsee.bind.buildtime.BuildtimeBindings;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.clientgen.ProcessInfo;
import weblogic.wsee.tools.clientgen.jaxrpc.ClientGenProcessor;
import weblogic.wsee.tools.source.JsFault;
import weblogic.wsee.tools.source.JsMethod;
import weblogic.wsee.tools.source.JsParameterType;
import weblogic.wsee.tools.source.JsPort;
import weblogic.wsee.util.NamespaceSpecifyingDescriptorManager;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.wsdl.WsdlMessage;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlService;

public class JaxrpcMappingProcessor
implements ClientGenProcessor {
    private static final boolean VERBOSE = Verbose.isVerbose(JaxrpcMappingProcessor.class);
    private ProcessInfo info;
    private JavaWsdlMappingBean jwmb;
    private String tns;

    public void process(ProcessInfo processInfo) throws WsBuildException {
        this.info = processInfo;
        this.tns = processInfo.getJsService().getWsdlService().getDefinitions().getTargetNamespace();
        EditableDescriptorManager editableDescriptorManager = new EditableDescriptorManager();
        this.jwmb = (JavaWsdlMappingBean)editableDescriptorManager.createDescriptorRoot(JavaWsdlMappingBean.class).getRootBean();
        this.createPackageMapping();
        this.createBindingMapping();
        this.createServiceInterfaceMapping();
        Iterator iterator = processInfo.getJsService().getPorts();
        while (iterator.hasNext()) {
            JsPort jsPort = (JsPort)iterator.next();
            this.createServiceEndpointInterfaceMapping(jsPort);
            this.createExceptionMapping(jsPort);
        }
        this.writeout();
    }

    private void createBindingMapping() {
        BuildtimeBindings buildtimeBindings = this.info.getBuildtimeBindings();
        buildtimeBindings.generate109Descriptor(this.jwmb);
    }

    private void createPackageMapping() {
        PackageMappingBean packageMappingBean = this.jwmb.createPackageMapping();
        packageMappingBean.setNamespaceURI(this.tns);
        packageMappingBean.setPackageType(this.info.getPackageName());
    }

    private void createServiceInterfaceMapping() {
        if (this.info.isPartialWsdl()) {
            return;
        }
        ServiceInterfaceMappingBean serviceInterfaceMappingBean = this.jwmb.createServiceInterfaceMapping();
        serviceInterfaceMappingBean.setServiceInterface(this.info.getPackageName() + "." + this.info.getStubInfo().getServiceName());
        WsdlService wsdlService = this.info.getJsService().getWsdlService();
        serviceInterfaceMappingBean.setWsdlServiceName(wsdlService.getName());
        Iterator iterator = this.info.getJsService().getPorts();
        while (iterator.hasNext()) {
            JsPort jsPort = (JsPort)iterator.next();
            PortMappingBean portMappingBean = serviceInterfaceMappingBean.createPortMapping();
            String string = jsPort.getWsdlPort().getName().getLocalPart();
            portMappingBean.setPortName(string);
            portMappingBean.setJavaPortName(this.info.getStubInfo().getPortNameMap().get(string));
        }
    }

    private void createServiceEndpointInterfaceMapping(JsPort jsPort) {
        ServiceEndpointInterfaceMappingBean serviceEndpointInterfaceMappingBean = this.jwmb.createServiceEndpointInterfaceMapping();
        WsdlPort wsdlPort = jsPort.getWsdlPort();
        serviceEndpointInterfaceMappingBean.setWsdlBinding(wsdlPort.getBinding().getName());
        serviceEndpointInterfaceMappingBean.setWsdlPortType(wsdlPort.getPortType().getName());
        Map<String, String> map = this.info.getStubInfo().getPortTypeNameMap();
        serviceEndpointInterfaceMappingBean.setServiceEndpointInterface(this.info.getPackageName() + "." + map.get(wsdlPort.getPortType().getName().getLocalPart()));
        JsMethod[] jsMethodArray = jsPort.getEndpoint().getMethods();
        for (int i = 0; i < jsMethodArray.length; ++i) {
            JsMethod jsMethod = jsMethodArray[i];
            ServiceEndpointMethodMappingBean serviceEndpointMethodMappingBean = serviceEndpointInterfaceMappingBean.createServiceEndpointMethodMapping();
            WsdlOperation wsdlOperation = wsdlPort.getPortType().getOperations().get(jsMethod.getOperationName());
            this.fillMethodMapping(serviceEndpointMethodMappingBean, jsMethod, wsdlOperation);
        }
    }

    private void createExceptionMapping(JsPort jsPort) {
        JsMethod[] jsMethodArray = jsPort.getEndpoint().getMethods();
        for (int i = 0; i < jsMethodArray.length; ++i) {
            JsMethod jsMethod = jsMethodArray[i];
            if (VERBOSE) {
                Verbose.log(" createExceptionMapping for JsMethod " + jsMethod.getMethodName());
            }
            JsFault[] jsFaultArray = jsMethod.getFaults();
            for (int j = 0; j < jsFaultArray.length; ++j) {
                ExceptionMappingBean exceptionMappingBean = this.jwmb.createExceptionMapping();
                QName qName = jsFaultArray[j].getFaultMessage();
                String string = jsFaultArray[j].getPartName();
                String string2 = jsFaultArray[j].getJsr109MappingFileExceptionClass();
                exceptionMappingBean.setExceptionType(string2);
                exceptionMappingBean.setWsdlMessage(qName);
                exceptionMappingBean.setWsdlMessagePartName(string);
                List list = jsFaultArray[j].getConstructorElementNames();
                if (VERBOSE) {
                    Verbose.log(" fault type " + string2 + ", message " + qName + ", partName " + string + ", has " + list.size() + " element names in its constructor ");
                }
                if (list.size() <= 0) continue;
                ConstructorParameterOrderBean constructorParameterOrderBean = exceptionMappingBean.createConstructorParameterOrder();
                for (QName qName2 : list) {
                    if (VERBOSE) {
                        Verbose.log("  element name " + qName2.getLocalPart() + " add to ConstructorParameterOrderBean");
                    }
                    constructorParameterOrderBean.addElementName(qName2.getLocalPart());
                }
            }
        }
    }

    private void fillMethodMapping(ServiceEndpointMethodMappingBean serviceEndpointMethodMappingBean, JsMethod jsMethod, WsdlOperation wsdlOperation) {
        serviceEndpointMethodMappingBean.setJavaMethodName(jsMethod.getMethodName());
        serviceEndpointMethodMappingBean.setWsdlOperation(jsMethod.getOperationName().getLocalPart());
        if (jsMethod.isWrapped()) {
            serviceEndpointMethodMappingBean.createWrappedElement();
        }
        int n = 0;
        JsParameterType[] jsParameterTypeArray = jsMethod.getArguments();
        for (int i = 0; i < jsParameterTypeArray.length; ++i) {
            JsParameterType jsParameterType = jsParameterTypeArray[i];
            MethodParamPartsMappingBean methodParamPartsMappingBean = serviceEndpointMethodMappingBean.createMethodParamPartsMapping();
            methodParamPartsMappingBean.setParamPosition(n++);
            if (jsParameterType.getNonHolderType() != null) {
                methodParamPartsMappingBean.setParamType(jsParameterType.getNonHolderType());
            } else {
                methodParamPartsMappingBean.setParamType(jsParameterType.getType());
            }
            this.fillParamMapping(methodParamPartsMappingBean, wsdlOperation, jsParameterType);
        }
        this.createReturnMapping(serviceEndpointMethodMappingBean, wsdlOperation, jsMethod);
    }

    private void fillParamMapping(MethodParamPartsMappingBean methodParamPartsMappingBean, WsdlOperation wsdlOperation, JsParameterType jsParameterType) {
        WsdlMessageMappingBean wsdlMessageMappingBean = methodParamPartsMappingBean.createWsdlMessageMapping();
        wsdlMessageMappingBean.setParameterMode(jsParameterType.getModeAsString());
        if (jsParameterType.isSoapHeader()) {
            wsdlMessageMappingBean.createSoapHeader();
        }
        WsdlMessage wsdlMessage = null;
        wsdlMessage = jsParameterType.getMode() == 1 ? wsdlOperation.getOutput() : wsdlOperation.getInput();
        wsdlMessageMappingBean.setWsdlMessage(wsdlMessage.getName());
        if (jsParameterType.getPartName().equals(XmlTypeName.ANY_ELEMENT_WILDCARD_ELEMENT_NAME.getLocalPart()) || jsParameterType.getPartName().equals(XmlTypeName.ANY_ELEMENT_WILDCARD_ARRAY_ELEMENT_NAME.getLocalPart())) {
            wsdlMessageMappingBean.setWsdlMessagePartName("");
        } else {
            wsdlMessageMappingBean.setWsdlMessagePartName(jsParameterType.getPartName());
        }
    }

    private void createReturnMapping(ServiceEndpointMethodMappingBean serviceEndpointMethodMappingBean, WsdlOperation wsdlOperation, JsMethod jsMethod) {
        if (jsMethod.getReturnType() == null) {
            return;
        }
        if ("void".equals(jsMethod.getReturnType().getType())) {
            return;
        }
        WsdlReturnValueMappingBean wsdlReturnValueMappingBean = serviceEndpointMethodMappingBean.createWsdlReturnValueMapping();
        wsdlReturnValueMappingBean.setMethodReturnValue(jsMethod.getReturnType().getType());
        wsdlReturnValueMappingBean.setWsdlMessage(wsdlOperation.getOutput().getName());
        if (jsMethod.getReturnType().getPartName().equals(XmlTypeName.ANY_ELEMENT_WILDCARD_ELEMENT_NAME.getLocalPart()) || jsMethod.getReturnType().getPartName().equals(XmlTypeName.ANY_ELEMENT_WILDCARD_ARRAY_ELEMENT_NAME.getLocalPart())) {
            wsdlReturnValueMappingBean.setWsdlMessagePartName("");
        } else {
            wsdlReturnValueMappingBean.setWsdlMessagePartName(jsMethod.getReturnType().getPartName());
        }
    }

    private void writeout() throws WsBuildException {
        Object object;
        File file = null;
        if (this.info.getMappingFileUri() == null) {
            object = this.info.getPackageName().replace('.', '/');
            object = (String)object + "/" + this.info.getMappingFileName();
            this.info.setMappingFileUri((String)object);
            file = new File(this.info.getDestDir(), (String)object);
        } else {
            file = new File(this.info.getDestDir(), this.info.getMappingFileUri());
        }
        object = null;
        try {
            file.getParentFile().mkdirs();
            object = new FileOutputStream(file);
            DescriptorBean descriptorBean = (DescriptorBean)this.jwmb;
            new NamespaceSpecifyingDescriptorManager().writeDescriptorAsXML(descriptorBean.getDescriptor(), (OutputStream)object, "UTF-8");
        }
        catch (IOException iOException) {
            throw new WsBuildException(iOException);
        }
        finally {
            try {
                ((OutputStream)object).close();
            }
            catch (Throwable throwable) {}
        }
    }
}

