/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.clientgen.serviceref;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.application.descriptor.NamespaceURIMunger;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.j2ee.descriptor.ParamValueBean;
import weblogic.j2ee.descriptor.ServiceRefBean;
import weblogic.j2ee.descriptor.ServiceRefHandlerBean;
import weblogic.j2ee.descriptor.wl.WeblogicWseeClientHandlerChainBean;
import weblogic.j2ee.descriptor.wl.WeblogicWseeStandaloneclientBean;
import weblogic.wsee.tools.WsBuildException;
import weblogic.wsee.tools.clientgen.ProcessInfo;
import weblogic.wsee.tools.clientgen.jaxrpc.ClientGenProcessor;

public class ServiceRefProcessor
implements ClientGenProcessor {
    ProcessInfo info;

    public void process(ProcessInfo processInfo) throws WsBuildException {
        this.info = processInfo;
        EditableDescriptorManager editableDescriptorManager = new EditableDescriptorManager();
        WeblogicWseeStandaloneclientBean weblogicWseeStandaloneclientBean = (WeblogicWseeStandaloneclientBean)editableDescriptorManager.createDescriptorRoot(WeblogicWseeStandaloneclientBean.class).getRootBean();
        ServiceRefBean serviceRefBean = weblogicWseeStandaloneclientBean.createServiceRef();
        serviceRefBean.setServiceQname(processInfo.getJsService().getWsdlService().getName());
        serviceRefBean.setServiceRefName("unused information");
        serviceRefBean.setServiceInterface(processInfo.getPackageName() + "." + processInfo.getStubInfo().getServiceName());
        String string = processInfo.getPackageName().replace('.', '/') + "/";
        serviceRefBean.setWsdlFile(string + processInfo.getWsdlFileName());
        serviceRefBean.setJaxrpcMappingFile(string + processInfo.getMappingFileName());
        this.fillHandlerChain(serviceRefBean);
        this.writeout(weblogicWseeStandaloneclientBean, string);
    }

    private void fillHandlerChain(ServiceRefBean serviceRefBean) throws WsBuildException {
        ServiceRefHandlerBean[] serviceRefHandlerBeanArray;
        File file = this.info.getHandlerChain();
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            throw new WsBuildException("Handler chain file " + file.getAbsolutePath() + " doesn't exist.");
        }
        FileInputStream fileInputStream = null;
        WeblogicWseeClientHandlerChainBean weblogicWseeClientHandlerChainBean = null;
        try {
            fileInputStream = new FileInputStream(file);
            serviceRefHandlerBeanArray = new DescriptorManager();
            String[] stringArray = new String[]{"http://www.bea.com/ns/weblogic/90", "http://www.bea.com/ns/weblogic/weblogic-wsee-clientHandlerChain"};
            weblogicWseeClientHandlerChainBean = (WeblogicWseeClientHandlerChainBean)serviceRefHandlerBeanArray.createDescriptor((XMLStreamReader)new NamespaceURIMunger(fileInputStream, "http://xmlns.oracle.com/weblogic/weblogic-wsee-clientHandlerChain", stringArray)).getRootBean();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WsBuildException("Failed to load handler chain file " + xMLStreamException, xMLStreamException);
        }
        catch (ClassCastException classCastException) {
            throw new WsBuildException("Failed to load handler chain file " + classCastException, classCastException);
        }
        catch (IOException iOException) {
            throw new WsBuildException("Failed to load handler chain file " + iOException, iOException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        serviceRefHandlerBeanArray = weblogicWseeClientHandlerChainBean.getHandlers();
        for (int i = 0; i < serviceRefHandlerBeanArray.length; ++i) {
            ServiceRefHandlerBean serviceRefHandlerBean = serviceRefHandlerBeanArray[i];
            this.copyHandlerInfo(serviceRefHandlerBean, serviceRefBean.createHandler());
        }
    }

    private void copyHandlerInfo(ServiceRefHandlerBean serviceRefHandlerBean, ServiceRefHandlerBean serviceRefHandlerBean2) {
        String[] stringArray = serviceRefHandlerBean.getDescriptions();
        for (int i = 0; i < stringArray.length; ++i) {
            serviceRefHandlerBean2.addDescription(stringArray[i]);
        }
        String[] stringArray2 = serviceRefHandlerBean.getDisplayNames();
        for (int i = 0; i < stringArray2.length; ++i) {
            serviceRefHandlerBean2.addDisplayName(stringArray2[i]);
        }
        String[] stringArray3 = serviceRefHandlerBean.getPortNames();
        for (int i = 0; i < stringArray3.length; ++i) {
            serviceRefHandlerBean2.addPortName(stringArray3[i]);
        }
        String[] stringArray4 = serviceRefHandlerBean.getSoapRoles();
        for (int i = 0; i < stringArray4.length; ++i) {
            serviceRefHandlerBean2.addSoapRole(stringArray4[i]);
        }
        QName[] qNameArray = serviceRefHandlerBean.getSoapHeaders();
        for (int i = 0; i < qNameArray.length; ++i) {
            serviceRefHandlerBean2.addSoapHeader(qNameArray[i]);
        }
        serviceRefHandlerBean2.setHandlerClass(serviceRefHandlerBean.getHandlerClass());
        serviceRefHandlerBean2.setHandlerName(serviceRefHandlerBean.getHandlerName());
        ParamValueBean[] paramValueBeanArray = serviceRefHandlerBean.getInitParams();
        for (int i = 0; i < paramValueBeanArray.length; ++i) {
            ParamValueBean paramValueBean = paramValueBeanArray[i];
            ParamValueBean paramValueBean2 = serviceRefHandlerBean2.createInitParam();
            paramValueBean2.setParamName(paramValueBean.getParamName());
            paramValueBean2.setParamValue(paramValueBean.getParamValue());
            String[] stringArray5 = paramValueBean.getDescriptions();
            for (int j = 0; j < stringArray5.length; ++j) {
                paramValueBean2.addDescription(stringArray5[j]);
            }
        }
    }

    private void writeout(WeblogicWseeStandaloneclientBean weblogicWseeStandaloneclientBean, String string) throws WsBuildException {
        String string2 = string + this.info.getStubInfo().getServiceName() + "_internaldd.xml";
        File file = new File(this.info.getDestDir(), string2);
        OutputStream outputStream = null;
        try {
            file.getParentFile().mkdirs();
            outputStream = new FileOutputStream(file);
            DescriptorBean descriptorBean = (DescriptorBean)weblogicWseeStandaloneclientBean;
            new EditableDescriptorManager().writeDescriptorAsXML(descriptorBean.getDescriptor(), outputStream, "UTF-8");
        }
        catch (IOException iOException) {
            throw new WsBuildException(iOException);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

