/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.tools.clientgen.stubgen;

import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JClass;
import com.bea.util.jam.JMethod;
import com.bea.util.jam.JParameter;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.rpc.JAXRPCException;
import weblogic.jws.Conversation;
import weblogic.wsee.jws.CallbackInterface;
import weblogic.wsee.tools.clientgen.stubgen.JavaFileGenBase;
import weblogic.wsee.tools.source.JsClass;
import weblogic.wsee.tools.source.JsMethod;
import weblogic.wsee.tools.source.JsParameterType;
import weblogic.wsee.util.JamUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StubBase
extends JavaFileGenBase {
    protected boolean generateAsyncMethod = false;
    protected boolean onlyConvenienceMethod = false;
    protected JsClass endpoint;
    protected String portTypeName;
    protected String serviceClassName;
    private String callbackInterface;
    protected Map portNameMap;
    private Boolean hasCallbackApi = null;
    private JClass callback = null;
    private static String callbackInterfaceMethods = null;

    public void setOnlyConvenienceMethod(boolean bl) {
        this.onlyConvenienceMethod = bl;
    }

    public void setGenerateAsyncMethod(boolean bl) {
        this.generateAsyncMethod = bl;
    }

    public void setEndpoint(JsClass jsClass) {
        this.endpoint = jsClass;
    }

    public void setPortTypeName(String string) {
        this.portTypeName = string;
    }

    public void setServiceClassName(String string) {
        this.serviceClassName = string;
    }

    public void setCallback(JClass jClass) {
        this.callback = jClass;
    }

    public void setCallbackInterface(String string) {
        this.callbackInterface = string;
    }

    protected String getCallbackInterface() {
        return "";
    }

    public void setPortNameMap(Map map) {
        this.portNameMap = map;
    }

    protected String firstLetterCap(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1, string.length());
    }

    protected String wrap(JsParameterType jsParameterType) {
        String string = jsParameterType.getType();
        String string2 = jsParameterType.getParamName();
        String string3 = string.equals("float") ? "new Float(" + string2 + ")" : (string.equals("int") ? "new Integer(" + string2 + ")" : (string.equals("long") ? "new Long(" + string2 + ")" : (string.equals("boolean") ? "new Boolean(" + string2 + ")" : (string.equals("short") ? "new Short(" + string2 + ")" : (string.equals("double") ? "new Double(" + string2 + ")" : (string.equals("byte") ? "new Byte(" + string2 + ")" : string2))))));
        return string3;
    }

    public String convertInnerClassCallbackName(String string) {
        String string2 = "";
        if (string != null || !string.equals("")) {
            string2 = string.replace('$', '.');
        }
        return string2;
    }

    public boolean hasCallbackApi() {
        if (this.hasCallbackApi != null) {
            return this.hasCallbackApi;
        }
        this.hasCallbackApi = new Boolean(this.callbackInterface != null);
        return this.hasCallbackApi;
    }

    public String callbackApiPreInvoke() {
        if (this.hasCallbackApi()) {
            return "cbapistub.invokePrep();";
        }
        return "";
    }

    private Class getType(String string) {
        try {
            if (string.indexOf("int") != -1) {
                return Integer.TYPE;
            }
            if (string.indexOf("float") != -1) {
                return Float.TYPE;
            }
            if (string.indexOf("long") != -1) {
                return Long.TYPE;
            }
            if (string.indexOf("double") != -1) {
                return Double.TYPE;
            }
            if (string.indexOf("char") != -1) {
                return Character.TYPE;
            }
            if (string.indexOf("boolean") != -1) {
                return Boolean.TYPE;
            }
            return Thread.currentThread().getContextClassLoader().loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw new IllegalStateException(classNotFoundException);
        }
    }

    private boolean compareJMethod(JMethod jMethod, String string, String[] stringArray) {
        if (!string.equals(jMethod.getSimpleName())) {
            return false;
        }
        JParameter[] jParameterArray = jMethod.getParameters();
        if (stringArray.length != jParameterArray.length) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(jParameterArray[i].getType().getQualifiedName())) continue;
            return false;
        }
        return true;
    }

    public String finishCallbackStubConversation(JsMethod jsMethod) {
        JMethod[] jMethodArray;
        if (this.callback == null) {
            return "";
        }
        String string = jsMethod.getMethodName();
        JsParameterType[] jsParameterTypeArray = jsMethod.getArguments();
        String[] stringArray = new String[jsParameterTypeArray.length];
        for (int i = 0; i < jsParameterTypeArray.length; ++i) {
            stringArray[i] = jsParameterTypeArray[i].getType();
        }
        for (JMethod jMethod : jMethodArray = this.callback.getMethods()) {
            if (!this.compareJMethod(jMethod, string, stringArray)) continue;
            JAnnotation jAnnotation = jMethod.getAnnotation(Conversation.class);
            if (jAnnotation != null && JamUtil.getAnnotationEnumValue(jAnnotation, "value", Conversation.Phase.class, Conversation.Phase.CONTINUE) == Conversation.Phase.FINISH) {
                return "weblogic.wsee.util.ControlAPIUtil.finishCallbackStubConversation(this);";
            }
            return "";
        }
        return "";
    }

    public String generateCallbackInterfaceMethods() {
        if (!this.hasCallbackApi()) {
            return "";
        }
        if (callbackInterfaceMethods != null) {
            return callbackInterfaceMethods;
        }
        Class<CallbackInterface> clazz = CallbackInterface.class;
        Method[] methodArray = clazz.getDeclaredMethods();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("private weblogic.wsee.callback.CallbackStubImpl cbapistub = new weblogic.wsee.callback.CallbackStubImpl(this);\n");
        if (methodArray != null) {
            for (Method method : methodArray) {
                String string;
                StringBuilder stringBuilder2 = new StringBuilder();
                String string2 = method.toGenericString();
                Class<?> clazz2 = method.getReturnType();
                if (clazz2 != null && !"void".equals(clazz2.getCanonicalName())) {
                    stringBuilder2.append("return ");
                }
                stringBuilder2.append("cbapistub.");
                stringBuilder2.append(method.getName());
                stringBuilder2.append("(");
                int n = string2.indexOf(clazz.getName());
                string2 = string2.replaceFirst("abstract", "");
                string2 = string2.replaceFirst(clazz.getName() + ".", "");
                int n2 = string2.indexOf("throws");
                String string3 = "";
                if (n2 >= 0) {
                    string3 = string2.substring(n2);
                    string2 = string2.substring(0, n2);
                }
                int n3 = 1;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                StringBuilder stringBuilder3 = new StringBuilder();
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    stringBuilder3.append(string);
                    if (!stringTokenizer.hasMoreTokens()) continue;
                    String string4 = "v" + n3++ + ", ";
                    stringBuilder2.append(string4);
                    stringBuilder3.append(" ");
                    stringBuilder3.append(string4);
                }
                string2 = stringBuilder3.toString();
                if (string2.indexOf("()") < 0) {
                    string = "v" + n3++;
                    stringBuilder2.append(string);
                    string2 = string2.replaceAll("\\)", " " + string + ")");
                }
                string2 = string2 + string3;
                stringBuilder2.append(");");
                stringBuilder.append(string2);
                stringBuilder.append("\n{\n   ");
                stringBuilder.append(stringBuilder2.toString());
                stringBuilder.append("\n}\n");
            }
        }
        callbackInterfaceMethods = stringBuilder.toString();
        return callbackInterfaceMethods;
    }

    @Override
    public Class<? extends Throwable> getRemoteExceptionClass() {
        if (this.callbackInterface == null) {
            return super.getRemoteExceptionClass();
        }
        return JAXRPCException.class;
    }
}

